/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdictions. Portions copyright Microsoft
 * Corporation.  All rights reserved.
 * 
 * Trademark:
 * ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdictions.
 * 
 * Description:
 * Designed in 1902 by Morris Fuller Benton for the American Type Founders
 * company, Franklin Gothic still reigns as one of the most-widely used sans serif
 * typefaces. Originally issued in only one weight, the ATF version of Franklin
 * Gothic was eventually expanded to include five additional weights, but no light
 * or intermediate weights were ever developed. In 1979, under license from ATF,
 * ITC developed four new weights in roman and italic: book, medium, demi and
 * heavy. Designed by Victor Caruso, ITCs new weights matched the original faces
 * characteristics, but featured a slightly enlarged lowercase x-height. ITC
 * Franklin Gothic also features a slightly condensed lowercase a-z alphabet. In
 * 1991, ITC commissioned the Font Bureau in Boston to create condensed, compressed
 * and extra compressed versions of ITC Franklin Gothic, which increased the
 * flexibility and usefulness of the design.
 * 
 * Manufacturer:
 * International Typeface Corporation
 * 
 * Designer:
 * Victor Caruso
 * 
 * Vendor URL:
 * http://www.itcfonts.com
 * 
 * License information:
 * http://www.itcfonts.com/itc/licensing.html
 */
Cufon.registerFont({"w":255,"face":{"font-family":"frank","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 3 2 1 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-90 -342 382 110","underline-thickness":"17.9297","underline-position":"-18.1055","unicode-range":"U+0020-U+FB02"},"glyphs":{" ":{"w":90},"!":{"d":"37,-72r-18,-168r67,0r-17,168r-32,0xm25,0r0,-55r56,0r0,55r-56,0","w":105},"\"":{"d":"50,-140r-30,0r-6,-100r42,0xm114,-140r-31,0r-6,-100r43,0","w":133},"#":{"d":"189,-109r-7,35r-33,0r-13,74r-36,0r13,-74r-27,0r-14,74r-34,0r13,-74r-39,0r6,-35r39,0r5,-27r-38,0r6,-35r38,0r12,-69r35,0r-12,69r27,0r12,-69r36,0r-12,69r33,0r-6,35r-34,0r-4,27r34,0xm124,-136r-27,0r-5,27r27,0","w":211},"$":{"d":"153,-138v65,28,37,136,-39,131r0,33r-28,0r0,-33v-42,-4,-69,-25,-78,-61r49,-11v2,37,76,43,81,8v-3,-20,-16,-20,-39,-26v-52,-12,-76,-22,-79,-68v-2,-38,30,-67,66,-70r0,-28r28,0r0,27v36,3,60,21,71,52r-45,15v-3,-31,-69,-36,-69,-6v0,29,67,25,82,37","w":211},"%":{"d":"110,-180v0,34,-18,62,-50,62v-32,0,-51,-30,-50,-62v0,-33,17,-62,50,-62v32,0,50,30,50,62xm60,-141v25,2,18,-56,13,-70v-2,-6,-7,-9,-13,-9v-18,2,-17,17,-18,40v0,24,1,37,18,39xm44,0r133,-240r26,0r-133,240r-26,0xm238,-60v0,34,-18,62,-50,62v-32,0,-49,-29,-49,-62v0,-33,16,-62,49,-62v32,0,50,30,50,62xm188,-21v26,3,19,-55,14,-70v-20,-19,-33,-3,-31,31v0,23,0,37,17,39","w":248},"&":{"d":"121,-245v78,0,99,96,27,118r33,37v10,-11,18,-27,22,-48r49,7v-6,27,-18,52,-39,76v11,11,20,14,39,11r0,42v-31,9,-58,2,-76,-19v-54,48,-166,27,-166,-50v0,-32,20,-55,60,-69v-44,-40,-16,-105,51,-105xm149,-184v0,-27,-47,-33,-49,-6v-1,10,16,25,24,33v17,-6,25,-15,25,-27xm98,-108v-44,9,-32,70,9,68v15,0,28,-4,40,-14","w":258},"'":{"d":"50,-140r-30,0r-6,-100r42,0","w":69},"(":{"d":"58,60v-67,-94,-67,-209,1,-300r38,0v-55,87,-54,213,-1,300r-38,0","w":105},")":{"d":"47,-240v68,93,68,209,0,300r-39,0v56,-87,55,-213,1,-300r38,0","w":105},"*":{"d":"167,-117r-35,24r-27,-46r-27,46r-36,-24r36,-40r-52,-12r14,-39r49,22r-5,-54r42,0r-5,54r51,-22r13,39r-53,12","w":211},"+":{"d":"195,-140r0,38r-70,0r0,72r-39,0r0,-72r-69,0r0,-38r69,0r0,-73r39,0r0,73r70,0","w":211},",":{"d":"73,-54r0,49r-35,61r-19,0r27,-56r-27,0r0,-54r54,0","w":92,"k":{"1":-5}},"-":{"d":"4,-110r84,0r0,38r-84,0r0,-38","w":92,"k":{"\u0443":-6,"\u0442":1,"\u0423":6,"\u0422":8,"\u0410":-8,"Y":9,"W":-1,"T":8,"A":-8}},".":{"d":"73,0r-54,0r0,-54r54,0r0,54","w":92,"k":{"1":-5}},"\/":{"d":"12,60r-36,0r172,-300r35,0","w":192},"0":{"d":"199,-120v0,65,-31,124,-94,124v-62,0,-93,-58,-93,-124v0,-65,30,-124,93,-124v63,0,94,60,94,124xm106,-38v51,5,38,-116,27,-147v-4,-13,-14,-18,-27,-18v-36,0,-36,34,-36,82v0,49,0,80,36,83","w":211,"k":{"7":10,"4":-2,"1":5}},"1":{"d":"22,-145r0,-50v41,-12,68,-29,81,-49r41,0r0,200r66,0r0,44r-194,0r0,-44r73,0r0,-137v-29,17,-51,29,-67,36","w":211,"k":{"8":-5,"7":18,"6":2,"5":-2,"4":-3,"3":-5,"2":-6,"1":-4,"0":2,".":-13,",":-13}},"2":{"d":"192,-168v0,68,-49,79,-111,120r114,0r-4,48r-180,0r0,-47v43,-36,117,-66,124,-120v3,-18,-14,-33,-33,-32v-23,0,-37,15,-41,46r-50,-11v11,-53,42,-80,93,-80v51,0,88,31,88,76","w":211,"k":{"7":8,"4":2,"1":3}},"3":{"d":"137,-72v1,-33,-32,-31,-67,-31r0,-42v31,1,63,0,62,-28v-1,-39,-64,-39,-69,1r-49,-7v6,-80,171,-90,173,0v0,26,-14,43,-41,53v32,9,48,28,48,57v0,72,-110,94,-158,52v-16,-14,-27,-31,-30,-52r51,-8v1,47,79,51,80,5","w":211,"k":{"7":10,"1":6}},"4":{"d":"169,-244r0,147r34,0r0,42r-34,0r0,55r-56,0r0,-55r-105,0r0,-42r97,-147r64,0xm51,-97r65,0r1,-103","w":211,"k":{"7":18,"4":-4,"1":4}},"5":{"d":"144,-77v0,-39,-55,-51,-72,-19r-46,-8r10,-136r151,0r-6,49r-105,0r-4,54v43,-47,129,-10,129,56v0,52,-38,85,-93,85v-51,0,-83,-24,-95,-69r53,-7v5,44,78,39,78,-5","w":211,"k":{"7":12,"4":-3,"1":4}},"6":{"d":"14,-117v0,-69,31,-128,99,-127v46,0,74,28,83,65r-48,13v-5,-25,-17,-37,-36,-37v-28,0,-42,27,-42,80v34,-56,133,-19,130,46v-2,44,-39,81,-86,81v-71,0,-99,-54,-100,-121xm73,-74v0,21,16,38,36,37v21,0,35,-16,35,-39v0,-20,-16,-36,-35,-36v-20,-1,-36,17,-36,38","w":211,"k":{"4":-2,"1":4}},"7":{"d":"61,0v1,-86,39,-144,81,-190r-121,0r4,-50r168,0r0,43v-36,40,-74,117,-68,197r-64,0","w":211,"k":{":":15,"7":7,"6":12,"4":25,"1":8,".":27}},"8":{"d":"106,-244v46,0,86,23,86,64v0,23,-12,39,-36,50v86,35,37,145,-54,134v-83,11,-131,-95,-49,-122v-68,-35,-26,-126,53,-126xm105,-207v-27,-3,-44,27,-24,44v6,5,18,11,38,18v39,-9,30,-68,-14,-62xm105,-35v31,0,54,-22,33,-44v-5,-6,-21,-12,-47,-21v-20,6,-30,17,-30,33v0,22,19,32,44,32","w":211,"k":{"7":7,"4":-3,"1":3}},"9":{"d":"196,-123v0,68,-32,127,-99,127v-42,0,-69,-20,-79,-59r50,-9v6,30,42,34,60,12v8,-9,12,-30,12,-63v-39,51,-127,18,-127,-49v0,-49,38,-80,88,-80v66,1,94,53,95,121xm138,-168v1,-19,-17,-36,-36,-36v-20,0,-37,18,-36,37v1,19,14,36,35,36v21,0,37,-19,37,-37","w":211,"k":{"7":11,"1":6}},":":{"d":"73,-124r-54,0r0,-54r54,0r0,54xm73,0r-54,0r0,-54r54,0r0,54","w":92},";":{"d":"73,-178r0,53r-54,0r0,-53r54,0xm73,-54r0,49r-35,62r-19,0r27,-56r-27,0r0,-55r54,0","w":92},"\u037e":{"d":"73,-178r0,53r-54,0r0,-53r54,0xm73,-54r0,49r-35,62r-19,0r27,-56r-27,0r0,-55r54,0","w":92},"<":{"d":"180,-222r0,50r-104,52r104,52r0,49r-156,-81r0,-41","w":211},"=":{"d":"195,-172r0,39r-178,0r0,-39r178,0xm195,-106r0,39r-178,0r0,-39r178,0","w":211},">":{"d":"31,-19r0,-49r104,-52r-104,-53r0,-49r156,81r0,42","w":211},"?":{"d":"92,-244v43,-1,82,28,81,71v6,34,-40,62,-59,81v-2,4,-4,12,-4,23r-45,0v-8,-57,23,-59,47,-86v11,-20,-2,-46,-24,-46v-21,0,-32,15,-35,44r-48,-7v6,-47,37,-80,87,-80xm119,0r-55,0r0,-53r55,0r0,53","w":183},"@":{"d":"80,-115v0,-47,46,-88,86,-58r2,-8r33,0v-3,31,-10,61,-10,93v0,5,1,8,6,8v20,-1,37,-30,37,-56v0,-47,-41,-82,-89,-82v-53,0,-97,45,-96,99v1,54,40,99,99,97v31,-1,46,-5,75,-20r12,29v-95,53,-221,5,-221,-106v0,-71,60,-128,130,-128v66,0,122,49,122,110v0,54,-59,116,-102,72v-33,39,-84,1,-84,-50xm115,-114v0,15,5,31,19,31v30,2,43,-67,6,-66v-16,-1,-26,17,-25,35","w":279},"A":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84","w":218,"k":{"\u2019":15,"\u201d":15,"\u00ab":3,"y":6,"w":5,"v":5,"u":2,"t":2,"q":2,"o":3,"g":-4,"e":3,"c":3,"Y":17,"W":12,"V":12,"U":7,"T":18,"Q":8,"O":8,"G":8,"C":8,".":-8,"-":-7,",":-8}},"B":{"d":"223,-66v0,42,-35,66,-87,66r-112,0r0,-240v82,3,192,-21,192,62v0,27,-14,44,-43,53v30,6,50,29,50,59xm158,-172v0,-35,-43,-25,-78,-26r0,53v34,0,78,7,78,-27xm164,-74v0,-35,-47,-28,-84,-28r0,58v37,-1,84,7,84,-30","w":234,"k":{"Y":3,"W":4,"V":2}},"C":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124","w":225,"k":{"A":2}},"D":{"d":"164,-228v92,48,66,241,-57,228r-83,0r0,-240v47,1,111,-3,140,12xm163,-122v0,-51,-27,-81,-84,-74r0,151v58,8,84,-27,84,-77","w":233,"k":{"Y":10,"V":6,"T":3,"J":4,"A":8}},"E":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46","w":205},"F":{"d":"195,-192r-113,0r0,53r89,0r0,45r-89,0r0,94r-58,0r0,-240r171,0r0,48","w":199,"k":{"u":11,"r":9,"o":8,"e":8,"a":10,"O":3,"J":16,"A":14,".":23,"-":-3,",":23}},"G":{"d":"70,-118v0,54,34,96,76,66v9,-6,12,-17,12,-31r-46,0r0,-45r99,0r0,128r-26,0v-2,-9,-4,-19,-8,-28v-17,21,-39,32,-65,32v-65,0,-99,-53,-99,-121v0,-71,37,-127,103,-127v55,0,87,35,95,83r-53,7v-4,-29,-19,-44,-42,-44v-35,0,-46,37,-46,80","w":231,"k":{"Y":9,"W":5,"V":5,"T":1,"A":-2}},"H":{"d":"210,-240r0,240r-56,0r0,-99r-75,0r0,99r-55,0r0,-240r55,0r0,94r75,0r0,-94r56,0","w":233},"I":{"d":"80,-240r0,240r-56,0r0,-240r56,0","w":104},"J":{"d":"2,-47v31,5,57,7,57,-29r0,-164r56,0r0,171v5,66,-50,82,-113,69r0,-47","w":137,"k":{"A":5}},"K":{"d":"79,-240r0,113r76,-113r53,0r-57,86r72,154r-62,0r-48,-104r-34,49r0,55r-55,0r0,-240r55,0","w":226,"k":{"y":13,"u":8,"o":9,"e":9,"a":2,"T":-3,"O":10,"G":10,"C":10}},"L":{"d":"81,-47r95,0r0,47r-152,0r0,-240r57,0r0,193","w":181,"k":{"\u2019":35,"\u201d":34,"y":13,"Y":23,"W":15,"V":17,"U":2,"T":20,"O":4,"G":2,"C":4,"-":-2}},"M":{"d":"130,0r-59,-196r0,196r-47,0r0,-240r87,0r42,144r45,-144r87,0r0,240r-56,0r0,-196r-60,196r-39,0","w":309},"N":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0","w":232,"k":{".":-3,",":-3}},"O":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78","w":230,"k":{"Y":9,"X":9,"W":5,"V":5,"T":1,"A":7}},"P":{"d":"210,-166v0,67,-52,84,-129,77r0,89r-57,0r0,-240r94,0v59,-2,92,22,92,74xm153,-165v0,-35,-38,-32,-74,-31r0,63v36,1,74,3,74,-32","w":217,"k":{"o":4,"e":4,"a":3,"J":18,"A":14,".":30,",":31}},"Q":{"d":"116,-244v116,0,133,188,53,232v0,20,19,21,42,17r0,42v-42,11,-76,-7,-76,-46v-78,15,-122,-50,-122,-121v0,-66,35,-124,103,-124xm116,-198v-30,0,-44,26,-44,78v0,52,15,78,44,78v30,0,44,-26,44,-77v0,-52,-14,-79,-44,-79","w":231},"R":{"d":"130,-240v88,-14,119,104,46,134r44,106r-62,0r-37,-95r-40,0r0,95r-57,0r0,-240r106,0xm159,-168v0,-35,-41,-29,-78,-29r0,61v39,1,78,5,78,-32","w":236,"k":{"y":-2,"u":4,"o":6,"e":6,"Y":5,"W":6,"V":4,"U":4,"O":5,"G":5,"C":5}},"S":{"d":"32,-120v-48,-45,-3,-124,67,-124v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40v21,9,40,32,40,62v0,73,-103,101,-162,63v-17,-11,-28,-28,-34,-50r52,-12v2,38,81,49,87,9v-2,-22,-18,-23,-42,-28v-31,-7,-52,-15,-65,-26","w":209,"k":{"t":2,"Y":4,"W":5,"V":3,"T":-2,"A":3}},"T":{"d":"176,-240r0,48r-59,0r0,192r-57,0r0,-192r-60,0r0,-48r176,0","w":176,"k":{"\u00ab":18,"y":17,"w":19,"v":17,"u":18,"s":14,"r":17,"o":19,"g":17,"e":19,"c":19,"a":19,"Y":-17,"W":-11,"V":-13,"S":-4,"J":17,"G":2,"C":1,"A":17,";":17,":":17,".":15,"-":8,",":15}},"U":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49","w":233,"k":{"r":-2,"p":-1,"n":-2,"m":-2,"A":5}},"V":{"d":"202,-240r-72,240r-60,0r-72,-240r59,0r48,172r50,-172r47,0","w":200,"k":{"\u00ab":10,"y":-3,"u":7,"r":7,"o":10,"g":9,"e":10,"a":10,"T":-13,"O":5,"G":5,"C":5,"A":11,";":6,":":5,".":14,",":14}},"W":{"d":"312,-240r-60,240r-55,0r-40,-159r-38,159r-55,0r-62,-240r58,0r37,162r39,-162r52,0r40,162r38,-162r46,0","w":314,"k":{"\u00ab":8,"y":-2,"u":7,"r":7,"o":9,"g":8,"e":9,"a":9,"T":-11,"S":1,"O":4,"G":4,"C":5,"A":10,":":6,".":12,"-":-2,",":12}},"X":{"d":"207,-240r-66,112r74,128r-65,0r-48,-87r-48,87r-53,0r74,-128r-66,-112r65,0r39,73r41,-73r53,0","w":215,"k":{"y":12,"o":10,"e":9,"Q":9,"O":9,"C":9,"-":4}},"Y":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0","w":187,"k":{"\u00ab":19,"u":12,"p":11,"o":17,"g":16,"e":18,"a":18,"T":-17,"S":2,"O":8,"G":9,"C":9,"A":16,";":11,":":10,".":18,"-":9,",":18}},"Z":{"d":"197,-199r-121,153r125,0r0,46r-194,0r0,-41r121,-154r-113,0r0,-45r182,0r0,41","w":208},"[":{"d":"95,38r0,22r-76,0r0,-300r76,0r0,23r-35,0r0,255r35,0","w":105},"\\":{"d":"181,60r-171,-300r35,0r171,300r-35,0","w":192},"]":{"d":"11,-218r0,-22r75,0r0,300r-75,0r0,-23r35,0r0,-255r-35,0","w":105},"^":{"d":"52,-120r-50,0r56,-122r64,0r56,122r-50,0r-38,-83","w":180},"_":{"d":"0,17r180,0r0,42r-180,0r0,-42","w":180},"`":{"d":"54,-266r73,42r-9,20r-77,-33","w":180},"a":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23","w":194,"k":{"y":4,"w":3,"v":3}},"b":{"d":"113,4v-30,-1,-38,-10,-52,-31v-3,3,-7,12,-11,27r-28,0r0,-240r52,0r0,85v9,-17,24,-26,44,-26v45,1,66,41,66,92v0,52,-22,93,-71,93xm102,-146v-31,1,-28,42,-28,76v0,21,9,37,27,37v25,0,29,-22,29,-56v0,-39,-4,-53,-28,-57","w":195,"k":{"y":4,"w":2,"v":2}},"c":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51","w":184,"k":{"k":-2,"h":-2}},"d":{"d":"12,-87v0,-53,19,-93,66,-94v19,0,34,7,44,22r0,-81r50,0r0,240r-48,0r0,-28v-12,21,-28,32,-49,32v-45,-1,-63,-42,-63,-91xm66,-86v0,66,54,67,56,16v1,-32,2,-75,-26,-75v-20,0,-30,20,-30,59","w":194},"e":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37","w":192,"k":{"y":5,"x":5,"w":4,"v":4}},"f":{"d":"113,-207v-26,-5,-40,2,-37,29r32,0r0,41r-32,0r0,137r-51,0r0,-137r-20,0r0,-41r20,0v-5,-61,31,-77,88,-70r0,41","w":115,"k":{"t":-8,"s":-3,"o":2,"f":-5,"e":3,"a":1}},"g":{"d":"144,-173v1,-28,21,-40,55,-34r0,34v-16,-4,-32,-2,-34,13v44,53,-24,106,-95,86v-11,6,-13,23,-1,26v47,12,129,-7,129,52v0,45,-42,60,-103,59v-54,-1,-91,-5,-91,-42v0,-16,10,-26,30,-32v-36,-18,-26,-58,13,-71v-63,-32,-21,-99,50,-99v16,0,32,3,47,8xm127,-126v0,-16,-12,-27,-30,-27v-18,0,-29,11,-29,27v0,18,10,27,29,27v17,0,30,-10,30,-27xm149,14v-4,-22,-52,-10,-87,-15v-5,0,-14,8,-13,14v2,18,29,18,51,18v27,0,45,0,49,-17","w":199},"h":{"d":"102,-140v-50,0,-24,91,-30,140r-50,0r0,-240r50,0r0,87v24,-48,102,-33,102,36r0,117r-52,0r0,-100v1,-26,0,-40,-20,-40","w":195,"k":{"y":4}},"i":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm74,-245r0,53r-52,0r0,-53r52,0","w":95},"j":{"d":"-11,20v24,4,32,-3,32,-30r0,-168r54,0r0,194v-2,40,-40,56,-86,45r0,-41xm75,-245r0,53r-54,0r0,-53r54,0","w":96},"k":{"d":"139,-117r58,117r-58,0r-37,-81r-31,36r0,45r-49,0r0,-240r49,0r0,144v21,-29,45,-55,68,-82r51,0","w":195,"k":{"u":2,"o":4,"g":-5,"e":4,".":-7,",":-7}},"l":{"d":"22,0r0,-240r52,0r0,240r-52,0","w":95},"m":{"d":"170,-150v23,-51,120,-39,105,35r0,115r-52,0r0,-98v-1,-28,1,-42,-22,-42v-47,0,-20,93,-27,140r-52,0r0,-98v0,-29,0,-42,-23,-42v-23,0,-26,15,-27,42r0,98r-50,0r0,-178r49,0r0,28v13,-41,84,-42,99,0","w":296,"k":{"y":4,"w":2,"v":2}},"n":{"d":"70,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31","w":197,"k":{"y":4,"w":2,"v":2}},"o":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59","w":192,"k":{"y":5,"x":5,"w":3,"v":3}},"p":{"d":"182,-91v0,77,-69,127,-110,71r0,80r-50,0r0,-238r48,0r0,26v9,-20,25,-29,47,-29v44,1,65,39,65,90xm128,-92v0,-67,-56,-68,-56,-12v0,35,-3,70,28,71v24,-4,28,-21,28,-59","w":194,"k":{"y":3,"t":-2}},"q":{"d":"12,-89v-12,-79,83,-125,123,-64v6,-8,10,-16,13,-25r29,0v-8,74,-1,159,-3,238r-51,0r0,-78v-44,53,-121,1,-111,-71xm95,-33v30,0,28,-41,28,-76v0,-18,-10,-37,-26,-37v-26,0,-30,20,-30,58v1,34,4,55,28,55","w":195},"r":{"d":"117,-129v-60,-3,-42,74,-45,129r-50,0r0,-178r48,0r0,34v9,-28,20,-39,47,-37r0,52","w":124,"k":{"y":-8,"x":-3,"w":-6,"v":-8,"t":-7,"s":-3,"p":2,"k":2,"h":2,"f":-5,".":12,"-":-4,",":12}},"s":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v63,29,25,111,-47,111v-45,0,-72,-18,-81,-53r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21","w":170,"k":{"t":-3}},"t":{"d":"121,0v-54,10,-93,3,-93,-54r0,-83r-28,0r0,-41r31,0r5,-52r45,-3r0,55r38,0r0,41r-38,0r0,75v-3,27,17,25,40,23r0,39","w":126,"k":{"o":1,"e":2,"a":-3,";":-5,":":-5}},"u":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24","w":194},"v":{"d":"161,-178r-61,178r-40,0r-61,-178r54,0r34,113r35,-113r39,0","w":162,"k":{"o":4,"g":3,"e":4,"c":4,"a":5,":":-1,".":11,"-":-6,",":11}},"w":{"d":"256,-178r-53,178r-46,0r-28,-114r-28,114r-44,0r-55,-178r55,0r28,109r27,-109r48,0r26,110r30,-110r40,0","w":259,"k":{"o":4,"g":2,"e":4,"c":4,"a":4,".":9,"-":-7,",":9}},"x":{"d":"169,-178r-51,83r60,95r-60,0r-37,-61r-36,61r-45,0r59,-95r-51,-83r60,0r28,48r28,-48r45,0","w":177,"k":{"q":4,"o":5,"e":6,"c":6,"a":2}},"y":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0","w":160,"k":{"o":4,"g":2,"e":4,"c":4,"a":4,":":-2,".":9,"-":-7,",":10}},"z":{"d":"143,-178r0,33r-79,107r83,0r0,38r-140,0r0,-38r78,-104r-71,0r0,-36r129,0","w":154},"{":{"d":"78,-195v0,41,11,91,-21,105v34,15,15,81,23,124v1,4,13,6,19,4r0,21v-40,4,-68,-3,-65,-47v-4,-33,14,-90,-19,-94r0,-19v54,-15,-30,-163,84,-138r0,21v-17,-2,-21,1,-21,23","w":105},"|":{"d":"65,-240r50,0r0,300r-50,0r0,-300","w":180},"}":{"d":"36,15v0,-41,-11,-91,21,-105v-34,-15,-15,-81,-23,-124v-1,-4,-13,-6,-19,-4r0,-21v41,-5,65,4,65,47v0,33,-12,90,19,94r0,19v-54,15,30,163,-84,138r0,-21v17,2,21,-1,21,-23","w":105},"~":{"d":"136,-87v-6,2,-58,-18,-66,-18v-10,0,-18,8,-25,22r-27,-19v14,-31,21,-47,55,-50v28,-2,79,41,93,-1r27,17v-14,33,-33,49,-57,49","w":211},"\u00c4":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm155,-281v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm97,-281v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":218},"\u00c5":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm143,-288v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm95,-288v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":218},"\u00c7":{"d":"75,-120v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-8,57,-41,86,-99,88r-5,14v22,-6,43,10,43,29v0,37,-56,37,-84,19r7,-15v19,10,40,16,44,-5v-1,-14,-18,-16,-34,-12r9,-32v-55,-9,-86,-57,-86,-122v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78","w":225},"\u00c9":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm155,-322r13,29r-77,33r-9,-20","w":205},"\u00d1":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0xm61,-288v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":232},"\u00d6":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm167,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm109,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":230},"\u00dc":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm170,-287v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm112,-287v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":233},"\u00e1":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm144,-266r13,29r-77,33r-9,-20","w":194},"\u00e0":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm55,-266r73,42r-9,20r-77,-33","w":194},"\u00e2":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm164,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":194},"\u00e4":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm149,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm91,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":194},"\u00e3":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm41,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":194},"\u00e5":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm133,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm85,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":194},"\u00e7":{"d":"70,-91v0,59,52,70,59,21r49,3v-6,44,-32,68,-78,71r-5,14v18,-5,36,10,36,26v-1,34,-49,35,-73,18r6,-15v15,8,33,15,37,-3v-1,-12,-15,-15,-28,-12r10,-29v-43,-5,-72,-42,-72,-91v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51","w":184},"\u00e9":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm144,-266r13,29r-77,33r-9,-20","w":192},"\u00e8":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm59,-266r73,42r-9,20r-77,-33","w":192},"\u00ea":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm166,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":192},"\u00eb":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm151,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm93,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":192},"\u00ed":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm89,-266r13,29r-77,33r-9,-20","w":95},"\u00ec":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm7,-266r73,42r-9,20r-77,-33","w":95},"\u00ee":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm113,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":95},"\u00ef":{"d":"75,-178r0,178r-52,0r0,-178r52,0xm102,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm44,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":95},"\u00f1":{"d":"70,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31xm37,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":197},"\u00f3":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm141,-266r13,29r-77,33r-9,-20","w":192},"\u00f2":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm57,-266r73,42r-9,20r-77,-33","w":192},"\u00f4":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm163,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":192},"\u00f6":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm148,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm90,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":192},"\u00f5":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm40,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":192},"\u00fa":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm143,-266r13,29r-77,33r-9,-20","w":194},"\u00f9":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm52,-266r73,42r-9,20r-77,-33","w":194},"\u00fb":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm162,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":194},"\u00fc":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm147,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm89,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":194},"\u2020":{"d":"19,-136r0,-41r62,0r0,-63r49,0r0,63r62,0r0,41r-62,0r0,194r-49,0r0,-194r-62,0","w":211},"\u00b0":{"d":"156,-194v0,27,-23,51,-50,51v-27,0,-50,-23,-50,-51v0,-27,22,-51,49,-51v27,0,51,24,51,51xm81,-194v0,13,12,24,25,24v13,1,24,-11,24,-24v0,-13,-11,-25,-24,-25v-14,0,-25,12,-25,25","w":211},"\u00a2":{"d":"82,-120v0,25,8,47,32,47v17,0,27,-10,29,-31r45,4v-5,36,-26,57,-62,64r0,46r-28,0r0,-46v-45,-6,-67,-39,-69,-86v-2,-47,27,-84,69,-87r0,-37r28,0r0,37v36,5,57,26,63,64r-46,3v-3,-21,-12,-31,-29,-31v-21,0,-32,17,-32,53","w":211},"\u00a3":{"d":"2,-45v44,6,60,-22,51,-65r-33,0r0,-36r27,0v-12,-60,20,-98,74,-98v35,0,58,16,69,46r-45,18v-5,-32,-49,-29,-46,5v0,5,1,15,3,29r40,0r0,36r-36,0v0,36,-7,46,-27,65v39,1,69,2,77,-33r48,14v-14,82,-113,62,-202,64r0,-45","w":211},"\u00a7":{"d":"164,-52v56,36,14,116,-56,116v-42,0,-77,-20,-87,-54r44,-8v12,18,27,27,46,27v18,0,33,-7,34,-21v-12,-49,-118,-32,-118,-101v0,-20,8,-38,24,-53v-42,-38,0,-98,59,-98v37,0,63,15,76,44r-38,11v-4,-26,-64,-32,-68,-4v9,39,106,26,106,92v0,18,-7,35,-22,49xm130,-69v37,-29,-15,-49,-45,-58v-17,8,-19,25,-4,37v7,5,23,12,49,21","w":211},"\u2022":{"d":"120,-173v27,0,49,24,49,51v0,27,-23,50,-49,50v-26,0,-50,-24,-50,-50v0,-27,23,-51,50,-51","w":239},"\u00b6":{"d":"0,-179v4,-53,27,-61,96,-61r110,0r0,22r-29,0r0,278r-21,0r0,-278r-22,0r0,278r-22,0r0,-177v-63,3,-116,-2,-112,-62xm50,-178v0,36,22,41,62,39r0,-79v-41,-2,-62,3,-62,40","w":211},"\u00df":{"d":"112,-221v-27,0,-34,19,-34,54r0,188r-55,0r0,-146r-18,0r0,-39r18,0v-1,-60,39,-92,96,-95v53,-3,93,46,60,87v-12,15,-41,16,-52,25v34,18,90,28,90,81v0,55,-68,86,-124,62r13,-35v27,9,58,10,61,-16v-4,-40,-81,-28,-80,-78v0,-14,6,-26,19,-39v42,-4,43,-49,6,-49","w":224},"\u00ae":{"d":"263,-120v0,65,-57,124,-124,124v-66,0,-124,-58,-124,-124v0,-66,58,-124,124,-124v67,0,124,59,124,124xm139,-17v55,0,101,-49,101,-103v0,-55,-47,-103,-100,-103v-54,0,-102,48,-102,103v0,54,47,103,101,103xm80,-192v54,0,122,-9,121,44v0,17,-8,29,-25,37r27,63r-41,0r-23,-57r-21,0r0,57r-38,0r0,-144xm163,-149v0,-21,-23,-17,-45,-17r0,35v21,0,45,3,45,-18","w":278},"\u00a9":{"d":"263,-120v0,65,-57,124,-124,124v-66,0,-124,-58,-124,-124v0,-66,58,-124,124,-124v67,0,124,59,124,124xm139,-17v55,0,101,-49,101,-103v0,-55,-47,-103,-100,-103v-54,0,-102,48,-102,103v0,54,47,103,101,103xm74,-120v0,-43,27,-75,69,-74v37,0,58,19,62,56r-38,2v-1,-20,-9,-31,-25,-31v-19,0,-28,17,-28,49v0,51,50,61,56,17r35,3v-4,32,-27,52,-63,52v-43,0,-68,-29,-68,-74","w":278},"\u2122":{"d":"114,-240r0,29r-39,0r0,108r-38,0r0,-108r-38,0r0,-29r115,0xm195,-103r-35,-102r0,102r-33,0r0,-137r58,0r26,78r28,-78r58,0r0,137r-39,0r0,-104r-37,104r-26,0","w":310},"\u00b4":{"d":"126,-266r13,29r-77,33r-9,-20","w":180},"\u00a8":{"d":"140,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm82,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":180},"\u2260":{"d":"109,-171r21,-39r31,16r-12,23r35,0r0,44r-55,0r-12,24r67,0r0,44r-87,0r-18,35r-31,-16r10,-19r-30,0r0,-44r49,0r13,-24r-62,0r0,-44r81,0","w":211},"\u00c6":{"d":"294,-195r-110,0r0,50r88,0r0,45r-88,0r0,53r110,0r0,47r-167,0r0,-55r-56,0r-25,55r-48,0r109,-240r187,0r0,45xm88,-95r39,0r0,-87","w":303},"\u00d8":{"d":"46,-25v-62,-66,-37,-219,71,-219v17,0,32,4,45,10r14,-25r32,0r-23,43v62,70,36,226,-73,220v-16,0,-31,-3,-44,-10r-14,26r-32,0xm139,-191v-58,-32,-80,53,-63,111xm92,-50v39,23,70,-5,67,-69v0,-16,-2,-30,-5,-43","w":230},"\u221e":{"d":"63,-157v29,1,37,14,52,40v15,-34,26,-48,65,-49v38,-1,67,33,67,74v0,38,-28,75,-61,73v-33,-2,-41,-21,-59,-50v-25,66,-118,46,-118,-24v0,-33,22,-65,54,-64xm237,-92v0,-43,-49,-82,-80,-46v-11,13,-17,38,-25,56v14,27,22,45,55,47v30,1,50,-26,50,-57xm19,-93v0,37,38,69,67,40v9,-8,17,-30,24,-51v-16,-55,-91,-47,-91,11","w":256},"\u00b1":{"d":"195,-140r0,38r-70,0r0,65r-39,0r0,-65r-69,0r0,-38r69,0r0,-73r39,0r0,73r70,0xm195,-20r0,38r-178,0r0,-38r178,0","w":211},"\u2264":{"d":"180,-241r0,46r-103,47r103,47r0,47r-156,-73r0,-42xm180,-44r0,44r-156,0r0,-44r156,0","w":211},"\u2265":{"d":"31,-54r0,-47r103,-47r-103,-47r0,-46r156,72r0,42xm31,0r0,-44r156,0r0,44r-156,0","w":211},"\u00a5":{"d":"158,-154r39,0r0,32r-57,0r-11,24r68,0r0,31r-68,0r0,67r-47,0r0,-67r-68,0r0,-31r68,0r-11,-24r-57,0r0,-32r40,0r-47,-86r60,0r46,91r46,-91r45,0","w":211},"\u00b5":{"d":"143,-27v-7,38,-58,40,-65,7r0,80r-53,0r0,-238r53,0v6,52,-19,138,27,147v48,-6,23,-97,29,-147r52,0r0,178r-42,0","w":211},"\u2202":{"d":"163,-126v13,-56,-9,-98,-58,-99v-23,0,-40,9,-53,28r-8,0v15,-36,38,-53,67,-53v44,1,64,38,64,88v0,72,-37,167,-104,167v-35,0,-59,-24,-59,-59v0,-77,107,-149,151,-72xm41,-46v1,52,56,50,84,13v15,-20,28,-46,35,-78v-9,-26,-26,-39,-50,-39v-43,0,-70,61,-69,104","w":177},"\u2211":{"d":"193,-1v35,-1,37,-13,49,-41r8,0r-15,81v-69,-9,-155,-3,-230,-3r126,-143r-125,-164v67,6,144,2,216,3r2,57r-7,0v-5,-62,-90,-35,-150,-41r99,129r-106,122r133,0","w":256},"\u220f":{"d":"254,-1v0,22,10,29,35,29r0,8r-110,0r0,-8v25,0,35,-6,35,-29r0,-249r-129,0r0,249v-1,23,10,29,35,29r0,8r-111,0r0,-8v25,0,35,-6,35,-29r0,-225v0,-23,-12,-36,-34,-36r0,-8r278,0r0,8v-22,0,-34,13,-34,36r0,225","w":296},"\uf006":{"d":"27,0r0,-139r-20,0r0,-39r197,0r0,39r-21,0r0,139r-52,0r0,-139r-51,0r0,139r-53,0","w":210},"\u222b":{"d":"54,-306v6,-26,52,-34,52,-3v0,21,-29,15,-37,6v-5,0,-6,5,-6,11r6,142v0,87,0,130,-19,174v-8,19,-49,19,-48,-7v1,-23,28,-14,35,-4v9,-4,9,-16,9,-35r-2,-133v1,-81,0,-109,10,-151","w":98},"\u00aa":{"d":"66,-245v29,0,47,9,47,41v0,22,-2,50,2,68r-35,0v-1,-6,-2,-10,-2,-12v-17,25,-73,17,-70,-16v3,-32,24,-36,69,-39v1,-12,-3,-19,-15,-19v-11,0,-16,5,-17,15r-34,-3v4,-23,22,-35,55,-35xm58,-155v14,0,22,-13,19,-30v-20,2,-30,7,-30,17v0,8,3,13,11,13","w":127},"\u00ba":{"d":"9,-189v0,-33,22,-56,54,-56v33,0,55,25,55,56v0,32,-22,55,-56,55v-31,0,-53,-23,-53,-55xm80,-189v0,-20,-1,-33,-16,-33v-16,0,-17,13,-17,32v0,22,5,34,16,34v11,0,17,-11,17,-33","w":126},"\u2126":{"d":"179,-36v32,-3,78,12,80,-22r6,0r0,58r-106,0r5,-55v35,-11,51,-47,52,-90v0,-52,-25,-91,-77,-91v-94,0,-103,157,-26,181r5,55r-106,0r0,-58r6,0v2,34,48,19,80,22r0,-10v-48,-12,-77,-46,-78,-98v-2,-62,55,-104,119,-104v64,0,120,43,119,104v-1,51,-31,86,-79,98r0,10","w":276},"\u00e6":{"d":"17,-125v3,-57,91,-71,132,-40v62,-42,138,5,128,85r-110,0v-9,53,56,61,64,19r46,4v-12,70,-107,80,-146,29v-28,45,-120,45,-120,-18v0,-54,37,-58,109,-65v2,-23,-3,-37,-26,-36v-18,0,-28,9,-30,27xm228,-111v-2,-24,-8,-36,-29,-36v-19,0,-29,12,-32,36r61,0xm86,-29v25,-1,38,-25,34,-56v-37,2,-55,13,-55,33v-1,12,8,24,21,23","w":288},"\u00f8":{"d":"40,-16v-54,-48,-30,-165,55,-165v15,0,27,2,35,6r13,-21r28,0r-19,35v66,58,11,201,-90,159r-13,20r-28,0xm111,-142v-39,-21,-52,30,-43,77xm81,-36v28,15,46,-6,45,-50v0,-10,-1,-19,-2,-28","w":192},"\u00bf":{"d":"69,-180r54,0r0,53r-54,0r0,-53xm92,61v-43,0,-82,-29,-82,-71v0,-35,39,-63,60,-81v3,-4,4,-11,4,-20r45,0v12,66,-47,52,-51,101v-1,17,12,27,28,28v21,0,31,-15,34,-44r49,6v-6,48,-37,81,-87,81","w":183},"\u00a1":{"d":"81,-180r0,55r-56,0r0,-55r56,0xm69,-108r18,168r-68,0r18,-168r32,0","w":105},"\u00ac":{"d":"134,0r0,-53r-106,0r0,-44r156,0r0,97r-50,0","w":211},"\u221a":{"d":"185,-328r-54,342r-87,-181r-35,17r-5,-12r52,-26r71,145r46,-287","w":197},"\u0192":{"d":"88,-188v7,-54,38,-82,99,-69r-6,39v-27,-3,-41,0,-42,30r32,0r-7,41r-32,0v-12,55,-14,127,-36,172v-12,24,-48,31,-85,25r7,-40v26,3,37,-1,41,-25r22,-132r-22,0r9,-41r20,0","w":211},"\u2248":{"d":"136,-126v-7,2,-59,-19,-66,-18v-10,0,-18,7,-25,21r-27,-17v14,-32,21,-48,55,-51v27,-2,78,41,93,0r27,16v-14,33,-33,49,-57,49xm136,-51v-7,2,-59,-19,-66,-18v-10,0,-18,7,-25,21r-27,-17v14,-32,20,-49,55,-51v27,-2,78,41,93,0r27,16v-14,32,-33,49,-57,49","w":211},"\u2206":{"d":"117,-248r102,248r-217,0xm104,-186r-78,168r148,0","w":220},"\u00ab":{"d":"90,-42r-30,-50r30,-52r18,0r-18,52r18,50r-18,0xm42,-42r-30,-50r30,-52r18,0r-18,52r18,50r-18,0","w":122,"k":{"\u0443":1,"\u0442":-7,"\u042f":7,"\u0427":4,"\u0423":7,"\u0422":17,"\u041b":-3}},"\u00bb":{"d":"33,-42r-19,0r19,-50r-19,-52r19,0r30,52xm81,-42r-18,0r18,-50r-18,-52r18,0r30,52","w":122,"k":{"Y":20,"W":9,"V":9,"T":18,"A":2}},"\u2026":{"d":"75,0r-55,0r0,-54r55,0r0,54xm170,0r-55,0r0,-54r55,0r0,54xm265,0r-54,0r0,-54r54,0r0,54","w":285},"\u00a0":{"w":90},"\u00c0":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm65,-322r73,42r-9,20r-77,-33","w":218},"\u00c3":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm50,-288v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":218},"\u00d5":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm59,-288v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":230},"\u0152":{"d":"13,-119v0,-79,54,-143,141,-121r171,0r0,45r-113,0r0,50r90,0r0,45r-90,0r0,53r113,0r0,47r-171,0v-86,22,-141,-43,-141,-119xm122,-198v-39,0,-45,37,-47,78v-4,73,45,99,79,59r0,-119v-7,-12,-18,-18,-32,-18","w":334},"\u0153":{"d":"11,-89v0,-77,85,-118,144,-74v65,-43,147,-3,136,83r-113,0v-8,53,58,62,65,19r48,4v-7,56,-89,80,-136,43v-59,44,-144,2,-144,-75xm178,-111r63,0v-2,-25,-11,-37,-30,-37v-19,0,-31,12,-33,37xm130,-88v0,-34,-4,-59,-31,-59v-27,0,-31,24,-31,58v1,35,4,58,31,58v26,0,31,-24,31,-57","w":302},"\u2013":{"d":"28,-110r155,0r0,38r-155,0r0,-38","w":211},"\u2014":{"d":"-7,-110r254,0r0,38r-254,0r0,-38","w":239},"\u201c":{"d":"20,-142r0,-49r30,-49r19,0r-24,49r24,0r0,49r-49,0xm90,-142r0,-49r29,-49r18,0r-25,49r25,0r0,49r-47,0","w":157,"k":{"Y":-7,"W":-6,"V":-7,"T":-2,"A":14}},"\u201d":{"d":"137,-240r0,49r-30,49r-18,0r24,-49r-24,0r0,-49r48,0xm68,-240r0,49r-29,49r-19,0r25,-49r-25,0r0,-49r48,0","w":157,"k":{"Y":-6,"W":-5,"V":-6,"T":-2,"A":15}},"\u2018":{"d":"72,-240r-25,48r25,0r0,50r-51,0r0,-44r31,-54r20,0","w":92},"\u2019":{"d":"21,-142r24,-48r-24,0r0,-50r51,0r0,44r-32,54r-19,0","w":92},"\u00f7":{"d":"105,-207v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24xm195,-140r0,38r-178,0r0,-38r178,0xm105,-83v13,0,24,11,24,24v0,13,-11,24,-24,24v-13,0,-24,-11,-24,-24v0,-13,11,-24,24,-24","w":211},"\u25ca":{"d":"169,-134r-70,134r-21,0r-70,-134r70,-134r21,0xm147,-134r-58,-115r-59,115r59,114","w":177},"\u00ff":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0xm131,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm73,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":160},"\u0178":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm146,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm88,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":187},"\u2215":{"d":"-61,0r133,-240r28,0r-133,240r-28,0","w":38},"\u20ac":{"d":"149,-166v-1,-17,-15,-31,-32,-32v-21,0,-32,14,-37,41r40,0r0,28r-43,0r0,21r43,0r0,27r-39,0v7,48,62,55,69,3r58,3v-10,51,-32,79,-90,79v-53,0,-85,-28,-96,-85r-17,0r0,-27r14,0v-1,-6,-1,-16,0,-21r-14,0r0,-28r17,0v1,-104,173,-117,186,-13","w":210},"\u2039":{"d":"42,-42r-30,-50r30,-52r18,0r-18,52r18,50r-18,0","w":74},"\u203a":{"d":"32,-42r-18,0r18,-50r-18,-52r18,0r30,52","w":74},"\ufb01":{"d":"113,-207v-26,-5,-40,2,-37,29r32,0r0,41r-32,0r0,137r-51,0r0,-137r-20,0r0,-41r20,0v-5,-61,31,-77,88,-70r0,41xm180,-178r0,178r-52,0r0,-178r52,0xm180,-245r0,53r-52,0r0,-53r52,0","w":201},"\ufb02":{"d":"113,-207v-26,-5,-40,2,-37,29r32,0r0,41r-32,0r0,137r-51,0r0,-137r-20,0r0,-41r20,0v-5,-61,31,-77,88,-70r0,41xm128,0r0,-240r52,0r0,240r-52,0","w":201},"\u2021":{"d":"19,-136r0,-41r62,0r0,-63r49,0r0,63r62,0r0,41r-62,0r0,88r62,0r0,41r-62,0r0,65r-49,0r0,-65r-62,0r0,-41r62,0r0,-88r-62,0","w":211},"\u2219":{"d":"54,-65r-54,0r0,-53r54,0r0,53","w":54},"\u201a":{"d":"21,48r24,-48r-24,0r0,-50r51,0r0,44r-32,54r-19,0","w":92},"\u201e":{"d":"137,-49r0,49r-30,49r-18,0r24,-49r-24,0r0,-49r48,0xm68,-49r0,49r-29,49r-19,0r25,-49r-25,0r0,-49r48,0","w":157,"k":{"Y":19,"W":13,"V":15,"T":16,"A":-8}},"\u2030":{"d":"110,-180v0,34,-18,62,-50,62v-32,0,-51,-30,-50,-62v0,-33,17,-62,50,-62v32,0,50,30,50,62xm60,-141v25,2,18,-56,13,-70v-2,-6,-7,-9,-13,-9v-18,2,-17,17,-18,40v0,24,1,37,18,39xm44,0r133,-240r26,0r-133,240r-26,0xm238,-60v0,34,-18,62,-50,62v-32,0,-49,-29,-49,-62v0,-33,16,-62,49,-62v32,0,50,30,50,62xm188,-21v26,3,19,-55,14,-70v-20,-19,-33,-3,-31,31v0,23,0,37,17,39xm356,-60v0,34,-18,62,-50,62v-32,0,-50,-30,-50,-62v0,-33,18,-62,50,-62v32,0,50,30,50,62xm306,-21v25,3,17,-58,13,-71v-20,-18,-32,0,-31,32v1,24,1,37,18,39","w":365},"\u00c2":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm174,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":218},"\u00ca":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm174,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":205},"\u00c1":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm154,-322r13,29r-77,33r-9,-20","w":218},"\u00cb":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm160,-287v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm102,-287v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":205},"\u00c8":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm65,-322r73,42r-9,20r-77,-33","w":205},"\u00cd":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm96,-322r13,29r-77,33r-9,-20","w":104},"\u00ce":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm116,-266r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":104},"\u00cf":{"d":"79,-240r0,240r-56,0r0,-240r56,0xm103,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm45,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":104},"\u00cc":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm8,-322r73,42r-9,20r-77,-33","w":104},"\u00d3":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm160,-322r13,29r-77,33r-9,-20","w":230},"\u00d4":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm182,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":230},"\u00d2":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm77,-322r73,42r-9,20r-77,-33","w":230},"\u00da":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm165,-322r13,29r-77,33r-9,-20","w":233},"\u00db":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm185,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":233},"\u00d9":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm76,-322r73,42r-9,20r-77,-33","w":233},"\u0131":{"d":"74,-178r0,178r-52,0r0,-178r52,0","w":95},"\u02c6":{"d":"155,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":180},"\u02dc":{"d":"31,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":180},"\u02c9":{"d":"144,-241r0,25r-108,0r0,-25r108,0","w":180},"\u02d8":{"d":"146,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":180},"\u02d9":{"d":"111,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":180},"\u02da":{"d":"124,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm76,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":180},"\u00b8":{"d":"97,44v-1,-12,-15,-15,-29,-12r12,-32r17,0r-6,18v18,-5,36,10,36,26v-1,34,-48,35,-73,18r6,-15v15,8,33,15,37,-3","w":180},"\u02dd":{"d":"101,-266r17,24r-62,38r-11,-17xm164,-266r17,24r-62,38r-11,-17","w":180},"\u02db":{"d":"175,55v-23,13,-67,8,-68,-21v-1,-18,23,-39,55,-34v-16,9,-24,19,-24,28v1,15,19,20,34,13","w":180},"\u02c7":{"d":"26,-258r35,-4r29,25r29,-25r36,4r-65,55","w":180},"\u0141":{"d":"2,-99r22,-22r0,-119r57,0r0,82r48,-45r0,43r-48,45r0,68r95,0r0,47r-152,0r0,-78r-22,22r0,-43","w":181},"\u0142":{"d":"98,-145r-22,21r0,124r-52,0r0,-92r-22,21r0,-34r22,-20r0,-115r52,0r0,82r22,-21r0,34","w":100},"\u0160":{"d":"32,-120v-48,-45,-3,-124,67,-124v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40v21,9,40,32,40,62v0,73,-103,101,-162,63v-17,-11,-28,-28,-34,-50r52,-12v2,38,81,49,87,9v-2,-22,-18,-23,-42,-28v-31,-7,-52,-15,-65,-26xm39,-315r35,-4r29,25r29,-25r36,4r-65,55","w":209},"\u0161":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v63,29,25,111,-47,111v-45,0,-72,-18,-81,-53r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21xm20,-258r35,-4r29,25r29,-25r36,4r-65,55","w":170},"\u017d":{"d":"197,-199r-121,153r125,0r0,46r-194,0r0,-41r121,-154r-113,0r0,-45r182,0r0,41xm42,-314r35,-4r29,25r29,-25r36,4r-65,55","w":208},"\u017e":{"d":"143,-178r0,33r-79,107r83,0r0,38r-140,0r0,-38r78,-104r-71,0r0,-36r129,0xm15,-258r35,-4r29,25r29,-25r36,4r-65,55","w":154},"\u00a6":{"d":"65,-240r50,0r0,125r-50,0r0,-125xm65,-55r50,0r0,115r-50,0r0,-115","w":180},"\u00d0":{"d":"221,-121v3,68,-44,121,-114,121r-83,0r0,-105r-22,0r0,-36r22,0r0,-99r73,0v86,-2,121,42,124,119xm163,-122v-1,-47,-26,-83,-84,-74r0,55r42,0r0,36r-42,0r0,60v58,8,84,-27,84,-77","w":233},"\u00f0":{"d":"11,-87v-3,-58,69,-123,112,-71v-4,-21,-11,-38,-22,-48r-32,16r-11,-16r28,-15v-6,-4,-17,-8,-31,-13r8,-19v18,4,35,10,50,19r33,-16r13,15r-29,15v25,22,52,72,52,121v0,62,-31,101,-85,103v-52,2,-84,-42,-86,-91xm97,-31v25,-4,29,-20,29,-57v0,-36,-10,-55,-29,-55v-20,0,-30,17,-30,52v0,38,3,57,30,60","w":192},"\u00dd":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm141,-322r13,29r-77,33r-9,-20","w":187},"\u00fd":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0xm128,-266r13,29r-77,33r-9,-20","w":160},"\u00de":{"d":"210,-134v1,68,-53,83,-129,77r0,57r-57,0r0,-240r57,0r0,32v74,-5,128,9,129,74xm153,-132v0,-33,-37,-34,-74,-32r0,64v36,2,74,2,74,-32","w":219},"\u00fe":{"d":"182,-91v12,76,-69,127,-110,71r0,80r-50,0r0,-300r50,0r0,85v38,-58,121,-8,110,64xm128,-92v0,-67,-56,-68,-56,-12v0,35,-3,70,28,71v24,-4,28,-21,28,-59","w":194},"\u2212":{"d":"195,-140r0,38r-178,0r0,-38r178,0","w":211},"\u00d7":{"d":"155,-198r27,27r-49,50r51,51r-27,27r-51,-51r-50,49r-27,-27r50,-49r-52,-52r27,-27r52,52","w":211},"\u00b9":{"d":"7,-181r0,-32v27,-7,44,-17,52,-29r28,0r0,118r38,0r0,28r-118,0r0,-28r42,0r0,-78v-17,9,-30,17,-42,21","w":139},"\u00b2":{"d":"126,-196v0,39,-33,47,-68,69r70,0r-2,31r-118,0r0,-29v27,-21,74,-39,79,-71v2,-11,-9,-18,-20,-18v-15,0,-23,10,-25,28r-34,-7v4,-64,118,-65,118,-3","w":139},"\u00b3":{"d":"89,-140v1,-20,-22,-17,-43,-17r0,-27v18,1,41,0,39,-16v-3,-23,-40,-19,-42,3r-34,-5v5,-49,111,-57,114,-1v0,15,-7,25,-23,31v19,5,28,17,28,34v3,45,-73,56,-104,31v-11,-9,-17,-19,-19,-32r35,-5v0,27,49,31,49,4","w":139},"\u00bd":{"d":"5,-181r0,-32v27,-7,44,-17,52,-29r28,0r0,118r38,0r0,28r-118,0r0,-28r42,0r0,-78v-17,9,-30,17,-42,21xm78,0r133,-240r28,0r-133,240r-28,0xm310,-100v0,39,-33,47,-68,69r70,0r-2,31r-118,0r0,-29v27,-21,74,-39,79,-71v2,-11,-9,-18,-20,-18v-15,0,-23,10,-25,28r-34,-7v4,-64,118,-65,118,-3","w":316},"\u00bc":{"d":"4,-181r0,-32v27,-7,44,-17,52,-29r28,0r0,118r38,0r0,28r-118,0r0,-28r42,0r0,-78v-17,9,-30,17,-42,21xm79,0r133,-240r28,0r-133,240r-28,0xm296,-146r0,86r22,0r0,27r-22,0r0,33r-36,0r0,-33r-69,0r0,-26r62,-87r43,0xm220,-58r41,0r0,-60","w":316},"\u00be":{"d":"89,-140v1,-20,-22,-17,-43,-17r0,-27v18,1,41,0,39,-16v-3,-23,-40,-19,-42,3r-34,-5v5,-49,111,-57,114,-1v0,15,-7,25,-23,31v19,5,28,17,28,34v3,45,-73,56,-104,31v-11,-9,-17,-19,-19,-32r35,-5v0,27,49,31,49,4xm85,0r133,-240r28,0r-133,240r-28,0xm288,-146r0,86r22,0r0,27r-22,0r0,33r-36,0r0,-33r-69,0r0,-26r62,-87r43,0xm212,-58r41,0r0,-60","w":316},"\u20a3":{"d":"82,-66r41,0r0,36r-41,0r0,30r-58,0r0,-30r-22,0r0,-36r22,0r0,-174r171,0r0,48r-113,0r0,53r89,0r0,45r-89,0r0,28","w":199},"\u011e":{"d":"70,-118v0,54,34,96,76,66v9,-6,12,-17,12,-31r-46,0r0,-45r99,0r0,128r-26,0v-2,-9,-4,-19,-8,-28v-17,21,-39,32,-65,32v-65,0,-99,-53,-99,-121v0,-71,37,-127,103,-127v55,0,87,35,95,83r-53,7v-4,-29,-19,-44,-42,-44v-35,0,-46,37,-46,80xm176,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":231},"\u011f":{"d":"144,-173v1,-28,21,-40,55,-34r0,34v-16,-4,-32,-2,-34,13v44,53,-24,106,-95,86v-11,6,-13,23,-1,26v47,12,129,-7,129,52v0,45,-42,60,-103,59v-54,-1,-91,-5,-91,-42v0,-16,10,-26,30,-32v-36,-18,-26,-58,13,-71v-63,-32,-21,-99,50,-99v16,0,32,3,47,8xm127,-126v0,-16,-12,-27,-30,-27v-18,0,-29,11,-29,27v0,18,10,27,29,27v17,0,30,-10,30,-27xm149,14v-4,-22,-52,-10,-87,-15v-5,0,-14,8,-13,14v2,18,29,18,51,18v27,0,45,0,49,-17xm156,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":199},"\u0130":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm73,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":104},"\u015e":{"d":"156,-138v75,35,32,155,-57,142r-4,14v22,-6,42,9,42,29v-1,38,-56,37,-83,19r6,-15v12,6,21,9,28,9v9,1,18,-5,17,-14v-2,-13,-18,-17,-34,-12r9,-32v-39,-3,-72,-27,-80,-65r52,-12v2,38,81,49,87,9v-2,-22,-18,-22,-42,-28v-52,-12,-85,-22,-85,-74v0,-44,38,-76,87,-76v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40","w":209},"\u015f":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v35,9,43,67,13,92v-14,11,-32,18,-59,19r-5,14v18,-5,36,10,36,26v-1,34,-49,35,-73,18r6,-15v15,8,33,15,37,-3v-1,-12,-15,-15,-29,-12r11,-29v-36,-4,-57,-22,-65,-52r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21","w":170},"\u0106":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124xm166,-322r13,29r-77,33r-9,-20","w":225},"\u0107":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51xm144,-266r13,29r-77,33r-9,-20","w":184},"\u010c":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124xm59,-314r35,-4r29,25r29,-25r36,4r-65,55","w":225},"\u010d":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51xm35,-258r35,-4r29,25r29,-25r36,4r-65,55","w":184},"\u0111":{"d":"12,-87v0,-54,18,-92,66,-93v21,0,35,7,44,23r0,-38r-45,0r0,-24r45,0r0,-21r50,0r0,21r21,0r0,24r-21,0r0,195r-48,0r0,-28v-12,21,-28,32,-49,32v-45,-1,-63,-42,-63,-91xm66,-86v0,66,54,67,56,16v1,-32,2,-75,-26,-75v-20,0,-30,20,-30,59","w":194},"\u00ad":{"d":"4,-110r84,0r0,38r-84,0r0,-38","w":92},"\u00af":{"d":"0,-322r180,0r0,42r-180,0r0,-42","w":180},"\u00b7":{"d":"54,-65r-54,0r0,-53r54,0r0,53","w":54},"\u0100":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm162,-297r0,25r-108,0r0,-25r108,0","w":218},"\u0101":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm153,-241r0,25r-108,0r0,-25r108,0","w":194},"\u0102":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm165,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":218},"\u0103":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm156,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":194},"\u0104":{"d":"232,58v-26,13,-73,9,-73,-23v0,-15,11,-27,33,-35r-35,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0r75,240v-16,8,-25,18,-25,30v0,17,22,19,37,13xm78,-94r51,0r-26,-84","w":218},"\u0105":{"d":"11,-46v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-29,9,-31,26r-48,-5v4,-39,41,-55,83,-55v46,0,74,12,74,67v0,36,-3,84,3,114v-16,9,-24,19,-24,28v1,15,19,20,34,13r4,14v-23,13,-69,8,-69,-21v0,-14,10,-25,31,-34r-26,0v-2,-7,-3,-17,-3,-28v-20,47,-117,42,-112,-18xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23","w":194},"\u0108":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124xm187,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":225},"\u0109":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51xm164,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":184},"\u010a":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124xm143,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":225},"\u010b":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51xm120,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":184},"\u010e":{"d":"164,-228v92,48,66,241,-57,228r-83,0r0,-240v47,1,111,-3,140,12xm163,-122v0,-51,-27,-81,-84,-74r0,151v58,8,84,-27,84,-77xm43,-315r35,-4r29,25r29,-25r36,4r-65,55","w":233},"\u010f":{"d":"12,-87v0,-53,19,-93,66,-94v19,0,34,7,44,22r0,-81r50,0r0,240r-48,0r0,-28v-12,21,-28,32,-49,32v-45,-1,-63,-42,-63,-91xm66,-86v0,66,54,67,56,16v1,-32,2,-75,-26,-75v-20,0,-30,20,-30,59xm238,-240r-32,71r-19,0r10,-71r41,0","w":235},"\u0110":{"d":"221,-121v3,68,-44,121,-114,121r-83,0r0,-105r-22,0r0,-36r22,0r0,-99r73,0v86,-2,121,42,124,119xm163,-122v-1,-47,-26,-83,-84,-74r0,55r42,0r0,36r-42,0r0,60v58,8,84,-27,84,-77","w":233},"\u0112":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm163,-297r0,25r-108,0r0,-25r108,0","w":205},"\u0113":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm155,-241r0,25r-108,0r0,-25r108,0","w":192},"\u0114":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm166,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":205},"\u0115":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm158,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":192},"\u0116":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm131,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":205},"\u0117":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm121,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":192},"\u0118":{"d":"211,58v-26,13,-73,9,-73,-23v0,-15,10,-27,32,-35r-146,0r0,-240r171,0r0,46r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47v-16,8,-24,18,-24,30v0,17,21,19,36,13","w":205},"\u0119":{"d":"180,-58v-3,29,-53,58,-53,85v0,16,18,19,33,13r4,14v-28,16,-85,1,-64,-36v3,-4,10,-11,21,-17v-63,15,-110,-29,-110,-88v0,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37","w":192},"\u011a":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm46,-314r35,-4r29,25r29,-25r36,4r-65,55","w":205},"\u011b":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm37,-258r35,-4r29,25r29,-25r36,4r-65,55","w":192},"\u011c":{"d":"70,-118v0,54,34,96,76,66v9,-6,12,-17,12,-31r-46,0r0,-45r99,0r0,128r-26,0v-2,-9,-4,-19,-8,-28v-17,21,-39,32,-65,32v-65,0,-99,-53,-99,-121v0,-71,37,-127,103,-127v55,0,87,35,95,83r-53,7v-4,-29,-19,-44,-42,-44v-35,0,-46,37,-46,80xm185,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":231},"\u011d":{"d":"144,-173v1,-28,21,-40,55,-34r0,34v-16,-4,-32,-2,-34,13v44,53,-24,106,-95,86v-11,6,-13,23,-1,26v47,12,129,-7,129,52v0,45,-42,60,-103,59v-54,-1,-91,-5,-91,-42v0,-16,10,-26,30,-32v-36,-18,-26,-58,13,-71v-63,-32,-21,-99,50,-99v16,0,32,3,47,8xm127,-126v0,-16,-12,-27,-30,-27v-18,0,-29,11,-29,27v0,18,10,27,29,27v17,0,30,-10,30,-27xm149,14v-4,-22,-52,-10,-87,-15v-5,0,-14,8,-13,14v2,18,29,18,51,18v27,0,45,0,49,-17xm159,-213r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":199},"\u0120":{"d":"70,-118v0,54,34,96,76,66v9,-6,12,-17,12,-31r-46,0r0,-45r99,0r0,128r-26,0v-2,-9,-4,-19,-8,-28v-17,21,-39,32,-65,32v-65,0,-99,-53,-99,-121v0,-71,37,-127,103,-127v55,0,87,35,95,83r-53,7v-4,-29,-19,-44,-42,-44v-35,0,-46,37,-46,80xm140,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":231},"\u0121":{"d":"144,-173v1,-28,21,-40,55,-34r0,34v-16,-4,-32,-2,-34,13v44,53,-24,106,-95,86v-11,6,-13,23,-1,26v47,12,129,-7,129,52v0,45,-42,60,-103,59v-54,-1,-91,-5,-91,-42v0,-16,10,-26,30,-32v-36,-18,-26,-58,13,-71v-63,-32,-21,-99,50,-99v16,0,32,3,47,8xm127,-126v0,-16,-12,-27,-30,-27v-18,0,-29,11,-29,27v0,18,10,27,29,27v17,0,30,-10,30,-27xm149,14v-4,-22,-52,-10,-87,-15v-5,0,-14,8,-13,14v2,18,29,18,51,18v27,0,45,0,49,-17xm121,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":199},"\u0122":{"d":"70,-118v0,54,34,96,76,66v9,-6,12,-17,12,-31r-46,0r0,-45r99,0r0,128r-26,0v-2,-9,-4,-19,-8,-28v-17,21,-39,32,-65,32v-65,0,-99,-53,-99,-121v0,-71,37,-127,103,-127v55,0,87,35,95,83r-53,7v-4,-29,-19,-44,-42,-44v-35,0,-46,37,-46,80xm138,19r-32,68r-19,0r10,-68r41,0","w":231},"\u0123":{"d":"144,-173v1,-28,21,-40,55,-34r0,34v-16,-4,-32,-2,-34,13v44,53,-24,106,-95,86v-11,6,-13,23,-1,26v47,12,129,-7,129,52v0,45,-42,60,-103,59v-54,-1,-91,-5,-91,-42v0,-16,10,-26,30,-32v-36,-18,-26,-58,13,-71v-63,-32,-21,-99,50,-99v16,0,32,3,47,8xm127,-126v0,-16,-12,-27,-30,-27v-18,0,-29,11,-29,27v0,18,10,27,29,27v17,0,30,-10,30,-27xm149,14v-4,-22,-52,-10,-87,-15v-5,0,-14,8,-13,14v2,18,29,18,51,18v27,0,45,0,49,-17xm77,-205r32,-71r19,0r-10,71r-41,0","w":199},"\u0124":{"d":"210,-240r0,240r-56,0r0,-99r-75,0r0,99r-55,0r0,-240r55,0r0,94r75,0r0,-94r56,0xm182,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":233},"\u0125":{"d":"102,-140v-50,0,-24,91,-30,140r-50,0r0,-240r50,0r0,87v24,-48,102,-33,102,36r0,117r-52,0r0,-100v1,-26,0,-40,-20,-40xm114,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":195},"\u0126":{"d":"231,-212r0,36r-21,0r0,176r-56,0r0,-99r-75,0r0,99r-55,0r0,-176r-22,0r0,-36r22,0r0,-28r55,0r0,28r75,0r0,-28r56,0r0,28r21,0xm79,-176r0,30r75,0r0,-30r-75,0","w":233},"\u0127":{"d":"102,-140v-50,0,-24,91,-30,140r-50,0r0,-195r-21,0r0,-24r21,0r0,-21r50,0r0,21r46,0r0,24r-46,0r0,44v9,-19,26,-29,49,-29v80,-3,46,109,53,180r-52,0r0,-100v1,-26,0,-40,-20,-40","w":195},"\u0128":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm-7,-288v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":104},"\u0129":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm-11,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":95},"\u012a":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm108,-297r0,25r-108,0r0,-25r108,0","w":104},"\u012b":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm103,-241r0,25r-108,0r0,-25r108,0","w":95},"\u012c":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm107,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":104},"\u012d":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm104,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":95},"\u012e":{"d":"93,58v-26,14,-68,7,-68,-23v0,-14,10,-26,31,-35r-32,0r0,-240r56,0r0,240v-24,13,-32,41,-4,46v3,0,8,-1,14,-3","w":104},"\u012f":{"d":"74,-245r0,53r-52,0r0,-53r52,0xm21,34v1,-20,10,-22,30,-34r-29,0r0,-178r52,0r0,178v-15,9,-22,19,-22,29v1,13,15,19,30,12r4,14v-22,13,-67,8,-65,-21","w":95},"\u0132":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm103,-47v31,5,57,7,57,-29r0,-164r56,0r0,171v5,66,-50,82,-113,69r0,-47","w":238},"\u0133":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm74,-245r0,53r-52,0r0,-53r52,0xm85,20v24,4,32,-3,32,-30r0,-168r54,0r0,194v-2,40,-40,56,-86,45r0,-41xm171,-245r0,53r-54,0r0,-53r54,0","w":192},"\u0134":{"d":"2,-47v31,5,57,7,57,-29r0,-164r56,0r0,171v5,66,-50,82,-113,69r0,-47xm154,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":137},"\u0135":{"d":"-11,20v25,4,34,-4,33,-30r0,-168r53,0r0,194v0,42,-41,55,-86,45r0,-41xm112,-209r-36,4r-28,-24r-29,24r-36,-4r65,-55","w":96},"\u0136":{"d":"79,-240r0,113r76,-113r53,0r-57,86r72,154r-62,0r-48,-104r-34,49r0,55r-55,0r0,-240r55,0xm141,19r-32,68r-19,0r10,-68r41,0","w":226},"\u0137":{"d":"139,-117r58,117r-58,0r-37,-81r-31,36r0,45r-49,0r0,-240r49,0r0,144v21,-29,45,-55,68,-82r51,0xm126,19r-32,68r-19,0r10,-68r41,0","w":195},"\u0138":{"d":"139,-117r58,117r-58,0r-37,-81r-31,36r0,45r-49,0r0,-178r49,0r0,82v21,-29,45,-55,68,-82r51,0","w":195},"\u0139":{"d":"81,-47r95,0r0,47r-152,0r0,-240r57,0r0,193xm97,-322r13,29r-77,33r-9,-20","w":181},"\u013a":{"d":"22,0r0,-240r52,0r0,240r-52,0xm92,-322r13,29r-77,33r-9,-20","w":95},"\u013b":{"d":"81,-47r95,0r0,47r-152,0r0,-240r57,0r0,193xm122,19r-32,68r-19,0r10,-68r41,0","w":181},"\u013c":{"d":"22,0r0,-240r52,0r0,240r-52,0xm68,19r-32,68r-19,0r10,-68r41,0","w":95},"\u013d":{"d":"81,-47r95,0r0,47r-152,0r0,-240r57,0r0,193xm161,-240r-32,71r-19,0r10,-71r41,0","w":181},"\u013e":{"d":"22,0r0,-240r52,0r0,240r-52,0xm139,-240r-32,71r-19,0r10,-71r41,0","w":136},"\u013f":{"d":"81,-47r95,0r0,47r-152,0r0,-240r57,0r0,193xm169,-97r-54,0r0,-53r54,0r0,53","w":181},"\u0140":{"d":"22,0r0,-240r52,0r0,240r-52,0xm150,-97r-54,0r0,-53r54,0r0,53","w":149},"\u0143":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0xm162,-322r13,29r-77,33r-9,-20","w":232},"\u0144":{"d":"70,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31xm142,-266r13,29r-77,33r-9,-20","w":197},"\u0145":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0xm139,19r-32,68r-19,0r10,-68r41,0","w":232},"\u0146":{"d":"70,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31xm122,19r-32,68r-19,0r10,-68r41,0","w":197},"\u0147":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0xm59,-314r35,-4r29,25r29,-25r36,4r-65,55","w":232},"\u0148":{"d":"70,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31xm32,-258r35,-4r29,25r29,-25r36,4r-65,55","w":197},"\u0149":{"d":"133,-147v21,-54,106,-44,106,33r0,114r-52,0r0,-100v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31xm21,-142r24,-48r-24,0r0,-50r51,0r0,44r-32,54r-19,0","w":260},"\u014a":{"d":"121,-196v-70,5,-33,127,-42,196r-55,0r0,-240r54,0r0,41v17,-31,28,-45,66,-45v89,0,60,121,66,208v5,78,-27,111,-99,96r0,-42v33,5,43,-5,43,-40r0,-119v1,-37,-3,-51,-33,-55","w":233},"\u014b":{"d":"176,-114v-8,86,26,204,-85,175r0,-41v55,12,33,-75,33,-120v0,-26,-1,-40,-22,-40v-46,0,-23,93,-28,140r-52,0r0,-178r48,0r0,31v21,-54,113,-44,106,33","w":197},"\u014c":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm171,-297r0,25r-108,0r0,-25r108,0","w":230},"\u014d":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm152,-241r0,25r-108,0r0,-25r108,0","w":192},"\u014e":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm171,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":230},"\u014f":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm153,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":192},"\u0150":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm123,-322r17,24r-62,38r-11,-17xm186,-322r17,24r-62,38r-11,-17","w":230},"\u0151":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm105,-266r17,24r-62,38r-11,-17xm168,-266r17,24r-62,38r-11,-17","w":192},"\u0154":{"d":"130,-240v88,-14,119,104,46,134r44,106r-62,0r-37,-95r-40,0r0,95r-57,0r0,-240r106,0xm159,-168v0,-35,-41,-29,-78,-29r0,61v39,1,78,5,78,-32xm156,-322r13,29r-77,33r-9,-20","w":236},"\u0155":{"d":"117,-129v-60,-3,-42,74,-45,129r-50,0r0,-178r48,0r0,34v9,-28,20,-39,47,-37r0,52xm118,-266r13,29r-77,33r-9,-20","w":124},"\u0156":{"d":"130,-240v88,-14,119,104,46,134r44,106r-62,0r-37,-95r-40,0r0,95r-57,0r0,-240r106,0xm159,-168v0,-35,-41,-29,-78,-29r0,61v39,1,78,5,78,-32xm141,19r-32,68r-19,0r10,-68r41,0","w":236},"\u0157":{"d":"117,-129v-60,-3,-42,74,-45,129r-50,0r0,-178r48,0r0,34v9,-28,20,-39,47,-37r0,52xm68,19r-32,68r-19,0r10,-68r41,0","w":124},"\u0158":{"d":"130,-240v88,-14,119,104,46,134r44,106r-62,0r-37,-95r-40,0r0,95r-57,0r0,-240r106,0xm159,-168v0,-35,-41,-29,-78,-29r0,61v39,1,78,5,78,-32xm48,-316r35,-4r29,25r29,-25r36,4r-65,55","w":236},"\u0159":{"d":"117,-129v-60,-3,-42,74,-45,129r-50,0r0,-178r48,0r0,34v9,-28,20,-39,47,-37r0,52xm7,-258r35,-4r29,25r29,-25r36,4r-65,55","w":124},"\u015a":{"d":"32,-120v-48,-45,-3,-124,67,-124v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40v21,9,40,32,40,62v0,73,-103,101,-162,63v-17,-11,-28,-28,-34,-50r52,-12v2,38,81,49,87,9v-2,-22,-18,-23,-42,-28v-31,-7,-52,-15,-65,-26xm147,-323r13,29r-77,33r-9,-20","w":209},"\u015b":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v63,29,25,111,-47,111v-45,0,-72,-18,-81,-53r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21xm129,-266r13,29r-77,33r-9,-20","w":170},"\u015c":{"d":"32,-120v-48,-45,-3,-124,67,-124v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40v21,9,40,32,40,62v0,73,-103,101,-162,63v-17,-11,-28,-28,-34,-50r52,-12v2,38,81,49,87,9v-2,-22,-18,-23,-42,-28v-31,-7,-52,-15,-65,-26xm168,-266r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":209},"\u015d":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v63,29,25,111,-47,111v-45,0,-72,-18,-81,-53r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21xm149,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":170},"\u0162":{"d":"176,-240r0,48r-59,0r0,192r-57,0r0,-192r-60,0r0,-48r176,0xm111,19r-32,68r-19,0r10,-68r41,0","w":176},"\u0163":{"d":"121,0v-54,10,-93,3,-93,-54r0,-83r-28,0r0,-41r31,0r5,-52r45,-3r0,55r38,0r0,41r-38,0r0,75v-3,27,17,25,40,23r0,39xm95,19r-32,68r-19,0r10,-68r41,0","w":126},"\u0164":{"d":"176,-240r0,48r-59,0r0,192r-57,0r0,-192r-60,0r0,-48r176,0xm24,-315r35,-4r29,25r29,-25r36,4r-65,55","w":176},"\u0165":{"d":"121,0v-54,10,-93,3,-93,-54r0,-83r-28,0r0,-41r31,0r5,-52r45,-3r0,55r38,0r0,41r-38,0r0,75v-3,27,17,25,40,23r0,39xm151,-268r-32,71r-19,0r10,-71r41,0","w":147},"\u0166":{"d":"17,-121r0,-36r43,0r0,-35r-60,0r0,-48r176,0r0,48r-59,0r0,35r43,0r0,36r-43,0r0,121r-57,0r0,-121r-43,0","w":176},"\u0167":{"d":"121,0v-54,10,-95,3,-93,-54r0,-33r-25,0r0,-24r25,0r0,-26r-28,0r0,-41r31,0r5,-52r45,-3r0,55r38,0r0,41r-38,0r0,26r35,0r0,24r-35,0v1,25,-7,53,24,49v5,0,10,-1,16,-1r0,39","w":126},"\u0168":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm64,-288v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":233},"\u0169":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm39,-230v30,-46,76,16,104,-21r14,19v-21,32,-50,23,-81,11v-7,0,-14,3,-22,11","w":194},"\u016a":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm171,-297r0,25r-108,0r0,-25r108,0","w":233},"\u016b":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm151,-241r0,25r-108,0r0,-25r108,0","w":194},"\u016c":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm178,-312v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":233},"\u016d":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm153,-258v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":194},"\u016e":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm154,-287v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm106,-287v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":233},"\u016f":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm131,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm83,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":194},"\u0170":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0r0,149v4,71,-32,95,-95,95v-65,0,-96,-27,-96,-95r0,-149r61,0r0,149v-3,35,11,49,40,49xm128,-322r17,24r-62,38r-11,-17xm191,-322r17,24r-62,38r-11,-17","w":233},"\u0171":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178r-48,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24xm106,-266r17,24r-62,38r-11,-17xm169,-266r17,24r-62,38r-11,-17","w":194},"\u0172":{"d":"123,-42v33,0,42,-12,42,-49r0,-149r48,0v-8,82,24,197,-35,231v-18,11,-25,25,-25,36v0,19,23,22,37,14r4,16v-31,18,-91,0,-69,-38v3,-5,10,-11,22,-18v-75,11,-125,-13,-125,-92r0,-149r61,0r0,149v-3,35,11,49,40,49","w":233},"\u0173":{"d":"92,-38v52,-3,21,-91,29,-140r52,0r0,178v-16,9,-24,19,-24,28v-1,16,19,19,34,13r3,14v-22,13,-69,9,-68,-21v0,-14,10,-25,31,-34r-24,0r0,-30v-9,23,-27,34,-53,34v-78,1,-42,-112,-50,-182r50,0r0,116v0,16,7,24,20,24","w":194},"\u0174":{"d":"312,-240r-60,240r-55,0r-40,-159r-38,159r-55,0r-62,-240r58,0r37,162r39,-162r52,0r40,162r38,-162r46,0xm228,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":314},"\u0175":{"d":"256,-178r-53,178r-46,0r-28,-114r-28,114r-44,0r-55,-178r55,0r28,109r27,-109r48,0r26,110r30,-110r40,0xm199,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":259},"\u0176":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm161,-265r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":187},"\u0177":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0xm146,-209r-36,4r-29,-24r-29,24r-35,-4r64,-55","w":160},"\u0179":{"d":"197,-199r-121,153r125,0r0,46r-194,0r0,-41r121,-154r-113,0r0,-45r182,0r0,41xm150,-322r13,29r-77,33r-9,-20","w":208},"\u017a":{"d":"143,-178r0,33r-79,107r83,0r0,38r-140,0r0,-38r78,-104r-71,0r0,-36r129,0xm125,-266r13,29r-77,33r-9,-20","w":154},"\u017b":{"d":"197,-199r-121,153r125,0r0,46r-194,0r0,-41r121,-154r-113,0r0,-45r182,0r0,41xm127,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":208},"\u017c":{"d":"143,-178r0,33r-79,107r83,0r0,38r-140,0r0,-38r78,-104r-71,0r0,-36r129,0xm100,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,9,21,20","w":154},"\u017f":{"d":"161,-207v-24,-4,-37,-1,-37,23r0,184r-51,0r0,-178v-4,-61,31,-77,88,-70r0,41","w":211},"\u01fa":{"d":"137,-342r12,31r-78,27r-9,-21xm109,-287v25,0,45,24,32,48r76,239r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240v-13,-22,8,-47,32,-47xm94,-255v0,10,6,16,15,16v8,0,16,-7,16,-15v0,-9,-7,-16,-16,-15v-8,-1,-15,6,-15,14xm78,-94r51,0r-26,-90","w":218},"\u01fb":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23xm136,-226v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm88,-226v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13xm125,-319r13,29r-77,33r-9,-20","w":194},"\u01fc":{"d":"294,-195r-110,0r0,50r88,0r0,45r-88,0r0,53r110,0r0,47r-167,0r0,-55r-56,0r-25,55r-48,0r109,-240r187,0r0,45xm88,-95r39,0r0,-87xm234,-322r13,29r-77,33r-9,-20","w":303},"\u01fd":{"d":"17,-125v3,-57,91,-71,132,-40v62,-42,138,5,128,85r-110,0v-9,53,56,61,64,19r46,4v-12,70,-107,80,-146,29v-28,45,-120,45,-120,-18v0,-54,37,-58,109,-65v2,-23,-3,-37,-26,-36v-18,0,-28,9,-30,27xm228,-111v-2,-24,-8,-36,-29,-36v-19,0,-29,12,-32,36r61,0xm86,-29v25,-1,38,-25,34,-56v-37,2,-55,13,-55,33v-1,12,8,24,21,23xm180,-266r13,29r-77,33r-9,-20","w":288},"\u01fe":{"d":"46,-25v-62,-66,-37,-219,71,-219v17,0,32,4,45,10r14,-25r32,0r-23,43v62,70,36,226,-73,220v-16,0,-31,-3,-44,-10r-14,26r-32,0xm139,-191v-58,-32,-80,53,-63,111xm92,-50v39,23,70,-5,67,-69v0,-16,-2,-30,-5,-43xm144,-322r13,29r-77,33r-9,-20","w":230},"\u01ff":{"d":"40,-16v-54,-48,-30,-165,55,-165v15,0,27,2,35,6r13,-21r28,0r-19,35v66,58,11,201,-90,159r-13,20r-28,0xm111,-142v-39,-21,-52,30,-43,77xm81,-36v28,15,46,-6,45,-50v0,-10,-1,-19,-2,-28xm125,-266r13,29r-77,33r-9,-20","w":192},"\u0384":{"d":"6,-259r28,19r-56,62r-17,-13","w":180},"\u0385":{"d":"117,-316r21,23r-51,37r-14,-16xm140,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm82,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":180},"\u0386":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84xm24,-259r28,19r-56,62r-17,-13","w":218},"\u0387":{"d":"54,-65r-54,0r0,-53r54,0r0,53","w":54},"\u0388":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm-20,-259r28,19r-56,62r-17,-13","w":205},"\u0389":{"d":"210,-240r0,240r-56,0r0,-99r-75,0r0,99r-55,0r0,-240r55,0r0,94r75,0r0,-94r56,0xm-20,-259r28,19r-56,62r-17,-13","w":233},"\u038a":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm-20,-259r28,19r-56,62r-17,-13","w":104},"\u038c":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78xm5,-259r28,19r-56,62r-17,-13","w":230},"\u038e":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm-45,-259r28,19r-56,62r-17,-13","w":187},"\u038f":{"d":"123,-199v-71,0,-62,136,-13,154r0,45r-100,0r0,-45r58,0v-37,-16,-55,-47,-55,-93v0,-64,45,-104,110,-104v66,0,111,39,110,104v0,46,-18,77,-55,93r59,0r0,45r-100,0r0,-45v49,-19,58,-155,-14,-154xm1,-259r28,19r-56,62r-17,-13","w":246},"\u0390":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm75,-316r21,23r-51,37r-14,-16xm98,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm40,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":95},"\u0391":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84","w":218},"\u0392":{"d":"223,-66v0,42,-35,66,-87,66r-112,0r0,-240v82,3,192,-21,192,62v0,27,-14,44,-43,53v30,6,50,29,50,59xm158,-172v0,-35,-43,-25,-78,-26r0,53v34,0,78,7,78,-27xm164,-74v0,-35,-47,-28,-84,-28r0,58v37,-1,84,7,84,-30","w":234},"\u0393":{"d":"24,0r0,-240r144,0r0,48r-89,0r0,192r-55,0","w":168},"\u0394":{"d":"-5,0r79,-240r62,0r82,240r-223,0xm54,-47r91,0r-43,-145r-4,0","w":213},"\u0395":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46","w":205},"\u0396":{"d":"197,-199r-121,153r125,0r0,46r-194,0r0,-41r121,-154r-113,0r0,-45r182,0r0,41","w":208},"\u0397":{"d":"210,-240r0,240r-56,0r0,-99r-75,0r0,99r-55,0r0,-240r55,0r0,94r75,0r0,-94r56,0","w":233},"\u0398":{"d":"13,-121v2,-69,42,-122,112,-123v69,-1,112,54,112,124v0,70,-43,124,-113,124v-68,0,-113,-52,-111,-125xm181,-120v0,-42,-19,-77,-56,-78v-37,0,-55,39,-55,78v0,44,19,78,55,78v37,0,56,-36,56,-78xm157,-143r0,41r-64,0r0,-41r64,0","w":249},"\u0399":{"d":"80,-240r0,240r-56,0r0,-240r56,0","w":104},"\u039a":{"d":"79,-240r0,113r76,-113r53,0r-57,86r72,154r-62,0r-48,-104r-34,49r0,55r-55,0r0,-240r55,0","w":226},"\u039b":{"d":"44,0r-49,0r67,-240r75,0r69,240r-61,0r-50,-190","w":202},"\u039c":{"d":"130,0r-59,-196r0,196r-47,0r0,-240r87,0r42,144r45,-144r87,0r0,240r-56,0r0,-196r-60,196r-39,0","w":309},"\u039d":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0","w":232},"\u039e":{"d":"13,-195r0,-45r167,0r0,45r-167,0xm36,-101r0,-44r121,0r0,44r-121,0xm12,0r0,-47r169,0r0,47r-169,0","w":193},"\u039f":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78","w":230},"\u03a0":{"d":"24,0r0,-240r178,0r0,240r-55,0r0,-195r-68,0r0,195r-55,0","w":226},"\u03a1":{"d":"210,-166v0,67,-52,84,-129,77r0,89r-57,0r0,-240r94,0v59,-2,92,22,92,74xm153,-165v0,-35,-38,-32,-74,-31r0,63v36,1,74,3,74,-32","w":217},"\u03a3":{"d":"11,0r0,-45r69,-78r-64,-72r0,-45r160,0r0,45r-96,0r58,63r-72,85r117,0r0,47r-172,0","w":188},"\u03a4":{"d":"176,-240r0,48r-59,0r0,192r-57,0r0,-192r-60,0r0,-48r176,0","w":176},"\u03a5":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0","w":187},"\u03a6":{"d":"257,-120v0,61,-39,93,-99,98r0,29r-46,0r0,-29v-59,-5,-99,-37,-99,-98v0,-61,39,-93,99,-98r0,-29r46,0r0,29v62,5,99,37,99,98xm112,-178v-31,8,-47,27,-47,58v0,31,16,50,47,58r0,-116xm158,-62v31,-8,47,-27,47,-58v0,-31,-16,-50,-47,-58r0,116","w":270},"\u03a7":{"d":"207,-240r-66,112r74,128r-65,0r-48,-87r-48,87r-53,0r74,-128r-66,-112r65,0r39,73r41,-73r53,0","w":215},"\u03a8":{"d":"284,-169v4,89,-24,123,-104,126r0,43r-55,0r0,-43v-80,-2,-109,-37,-104,-126r0,-71r55,0r3,122v4,20,20,28,46,29r0,-151r55,0r0,151v71,3,43,-85,49,-151r55,0r0,71","w":304},"\u03a9":{"d":"123,-199v-71,0,-62,136,-13,154r0,45r-100,0r0,-45r58,0v-37,-16,-55,-47,-55,-93v0,-64,45,-104,110,-104v66,0,111,39,110,104v0,46,-18,77,-55,93r59,0r0,45r-100,0r0,-45v49,-19,58,-155,-14,-154","w":246},"\u03aa":{"d":"79,-240r0,240r-56,0r0,-240r56,0xm103,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm45,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":104},"\u03ab":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm150,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm92,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":187},"\u03ac":{"d":"11,-90v-9,-80,102,-128,138,-54r11,-34r55,0r-34,84r39,94r-58,0r-15,-41v-34,85,-144,35,-136,-49xm98,-146v-44,2,-42,115,0,115v25,0,31,-34,38,-59v-15,-38,-12,-49,-38,-56xm141,-266r13,29r-77,33r-9,-20","w":223},"\u03ad":{"d":"71,-126v1,19,15,20,41,20r0,30v-26,1,-44,0,-44,22v0,15,8,23,26,23v17,0,28,-9,32,-26r47,8v-9,32,-36,53,-79,53v-79,0,-114,-79,-42,-99v-22,-9,-33,-13,-33,-37v1,-34,31,-49,70,-49v47,0,73,16,81,49r-47,8v0,-28,-54,-30,-52,-2xm131,-266r13,29r-77,33r-9,-20","w":177},"\u03ae":{"d":"123,-181v43,0,58,21,58,71r0,170r-52,0r0,-171v0,-20,-8,-30,-23,-30v-53,0,-26,90,-32,141r-52,0r0,-178r48,0r0,28v11,-21,29,-31,53,-31xm140,-266r13,29r-77,33r-9,-20","w":201},"\u03af":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm79,-266r13,29r-77,33r-9,-20","w":95},"\u03b0":{"d":"101,4v-57,-4,-82,-21,-81,-84r0,-98r53,0r0,98v2,34,-4,49,26,49v30,0,27,-15,27,-49r0,-98r52,0v-2,86,19,189,-77,182xm126,-316r21,23r-51,37r-14,-16xm149,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm91,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":198},"\u03b1":{"d":"11,-90v-9,-80,102,-128,138,-54r11,-34r55,0r-34,84r39,94r-58,0r-15,-41v-34,85,-144,35,-136,-49xm98,-146v-44,2,-42,115,0,115v25,0,31,-34,38,-59v-15,-38,-12,-49,-38,-56","w":223},"\u03b2":{"d":"198,-70v0,63,-87,102,-123,49r0,81r-52,0r0,-215v-1,-62,22,-83,80,-89v81,-8,115,93,35,109v40,8,60,30,60,65xm103,-210v-26,0,-28,12,-28,48r0,114v22,33,72,12,68,-30v-2,-25,-12,-42,-42,-39r0,-30v23,1,31,-11,31,-31v0,-21,-9,-32,-29,-32","w":209},"\u03b3":{"d":"55,60r0,-62r-59,-176r56,0r35,115r40,-115r43,0r-63,176r0,62r-52,0","w":163},"\u03b4":{"d":"13,-84v0,-47,30,-75,76,-79r-55,-42r0,-35r134,0r0,38r-68,0v44,27,91,72,91,118v0,53,-35,88,-89,88v-54,0,-90,-34,-89,-88xm136,-83v0,-31,-6,-51,-34,-51v-26,0,-34,18,-34,52v0,32,8,51,34,51v28,0,34,-22,34,-52","w":203},"\u03b5":{"d":"71,-126v1,19,15,20,41,20r0,30v-26,1,-44,0,-44,22v0,15,8,23,26,23v17,0,28,-9,32,-26r47,8v-9,32,-36,53,-79,53v-79,0,-114,-79,-42,-99v-22,-9,-33,-13,-33,-37v1,-34,31,-49,70,-49v47,0,73,16,81,49r-47,8v0,-28,-54,-30,-52,-2","w":177},"\u03b6":{"d":"88,56v12,-24,23,-56,-13,-56v-42,0,-62,-24,-62,-69v0,-49,26,-94,79,-133r-68,0r0,-38r118,0r0,33v-41,23,-94,98,-65,157v21,18,70,0,70,53v0,17,-6,36,-16,58","w":148},"\u03b7":{"d":"123,-181v43,0,58,21,58,71r0,170r-52,0r0,-171v0,-20,-8,-30,-23,-30v-53,0,-26,90,-32,141r-52,0r0,-178r48,0r0,28v11,-21,29,-31,53,-31","w":201},"\u03b8":{"d":"13,-120v0,-70,25,-124,89,-124v63,0,89,55,88,124v0,68,-25,124,-88,124v-64,0,-89,-55,-89,-124xm67,-140r69,0v-2,-46,-13,-69,-34,-69v-22,0,-33,23,-35,69xm67,-108v0,51,12,77,35,77v22,0,33,-26,34,-77r-69,0","w":203},"\u03b9":{"d":"74,-178r0,178r-52,0r0,-178r52,0","w":95},"\u03ba":{"d":"133,-118r61,118r-55,0r-41,-79r-24,25r0,54r-52,0r0,-178r52,0r-1,73v21,-27,44,-48,66,-73r49,0","w":191},"\u03bb":{"d":"-4,0r60,-163r-29,-77r54,0r87,240r-54,0r-39,-113r-39,113r-40,0","w":163},"\u03bc":{"d":"139,-27v-7,38,-58,40,-65,7r0,80r-52,0r0,-238r52,0v6,52,-20,139,28,147v48,-6,21,-97,28,-147r52,0r0,178r-42,0","w":204},"\u03bd":{"d":"161,-178r-61,178r-40,0r-61,-178r54,0r34,113r35,-113r39,0","w":162},"\u03be":{"d":"67,-72v0,56,95,6,95,75v0,15,-4,35,-12,59r-44,-7v12,-29,20,-52,-19,-54v-51,-2,-76,-21,-76,-65v0,-37,22,-52,54,-63v-52,-10,-56,-62,-1,-75r-44,0r0,-38r136,0r0,38v-37,0,-75,-4,-77,30v-2,26,31,31,63,29r0,38v-39,-1,-75,-3,-75,33","w":163},"\u03bf":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59","w":192},"\u03c0":{"d":"27,0r0,-139r-20,0r0,-39r197,0r0,39r-21,0r0,139r-52,0r0,-139r-51,0r0,139r-53,0","w":210},"\u03c1":{"d":"193,-85v0,71,-76,118,-122,68r0,77r-52,0r0,-131v-4,-73,20,-110,85,-110v55,0,89,38,89,96xm138,-90v0,-35,-6,-56,-34,-56v-28,0,-32,21,-32,57v0,38,11,58,33,58v22,0,33,-20,33,-59","w":204},"\u03c2":{"d":"99,-146v-44,0,-40,87,-7,98v29,10,81,4,81,56v0,13,-4,31,-11,54r-45,-8v9,-20,17,-53,-14,-53v-56,0,-86,-33,-92,-90v-10,-100,150,-129,165,-30r-48,8v-2,-24,-12,-35,-29,-35","w":182},"\u03c3":{"d":"11,-88v-1,-63,49,-106,119,-90r71,0r0,39r-38,0v56,45,15,148,-61,143v-56,-4,-91,-34,-91,-92xm134,-89v0,-36,-6,-57,-34,-57v-27,0,-33,21,-33,57v0,39,11,58,33,58v22,0,34,-19,34,-58","w":205},"\u03c4":{"d":"48,0r0,-139r-49,0r0,-39r149,0r0,39r-48,0r0,139r-52,0","w":147},"\u03c5":{"d":"101,4v-57,-4,-82,-21,-81,-84r0,-98r53,0r0,98v2,34,-4,49,26,49v30,0,27,-15,27,-49r0,-98r52,0v-2,86,19,189,-77,182","w":198},"\u03c6":{"d":"246,-88v0,52,-39,90,-94,92r0,56r-48,0r0,-56v-100,8,-125,-152,-33,-177r12,39v-33,25,-24,96,21,102r0,-148v83,-10,142,24,142,92xm152,-31v27,-6,41,-26,41,-59v0,-31,-14,-50,-41,-57r0,116","w":257},"\u03c7":{"d":"60,-69r-58,-109r55,0r41,78r35,-78r46,0r-59,117r64,121r-55,0r-46,-91r-43,91r-47,0","w":179},"\u03c8":{"d":"254,-84v0,64,-30,86,-92,88r0,56r-50,0r0,-56v-63,-3,-92,-22,-91,-88r0,-94r52,0v2,42,-7,109,8,135v4,7,15,9,31,9r0,-144r50,0r0,144v66,6,30,-91,39,-144r53,0r0,94","w":274},"\u03c9":{"d":"93,-31v29,-3,14,-66,18,-102r48,0v3,37,-11,99,18,102v19,-3,26,-21,26,-48v0,-30,-10,-59,-29,-86r38,-18v64,46,67,187,-27,187v-29,0,-37,-10,-50,-33v-30,66,-124,25,-124,-52v0,-40,15,-74,46,-102r38,18v-19,27,-28,56,-28,86v0,28,5,46,26,48","w":269},"\u03ca":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm98,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm40,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":95},"\u03cb":{"d":"101,4v-57,-4,-82,-21,-81,-84r0,-98r53,0r0,98v2,34,-4,49,26,49v30,0,27,-15,27,-49r0,-98r52,0v-2,86,19,189,-77,182xm149,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm91,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":198},"\u03cc":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59xm128,-266r13,29r-77,33r-9,-20","w":192},"\u03cd":{"d":"101,4v-57,-4,-82,-21,-81,-84r0,-98r53,0r0,98v2,34,-4,49,26,49v30,0,27,-15,27,-49r0,-98r52,0v-2,86,19,189,-77,182xm131,-266r13,29r-77,33r-9,-20","w":198},"\u03ce":{"d":"93,-31v29,-3,14,-66,18,-102r48,0v3,37,-11,99,18,102v19,-3,26,-21,26,-48v0,-30,-10,-59,-29,-86r38,-18v64,46,67,187,-27,187v-29,0,-37,-10,-50,-33v-30,66,-124,25,-124,-52v0,-40,15,-74,46,-102r38,18v-19,27,-28,56,-28,86v0,28,5,46,26,48xm173,-266r13,29r-77,33r-9,-20","w":269},"\u0401":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46xm160,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm102,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":205},"\u0402":{"d":"129,-123v-54,-4,-35,73,-38,123r-56,0r0,-196r-38,0r0,-44r175,0r0,44r-81,0r0,60v13,-19,31,-28,57,-28v64,0,67,35,67,112v1,86,-11,111,-83,115r-3,-39v37,-5,32,-23,32,-72v0,-50,6,-72,-32,-75","w":229},"\u0403":{"d":"24,0r0,-240r137,0r0,48r-82,0r0,192r-55,0xm137,-323r13,29r-77,33r-9,-20","w":161,"k":{"\u045e":-4,"\u0459":24,"\u0454":22,"\u044f":16,"\u044e":7,"\u044a":-7,"\u0447":6,"\u0446":10,"\u0445":2,"\u0444":24,"\u0443":-2,"\u0442":-4,"\u0441":23,"\u0440":7,"\u043f":8,"\u043e":22,"\u043d":8,"\u043c":8,"\u043b":24,"\u043a":8,"\u0438":8,"\u0437":14,"\u0436":-2,"\u0435":23,"\u0434":28,"\u0432":8,"\u0430":19,"\u0427":-3,"\u0424":8,"\u0423":-15,"\u0422":-13,"\u041b":12,"\u0414":15,"\u040e":-15,"\u040b":-14,"\u0409":9}},"\u0404":{"d":"13,-120v-1,-73,38,-124,107,-124v48,0,80,23,98,66r-50,14v-9,-37,-65,-45,-86,-17v-8,11,-12,24,-12,38r83,0r0,39r-84,0v-7,66,90,86,104,23r51,10v-13,40,-48,76,-103,75v-71,-1,-108,-52,-108,-124","w":228},"\u0405":{"d":"32,-120v-48,-45,-3,-124,67,-124v47,0,78,19,91,57r-48,16v-2,-34,-73,-40,-74,-7v-1,33,73,26,88,40v21,9,40,32,40,62v0,73,-103,101,-162,63v-17,-11,-28,-28,-34,-50r52,-12v2,38,81,49,87,9v-2,-22,-18,-23,-42,-28v-31,-7,-52,-15,-65,-26","w":209},"\u0406":{"d":"80,-240r0,240r-56,0r0,-240r56,0","w":104},"\u0407":{"d":"80,-240r0,240r-56,0r0,-240r56,0xm104,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm46,-286v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":104},"\u0408":{"d":"2,-47v31,5,57,7,57,-29r0,-164r56,0r0,171v5,66,-50,82,-113,69r0,-47","w":137},"\u0409":{"d":"301,-77v-1,48,-33,77,-86,77r-79,0r-42,-195r-2,0r-48,195r-49,0r62,-240r80,0r22,88v79,-4,143,2,142,75xm185,-45v32,2,59,-1,59,-32v0,-37,-39,-31,-74,-31","w":306,"k":{"\u044a":-1,"\u042a":11,"\u0427":5,"\u0423":5,"\u0422":17,"\u040e":5,"\u040b":8}},"\u040a":{"d":"340,-75v0,48,-32,75,-81,75r-107,0r0,-103r-73,0r0,103r-55,0r0,-240r55,0r0,94r73,0r0,-94r55,0r0,92v73,-5,133,5,133,73xm207,-45v35,0,77,5,77,-31v0,-34,-43,-29,-77,-29r0,60","w":346,"k":{"\u042a":11,"\u0427":5,"\u0423":5,"\u0422":17,"\u040e":5,"\u040b":8}},"\u040b":{"d":"128,-122v-56,0,-32,73,-37,122r-56,0r0,-196r-38,0r0,-44r176,0r0,44r-82,0r0,60v12,-18,30,-28,55,-28v82,0,66,86,67,164r-55,0v-6,-44,20,-122,-30,-122","w":233},"\u040c":{"d":"79,-240r0,113r76,-113r53,0r-57,86r72,154r-62,0r-48,-104r-34,49r0,55r-55,0r0,-240r55,0xm158,-323r13,29r-77,33r-9,-20","w":226,"k":{"\u045e":13,"\u0454":10,"\u0447":17,"\u0444":10,"\u0443":13,"\u0442":13,"\u0441":9,"\u043e":9,"\u0437":2,"\u0435":9,"\u0431":8,"\u0430":2,"\u0424":15,"\u0421":10,"\u041e":10,"\u0417":4,"\u0404":11}},"\u040e":{"d":"81,-72r-88,-168r60,0r53,106r43,-106r50,0r-73,178v-18,45,-38,67,-102,62r0,-46v30,0,50,1,57,-26xm160,-311v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":191,"k":{"\u0459":17,"\u0454":16,"\u044f":13,"\u044e":8,"\u0447":7,"\u0446":10,"\u0445":3,"\u0444":17,"\u0442":-3,"\u0441":16,"\u0440":8,"\u043f":9,"\u043e":16,"\u043d":9,"\u043c":9,"\u043b":17,"\u043a":9,"\u0438":9,"\u0437":10,"\u0435":17,"\u0434":21,"\u0431":9,"\u0430":15,"\u042f":5,"\u0427":-6,"\u0424":10,"\u0422":-15,"\u0421":7,"\u041e":7,"\u041b":11,"\u0414":13,"\u0410":16,"\u040e":-18,"\u040b":-17,"\u0409":10,"\u0404":7}},"\u040f":{"d":"79,-45r70,0r0,-195r55,0r0,240r-69,0r-1,50r-40,0r-2,-50r-68,0r0,-240r55,0r0,195","w":227},"\u0410":{"d":"142,-240r75,240r-60,0r-15,-49r-78,0r-15,49r-49,0r77,-240r65,0xm78,-94r51,0r-26,-84","w":218,"k":{"\u045e":7,"\u0459":-13,"\u044a":4,"\u0447":10,"\u0444":5,"\u0443":6,"\u0442":7,"\u0441":3,"\u043e":3,"\u043b":-13,"\u0437":-1,"\u042a":9,"\u0427":15,"\u0424":10,"\u0422":15,"\u0421":8,"\u041e":8,"\u041b":-14,"\u040b":6,"\u0409":-14,"\u0404":8,"\u00bb":1,";":-2,":":-2,".":-8,"-":-7,",":-8}},"\u0411":{"d":"211,-73v0,47,-31,74,-80,73r-107,0r0,-240r161,0r0,43r-106,0r0,53v73,-3,132,1,132,71xm79,-45v34,0,75,6,75,-29v0,-33,-42,-28,-75,-28r0,57","w":222,"k":{"\u045e":6,"\u044a":4,"\u0443":6,"\u0442":6,"\u0436":4,"\u0428":2,"\u0427":9,"\u0423":3,"\u0422":6,"\u0416":5,"\u0410":1,"\u040e":4,"\u040b":4}},"\u0412":{"d":"223,-66v0,42,-35,66,-87,66r-112,0r0,-240v82,3,192,-21,192,62v0,27,-14,44,-43,53v30,6,50,29,50,59xm158,-172v0,-35,-43,-25,-78,-26r0,53v34,0,78,7,78,-27xm164,-74v0,-35,-47,-28,-84,-28r0,58v37,-1,84,7,84,-30","w":234,"k":{"\u045e":-3,"\u044a":-7,"\u0447":4,"\u0443":-3,"\u0442":-4,"\u0436":-2,"\u0427":6,"\u0423":4,"\u0422":-2,"\u0416":5,"\u0410":1,"\u040e":5,"\u040b":-3}},"\u0413":{"d":"24,0r0,-240r137,0r0,48r-82,0r0,192r-55,0","w":161,"k":{"\u045e":-4,"\u0459":23,"\u0454":22,"\u044f":16,"\u044e":7,"\u044a":-7,"\u0447":6,"\u0446":10,"\u0445":2,"\u0444":24,"\u0443":-2,"\u0442":-4,"\u0441":23,"\u0440":7,"\u043f":8,"\u043e":22,"\u043d":8,"\u043c":8,"\u043b":23,"\u043a":8,"\u0438":8,"\u0437":14,"\u0436":-2,"\u0435":23,"\u0434":26,"\u0432":8,"\u0430":19,"\u0427":-3,"\u0424":8,"\u0423":-15,"\u0422":-13,"\u041b":12,"\u0414":15,"\u040e":-15,"\u040b":-14,"\u0409":9,";":8,":":6,".":26,"-":17,",":26}},"\u0414":{"d":"18,-45r49,-195r87,0r50,195r23,0r0,95r-36,0r-6,-50r-148,0r-6,50r-36,0r0,-95r23,0xm67,-45r77,0r-34,-150r-9,0","w":221},"\u0415":{"d":"195,-194r-114,0r0,49r90,0r0,45r-90,0r0,53r114,0r0,47r-171,0r0,-240r171,0r0,46","w":205,"k":{"\u0424":6}},"\u0416":{"d":"236,-136r88,136r-59,0r-70,-106r-13,4r0,102r-52,0r0,-102r-13,-4r-70,106r-52,0r83,-121r-76,-119r57,0r62,99r9,2r0,-101r52,0r0,101r9,-2r62,-99r52,0","w":310,"k":{"\u045e":9,"\u0454":4,"\u0447":15,"\u0444":5,"\u0443":10,"\u0442":4,"\u0441":4,"\u043e":4,"\u0437":-3,"\u0435":3,"\u0431":4,"\u0430":-5,"\u0424":12,"\u0421":7,"\u041e":7,"\u0404":7}},"\u0417":{"d":"200,-72v0,77,-121,96,-169,54v-16,-14,-26,-32,-27,-55r50,-7v-2,47,87,52,87,6v0,-28,-24,-33,-54,-31r0,-37v28,2,49,-3,49,-29v0,-19,-17,-27,-37,-27v-27,0,-38,9,-42,33r-46,-8v7,-47,36,-71,90,-71v82,0,130,89,51,116v32,9,48,28,48,56","w":211,"k":{"\u045e":-3,"\u0447":3,"\u0445":2,"\u0443":-2,"\u0442":-4,"\u042f":4,"\u0427":6,"\u0425":7,"\u0423":4,"\u0422":-2,"\u041b":-1,"\u0417":-5,"\u0416":6,"\u0414":-7,"\u0410":2,"\u040e":4,"\u040b":-4,"\u0409":-2}},"\u0418":{"d":"79,-24r0,24r-55,0r0,-240r55,0r-1,156v23,-55,54,-86,83,-131r0,-25r55,0r0,240r-55,0r1,-154v-22,50,-55,87,-83,130","w":240},"\u0419":{"d":"79,-24r0,24r-55,0r0,-240r55,0r-1,156v23,-55,54,-86,83,-131r0,-25r55,0r0,240r-55,0r1,-154v-22,50,-55,87,-83,130xm155,-311v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":240},"\u041a":{"d":"79,-240r0,113r76,-113r53,0r-57,86r72,154r-62,0r-48,-104r-34,49r0,55r-55,0r0,-240r55,0","w":226,"k":{"\u045e":13,"\u0454":10,"\u0447":17,"\u0444":10,"\u0443":13,"\u0442":13,"\u0441":9,"\u043e":9,"\u0437":2,"\u0435":9,"\u0431":8,"\u0430":2,"\u0424":15,"\u0421":10,"\u041e":10,"\u0417":4,"\u0404":11}},"\u041b":{"d":"44,0r-49,0r67,-240r75,0r69,240r-61,0r-50,-190","w":202},"\u041c":{"d":"130,0r-59,-196r0,196r-47,0r0,-240r87,0r42,144r45,-144r87,0r0,240r-56,0r0,-196r-60,196r-39,0","w":309},"\u041d":{"d":"210,-240r0,240r-56,0r0,-99r-75,0r0,99r-55,0r0,-240r55,0r0,94r75,0r0,-94r56,0","w":233},"\u041e":{"d":"218,-120v0,67,-36,124,-104,124v-65,0,-101,-59,-101,-125v0,-67,37,-123,103,-123v67,0,101,61,102,124xm116,-198v-30,0,-44,26,-44,78v0,52,14,78,44,78v29,0,43,-26,43,-78v0,-52,-14,-78,-43,-78","w":230,"k":{"\u042f":5,"\u042a":-2,"\u0427":4,"\u0425":9,"\u0423":6,"\u0422":1,"\u041b":2,"\u0416":8,"\u0410":7,"\u040e":7}},"\u041f":{"d":"24,0r0,-240r178,0r0,240r-55,0r0,-196r-68,0r0,196r-55,0","w":226},"\u0420":{"d":"210,-166v0,67,-52,84,-129,77r0,89r-57,0r0,-240r94,0v59,-2,92,22,92,74xm153,-165v0,-35,-38,-32,-74,-31r0,63v36,1,74,3,74,-32","w":217,"k":{"\u0459":14,"\u0454":4,"\u0444":5,"\u0441":4,"\u043e":4,"\u043b":14,"\u0437":-1,"\u0435":4,"\u0434":18,"\u0433":2,"\u0432":2,"\u0430":3,"\u041b":9,"\u0414":13,"\u0410":14,"\u0409":8,".":30,",":31}},"\u0421":{"d":"13,-120v0,-70,39,-125,107,-124v58,0,91,31,98,93r-59,4v-1,-34,-14,-51,-40,-51v-29,0,-44,26,-44,78v0,49,8,78,46,78v23,0,37,-16,42,-46r55,4v-6,54,-43,88,-98,88v-67,0,-107,-51,-107,-124","w":225,"k":{"\u045e":-7,"\u0443":-6,"\u0442":-9,"\u042f":2,"\u0425":7,"\u0423":3,"\u0422":-4,"\u0417":-5,"\u0416":6,"\u0410":2,"\u040e":4,"\u040b":-4,"\u0409":-1}},"\u0422":{"d":"176,-240r0,48r-59,0r0,192r-57,0r0,-192r-60,0r0,-48r176,0","w":176,"k":{"\u045e":-4,"\u0459":15,"\u0454":16,"\u044f":15,"\u044a":-7,"\u0447":6,"\u0446":10,"\u0445":2,"\u0444":18,"\u0443":-2,"\u0442":-4,"\u0441":16,"\u0440":7,"\u043f":8,"\u043e":16,"\u043d":8,"\u043c":8,"\u043b":15,"\u043a":8,"\u0438":8,"\u0437":14,"\u0436":-1,"\u0435":16,"\u0434":16,"\u0433":8,"\u0432":8,"\u0430":16,"\u0424":8,"\u0423":-15,"\u0422":-12,"\u0421":1,"\u041b":9,"\u0417":-5,"\u0414":11,"\u0410":14,"\u040e":-14,"\u040b":-14,"\u0409":8,"\u0404":1,"\u00bb":16,";":8,":":7,".":15,"-":8,",":15}},"\u0423":{"d":"81,-72r-88,-168r60,0r53,106r43,-106r50,0r-73,178v-18,45,-38,67,-102,62r0,-46v30,0,50,1,57,-26","w":191,"k":{"\u045e":-3,"\u0459":17,"\u0454":15,"\u044f":12,"\u044e":8,"\u0447":6,"\u0446":9,"\u0445":2,"\u0444":16,"\u0443":-2,"\u0442":-4,"\u0441":15,"\u0440":8,"\u043f":8,"\u043e":15,"\u043d":8,"\u043c":8,"\u043b":17,"\u043a":8,"\u0438":8,"\u0437":9,"\u0436":-2,"\u0435":15,"\u0434":20,"\u0431":8,"\u0430":14,"\u042f":4,"\u0427":-7,"\u0424":9,"\u0423":-19,"\u0422":-16,"\u0421":6,"\u041e":6,"\u041b":10,"\u0414":13,"\u0410":15,"\u040b":-18,"\u0409":9,"\u0404":6,"\u00bb":12,";":7,":":7,".":24,"-":4,",":24}},"\u0424":{"d":"257,-120v0,61,-39,93,-99,98r0,29r-46,0r0,-29v-59,-5,-99,-37,-99,-98v0,-61,39,-93,99,-98r0,-29r46,0r0,29v62,5,99,37,99,98xm112,-178v-31,8,-47,27,-47,58v0,31,16,50,47,58r0,-116xm158,-62v31,-8,47,-27,47,-58v0,-31,-16,-50,-47,-58r0,116","w":270,"k":{"\u0459":4,"\u043b":4,"\u0434":8,"\u042f":6,"\u042a":4,"\u0427":4,"\u0425":14,"\u0423":10,"\u041b":5,"\u0416":13,"\u0414":7,"\u0410":9,"\u040e":11,"\u0409":4}},"\u0425":{"d":"207,-240r-66,112r74,128r-65,0r-48,-87r-48,87r-53,0r74,-128r-66,-112r65,0r39,73r41,-73r53,0","w":215,"k":{"\u0454":10,"\u0447":20,"\u0444":11,"\u0443":12,"\u0442":10,"\u0441":9,"\u043e":10,"\u0437":2,"\u0435":9,"\u0430":1,"\u0424":14,"\u0421":9,"\u041e":9,"\u0417":5,"\u0404":10}},"\u0426":{"d":"26,0r0,-240r55,0r0,193r70,0r0,-193r55,0r0,193r29,0r0,97r-37,0r-5,-50r-167,0","w":233},"\u0427":{"d":"74,-240v7,44,-21,123,30,122v15,0,30,-4,43,-13r0,-109r55,0r0,240r-55,0r0,-93v-46,42,-128,20,-128,-58r0,-89r55,0","w":226},"\u0428":{"d":"26,0r0,-240r55,0r0,193r64,0r0,-193r56,0r0,193r64,0r0,-193r55,0r0,240r-294,0","w":345},"\u0429":{"d":"26,0r0,-240r55,0r0,193r64,0r0,-193r56,0r0,193r64,0r0,-193r55,0r0,193r30,0r0,97r-36,0r-6,-50r-282,0","w":348},"\u042a":{"d":"235,-77v-1,47,-32,77,-85,77r-102,0r0,-192r-57,0r0,-48r112,0r0,88v76,-4,133,5,132,75xm103,-45v35,0,75,5,75,-32v0,-37,-40,-31,-75,-31r0,63","w":241,"k":{"\u042a":12,"\u0427":5,"\u0423":5,"\u0422":17,"\u040e":6,"\u040b":8}},"\u042b":{"d":"213,-77v-1,47,-32,77,-85,77r-102,0r0,-240r55,0r0,88v76,-5,133,7,132,75xm81,-45v35,0,75,5,75,-32v0,-37,-40,-31,-75,-31r0,63xm238,0r0,-240r55,0r0,240r-55,0","w":318},"\u042c":{"d":"211,-77v0,48,-32,77,-85,77r-102,0r0,-240r55,0r0,88v75,-5,132,5,132,75xm79,-45v36,0,76,6,76,-32v0,-37,-41,-31,-76,-31r0,63","w":217,"k":{"\u044a":-1,"\u042a":11,"\u0427":5,"\u0423":5,"\u0422":17,"\u040e":6,"\u040b":8}},"\u042d":{"d":"216,-120v1,-73,-38,-124,-107,-124v-48,0,-80,23,-98,66r50,14v9,-37,65,-45,86,-17v8,11,12,24,12,38r-83,0r0,39r84,0v7,66,-90,86,-104,23r-51,10v13,40,48,76,103,75v71,-1,108,-52,108,-124","w":228,"k":{"\u042f":5,"\u042a":-2,"\u0427":4,"\u0423":6,"\u0422":1,"\u041b":3,"\u0410":8,"\u040e":7,"\u0409":1}},"\u042e":{"d":"225,4v-62,0,-104,-49,-107,-106r-39,0r0,102r-55,0r0,-240r55,0r0,94r39,0v9,-54,48,-98,106,-98v66,0,108,53,108,124v0,65,-41,124,-107,124xm223,-42v66,-1,69,-155,1,-156v-68,0,-67,156,-1,156","w":344,"k":{"\u0459":1,"\u043b":1,"\u042f":5,"\u042a":-2,"\u0427":4,"\u0425":10,"\u0423":7,"\u0422":2,"\u041b":3,"\u0416":9,"\u0410":8,"\u040e":7,"\u040b":1,"\u0409":2}},"\u042f":{"d":"61,-106v-71,-30,-46,-134,46,-134r106,0r0,240r-57,0r0,-95r-47,0r-40,95r-59,0xm78,-167v1,35,39,32,78,31r0,-61v-37,1,-79,-7,-78,30","w":236},"\u0430":{"d":"99,-181v46,0,74,12,74,67v0,36,-3,85,4,114r-51,0v-2,-7,-3,-17,-3,-28v-20,47,-117,41,-112,-18v4,-55,42,-59,110,-65v2,-22,-5,-36,-26,-36v-18,0,-28,9,-30,26r-49,-5v4,-39,41,-55,83,-55xm88,-29v25,-1,36,-26,33,-56v-37,4,-55,14,-55,33v0,12,9,24,22,23","w":194,"k":{"\u045e":5,"\u0459":-4,"\u0447":7,"\u0443":4,"\u0442":-1}},"\u0431":{"d":"100,4v-116,0,-106,-190,-37,-230v13,-12,54,-6,56,-30r52,0v-1,63,-104,23,-108,90v55,-37,126,5,126,75v0,56,-34,95,-89,95xm133,-88v0,-36,-5,-57,-33,-57v-28,0,-34,21,-34,57v0,36,6,57,34,57v27,0,33,-21,33,-57","w":200,"k":{"\u045e":5,"\u044f":1,"\u0447":3,"\u0445":6,"\u0443":5,"\u0442":-2,"\u0436":4}},"\u0432":{"d":"186,-48v0,68,-98,44,-164,48r0,-178v63,5,158,-21,159,45v0,21,-13,34,-39,40v29,6,44,21,44,45xm74,-105v24,-2,57,8,57,-19v0,-27,-33,-19,-57,-20r0,39xm134,-57v0,-29,-33,-22,-60,-23r0,45v26,-1,60,8,60,-22","w":197,"k":{"\u045e":2,"\u0447":5,"\u0445":3,"\u0443":2,"\u0442":-4,"\u0437":-3}},"\u0433":{"d":"22,0r0,-178r117,0r0,39r-65,0r0,139r-52,0","w":139,"k":{"\u045e":-10,"\u0459":10,"\u044f":-3,"\u0444":1,"\u043b":10,"\u0434":14,";":-1,":":-1,".":19,"-":12,",":19}},"\u0434":{"d":"19,-37r41,-141r73,0r33,141r22,0r0,78r-32,0r-6,-41r-115,0r-5,41r-33,0r0,-78r22,0xm58,-37r55,0r-20,-105r-7,0","w":185},"\u0435":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37","w":192,"k":{"\u045e":5,"\u0447":3,"\u0445":5,"\u0443":5,"\u043b":1,"\u0437":-2,"\u0436":4}},"\u0436":{"d":"203,-107r64,107r-54,0r-45,-77r-12,4r0,73r-53,0r0,-73r-12,-4r-46,77r-49,0r61,-93r-57,-85r52,0r45,66r6,2r0,-68r53,0r0,68r6,-2r45,-66r52,0","w":258,"k":{"\u045e":-12,"\u0454":2,"\u0444":4,"\u0441":2,"\u043e":2,"\u0435":2}},"\u0437":{"d":"109,-53v-1,-23,-16,-22,-43,-23r0,-30v28,0,37,-2,40,-21v-3,-27,-49,-24,-51,3r-47,-8v4,-63,151,-69,151,0v0,17,-11,29,-33,37v26,6,39,20,39,42v0,62,-101,71,-138,40v-12,-11,-19,-23,-22,-36r47,-8v1,34,58,37,57,4","w":175,"k":{"\u045e":3,"\u0447":6,"\u0445":4,"\u0443":3,"\u0442":-4,"\u0436":2}},"\u0438":{"d":"74,-18r0,18r-52,0r0,-178r52,0r-1,108v19,-35,37,-55,58,-85r0,-23r52,0r0,178r-52,0r1,-108v-15,36,-38,60,-58,90","w":204},"\u0439":{"d":"74,-18r0,18r-52,0r0,-178r52,0r-1,108v19,-35,37,-55,58,-85r0,-23r52,0r0,178r-52,0r1,-108v-15,36,-38,60,-58,90xm158,-257v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":204,"k":{"\u0459":-2}},"\u043a":{"d":"136,-117r61,117r-55,0r-41,-79r-27,28r0,51r-52,0r0,-178r52,0r-1,76v20,-27,47,-51,69,-76r48,0","w":190,"k":{"\u045e":-11,"\u0454":2,"\u0444":4,"\u0441":2,"\u043e":2,"\u0435":2,"\u0430":-1}},"\u043b":{"d":"-4,0r59,-178r58,0r54,178r-54,0r-35,-130r-43,130r-39,0","w":164},"\u043c":{"d":"22,0r0,-178r75,0r39,142r40,-142r71,0r0,178r-48,0v-2,-46,4,-100,-2,-142r-40,142r-52,0r-40,-142r-3,0r0,142r-40,0","w":268},"\u043d":{"d":"22,0r0,-178r52,0r0,64r54,0r0,-64r53,0r0,178r-53,0r0,-75r-54,0r0,75r-52,0","w":202},"\u043e":{"d":"11,-89v2,-55,29,-90,84,-92v54,-2,86,40,86,93v0,51,-35,92,-86,92v-51,0,-85,-41,-84,-93xm96,-31v40,5,34,-80,23,-103v-4,-9,-12,-13,-22,-13v-27,0,-30,20,-30,57v0,34,3,56,29,59","w":192,"k":{"\u045e":5,"\u0459":1,"\u044a":-5,"\u0445":5,"\u0443":5,"\u0442":-2,"\u043b":1,"\u0436":4}},"\u043f":{"d":"22,0r0,-178r152,0r0,178r-52,0r0,-142r-48,0r0,142r-52,0","w":195},"\u0440":{"d":"182,-91v0,77,-69,127,-110,71r0,80r-50,0r0,-238r48,0r0,26v9,-20,25,-29,47,-29v44,1,65,39,65,90xm128,-92v0,-67,-56,-68,-56,-12v0,35,-3,70,28,71v24,-4,28,-21,28,-59","w":194,"k":{"\u045e":3,"\u0447":3,"\u0445":3,"\u0443":3,"\u0442":-4,"\u0436":1,";":-1,":":-1,".":-2,"-":-14}},"\u0441":{"d":"70,-91v0,59,52,70,59,21r49,3v-3,42,-37,71,-82,71v-51,1,-85,-39,-85,-92v0,-102,156,-131,167,-25r-49,3v-2,-21,-11,-32,-28,-32v-21,0,-31,17,-31,51","w":184,"k":{"\u0445":3,"\u0442":-7,"\u043e":-1,"\u0437":-4,"\u0430":-1,"\u040e":6}},"\u0442":{"d":"46,0r0,-139r-50,0r0,-39r149,0r0,39r-47,0r0,139r-52,0","w":141,"k":{"\u045e":-13,"\u0459":6,"\u0454":-2,"\u044f":-5,"\u0447":-5,"\u0443":-13,"\u0442":-15,"\u0441":-2,"\u043e":-2,"\u043b":6,"\u0437":-8,"\u0435":-2,"\u0434":9,"\u0430":-3,"\u00bb":-6,";":-4,":":-4,".":8,",":8}},"\u0443":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0","w":160,"k":{"\u0459":4,"\u0454":4,"\u044f":2,"\u0447":-2,"\u0444":6,"\u0442":-12,"\u0441":4,"\u043e":4,"\u043b":4,"\u0435":4,"\u0434":7,"\u0430":4,"\u00bb":2,";":-1,":":-2,".":9,"-":-7,",":10}},"\u0444":{"d":"243,-88v-1,54,-37,87,-92,90r0,58r-47,0r0,-58v-54,-3,-91,-36,-91,-90v-1,-55,40,-88,91,-91r0,-60r47,0r0,60v52,3,92,36,92,91xm106,-150v-27,7,-41,28,-41,61v0,33,14,53,41,60r0,-121xm149,-29v55,-7,54,-114,0,-121r0,121","k":{"\u045e":7,"\u0459":3,"\u044f":3,"\u044a":-3,"\u0447":3,"\u0445":7,"\u0443":7,"\u043b":3,"\u0436":5,"\u0434":1}},"\u0445":{"d":"169,-178r-51,83r60,95r-60,0r-37,-61r-36,61r-45,0r59,-95r-51,-83r60,0r28,48r28,-48r45,0","w":177,"k":{"\u045e":-7,"\u0454":6,"\u0444":8,"\u0441":6,"\u043e":5,"\u0437":4,"\u0435":6,"\u0430":2}},"\u0446":{"d":"22,0r0,-178r52,0r0,140r51,0r0,-140r52,0r0,140r27,0r0,79r-33,0r-5,-41r-144,0","w":201},"\u0447":{"d":"69,-178v5,32,-16,93,21,91v10,0,19,-2,27,-8r0,-83r52,0r0,178r-52,0r0,-66v-37,27,-100,16,-100,-39r0,-73r52,0","w":190},"\u0448":{"d":"23,0r0,-178r52,0r0,140r47,0r0,-140r53,0r0,140r47,0r0,-140r52,0r0,178r-251,0","w":296},"\u0449":{"d":"23,0r0,-178r52,0r0,140r47,0r0,-140r53,0r0,140r47,0r0,-140r52,0r0,140r28,0r0,79r-33,0r-5,-41r-241,0","w":299},"\u044a":{"d":"194,-57v0,74,-87,55,-156,57r0,-139r-47,0r0,-39r100,0r0,63v57,-4,103,6,103,58xm91,-35v26,-1,55,7,55,-23v0,-27,-29,-23,-55,-23r0,46","w":201,"k":{"\u045e":10,"\u044a":10,"\u0447":3,"\u0443":10,"\u0442":13,"\u0441":-1,"\u0435":-1}},"\u044b":{"d":"179,-57v0,74,-87,55,-156,57r0,-178r52,0r0,63v57,-4,104,5,104,58xm75,-35v26,-1,56,7,56,-23v0,-28,-30,-23,-56,-23r0,46xm200,0r0,-178r53,0r0,178r-53,0","w":275},"\u044c":{"d":"178,-57v0,74,-87,55,-156,57r0,-178r52,0r0,63v58,-5,104,6,104,58xm74,-35v26,-1,59,7,55,-23v2,-27,-29,-23,-55,-23r0,46","w":184,"k":{"\u045e":10,"\u044a":10,"\u0447":3,"\u0443":10,"\u0442":13,"\u0441":-1,"\u0435":-1}},"\u044d":{"d":"53,-56v8,39,72,29,67,-13r0,-5r-68,0r0,-33r68,0v7,-41,-56,-54,-64,-16r-49,-8v13,-33,39,-50,79,-50v56,-1,90,38,90,93v0,99,-145,127,-172,40","w":187,"k":{"\u045e":5,"\u0459":1,"\u044f":1,"\u044a":-5,"\u0447":2,"\u0443":5,"\u0442":-2,"\u043b":1}},"\u044e":{"d":"192,4v-50,0,-84,-33,-89,-78r-29,0r0,74r-52,0r0,-178r52,0r0,68r29,0v7,-41,42,-71,89,-71v55,0,90,38,90,92v0,54,-38,93,-90,93xm227,-88v0,-35,-6,-58,-35,-58v-30,0,-36,23,-36,58v0,35,7,57,36,57v28,0,36,-22,35,-57","w":293,"k":{"\u045e":6,"\u0459":2,"\u044a":-4,"\u0447":3,"\u0445":6,"\u0443":5,"\u0442":-2,"\u043b":2,"\u0436":4}},"\u044f":{"d":"45,-79v-55,-18,-31,-99,28,-99r98,0r0,178r-52,0r0,-68r-35,0r-30,68r-49,0xm120,-102r0,-42v-25,1,-56,-7,-56,22v0,27,32,19,56,20","w":192},"\u0451":{"d":"11,-87v-5,-79,92,-124,146,-70v16,16,24,42,24,77r-114,0v-10,49,57,66,65,19r48,3v-13,41,-40,62,-81,62v-56,0,-85,-36,-88,-91xm67,-110r63,0v-2,-24,-12,-37,-30,-37v-20,0,-31,13,-33,37xm150,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm92,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":192},"\u0452":{"d":"105,-133v-49,3,-28,83,-32,133r-51,0r0,-195r-29,0r0,-30r29,0r0,-19r51,0r0,19r70,0r0,30r-70,0r0,49v12,-19,29,-28,51,-28v63,0,56,44,57,121v1,77,-4,115,-75,114r-3,-36v33,-6,28,-26,28,-76v0,-53,7,-75,-26,-82","w":197},"\u0453":{"d":"22,0r0,-178r117,0r0,39r-65,0r0,139r-52,0xm114,-266r13,29r-77,33r-9,-20","w":139,"k":{"\u0459":10,"\u044f":-3,"\u0444":1,"\u043b":10,"\u0434":14}},"\u0454":{"d":"135,-56v-8,39,-72,29,-67,-13r0,-5r68,0r0,-33r-68,0v-7,-41,56,-54,64,-16r49,-8v-13,-33,-39,-50,-79,-50v-56,-1,-90,38,-90,93v0,99,145,127,172,40","w":187},"\u0455":{"d":"26,-84v-40,-37,-4,-103,58,-97v40,4,59,15,71,46r-39,11v1,-27,-61,-35,-61,-9v0,25,62,15,75,26v63,29,25,111,-47,111v-45,0,-72,-18,-81,-53r44,-6v0,28,70,34,70,6v0,-8,-6,-12,-19,-14v-36,-4,-60,-12,-71,-21","w":170},"\u0456":{"d":"74,-178r0,178r-52,0r0,-178r52,0xm74,-245r0,53r-52,0r0,-53r52,0","w":95},"\u0457":{"d":"75,-178r0,178r-52,0r0,-178r52,0xm102,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm44,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":95},"\u0458":{"d":"-11,20v24,4,32,-3,32,-30r0,-168r54,0r0,194v-2,40,-40,56,-86,45r0,-41xm75,-245r0,53r-54,0r0,-53r54,0","w":96},"\u0459":{"d":"244,-57v0,69,-76,56,-141,57r-26,-130r-42,130r-39,0r59,-178r58,0r16,63v60,-4,115,1,115,58xm148,-35v24,1,47,3,47,-23v0,-30,-32,-22,-58,-23","w":250,"k":{"\u045e":10,"\u044a":10,"\u0447":2,"\u0443":10,"\u0442":13}},"\u045a":{"d":"283,-56v0,73,-89,54,-157,56r0,-75r-52,0r0,75r-52,0r0,-178r52,0r0,64r52,0r0,-64r52,0r0,65v60,-4,105,2,105,57xm178,-35v26,0,56,6,56,-23v0,-29,-31,-21,-56,-22r0,45","w":290,"k":{"\u045e":11,"\u044a":10,"\u0447":4,"\u0443":11,"\u0442":14}},"\u045b":{"d":"108,-133v-50,0,-29,83,-33,133r-53,0r0,-195r-29,0r0,-30r29,0r0,-19r53,0r0,19r67,0r0,30r-67,0r0,49v29,-49,108,-34,108,40r0,106r-53,0r0,-99v0,-21,-4,-34,-22,-34","w":200},"\u045c":{"d":"136,-117r61,117r-55,0r-41,-79r-27,28r0,51r-52,0r0,-178r52,0r-1,76v20,-27,47,-51,69,-76r48,0xm145,-249r-24,28r-46,5r26,-29","w":190,"k":{"\u045e":-11,"\u0454":2,"\u0444":4,"\u0441":2,"\u043e":2,"\u0435":2,"\u0430":-2}},"\u045e":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0xm145,-257v0,45,-60,64,-95,38v-10,-8,-16,-21,-17,-38r28,0v0,31,56,30,56,0r28,0","w":160,"k":{"\u0454":4,"\u044f":2,"\u0447":-2,"\u0444":6,"\u0442":-12,"\u0441":4,"\u043e":4,"\u043b":4,"\u0435":4,"\u0434":7,"\u0430":4}},"\u045f":{"d":"22,0r0,-178r52,0r0,141r51,0r0,-141r53,0r0,178r-58,0r-4,41r-33,0r-4,-41r-57,0","w":199},"\u0490":{"d":"168,-285r0,93r-89,0r0,192r-55,0r0,-240r102,0r0,-45r42,0","w":168},"\u0491":{"d":"101,-178r0,-40r38,0r0,79r-65,0r0,139r-52,0r0,-178r79,0","w":139},"\u1e80":{"d":"312,-240r-60,240r-55,0r-40,-159r-38,159r-55,0r-62,-240r58,0r37,162r39,-162r52,0r40,162r38,-162r46,0xm133,-322r73,42r-9,20r-77,-33","w":314},"\u1e81":{"d":"256,-178r-53,178r-46,0r-28,-114r-28,114r-44,0r-55,-178r55,0r28,109r27,-109r48,0r26,110r30,-110r40,0xm105,-266r73,42r-9,20r-77,-33","w":259},"\u1e82":{"d":"312,-240r-60,240r-55,0r-40,-159r-38,159r-55,0r-62,-240r58,0r37,162r39,-162r52,0r40,162r38,-162r46,0xm191,-324r13,29r-77,33r-9,-20","w":314},"\u1e83":{"d":"256,-178r-53,178r-46,0r-28,-114r-28,114r-44,0r-55,-178r55,0r28,109r27,-109r48,0r26,110r30,-110r40,0xm165,-266r13,29r-77,33r-9,-20","w":259},"\u1e84":{"d":"312,-240r-60,240r-55,0r-40,-159r-38,159r-55,0r-62,-240r58,0r37,162r39,-162r52,0r40,162r38,-162r46,0xm212,-287v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm154,-287v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":314},"\u1e85":{"d":"256,-178r-53,178r-46,0r-28,-114r-28,114r-44,0r-55,-178r55,0r28,109r27,-109r48,0r26,110r30,-110r40,0xm186,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm128,-230v0,11,-10,21,-22,21v-11,0,-20,-10,-20,-21v0,-11,9,-20,20,-20v12,0,22,9,22,20","w":259},"\u1ef2":{"d":"197,-240r-75,139r0,101r-56,0r0,-101r-76,-139r66,0r45,91r46,-91r50,0xm69,-322r73,42r-9,20r-77,-33","w":187},"\u1ef3":{"d":"159,-178r-55,171v-13,51,-32,76,-95,67r0,-40v25,5,52,4,54,-20r-64,-178r55,0r34,106r33,-106r38,0xm59,-266r73,42r-9,20r-77,-33","w":160},"\u2015":{"d":"-7,-110r254,0r0,38r-254,0r0,-38","w":239},"\u2017":{"d":"0,17r180,0r0,28r-180,0r0,-28xm0,60r180,0r0,28r-180,0r0,-28","w":180},"\u201b":{"d":"72,-142r-20,0r-31,-54r0,-44r51,0r0,50r-25,0","w":92},"\u2032":{"d":"37,-140r-30,0r27,-100r43,0","w":69},"\u2033":{"d":"37,-140r-30,0r27,-100r43,0xm105,-140r-29,0r27,-100r42,0","w":133},"\u203c":{"d":"69,-240v3,62,-6,113,-13,166r-25,0v-7,-53,-17,-103,-14,-166r52,0xm163,-240v3,63,-7,113,-14,166r-25,0v-7,-53,-17,-103,-14,-166r53,0xm70,-53r0,53r-54,0r0,-53r54,0xm164,-53r0,53r-54,0r0,-53r54,0","w":180},"\u203e":{"d":"-7,-329r216,0r0,13r-216,0r0,-13","w":201},"\u2044":{"d":"-61,0r133,-240r28,0r-133,240r-28,0","w":38},"\u207f":{"d":"50,-191v18,-24,65,-17,65,26r0,69r-37,0r0,-60v0,-15,0,-22,-11,-23v-27,2,-13,55,-16,83r-36,0r0,-107r34,0","w":129},"\u20a4":{"d":"145,-180v-5,-32,-49,-29,-46,5v0,4,0,9,1,17r42,0r0,27r-38,0v1,8,2,15,2,21r36,0r0,27r-38,0v-3,14,-12,27,-25,38v39,1,69,2,77,-33r48,14v-14,82,-113,62,-202,64r0,-45v31,3,54,-8,53,-38r-35,0r0,-27r33,0v-1,-4,-2,-11,-4,-21r-29,0r0,-27r25,0v-18,-94,121,-115,145,-40","w":211},"\u20a7":{"d":"196,-166v0,61,-42,84,-115,77r0,89r-55,0r0,-240r81,0v58,-2,89,23,89,74xm142,-165v0,-30,-29,-33,-63,-31r0,63v34,3,63,-2,63,-32xm271,0v-35,5,-61,4,-61,-33r0,-48r-18,0r0,-26r20,0r2,-31r32,-2r0,33r24,0r0,26r-24,0v4,25,-15,65,25,56r0,25xm295,-50v-27,-24,-1,-59,37,-59v23,0,39,9,46,28v-8,1,-20,7,-27,6v-1,-14,-33,-19,-35,-4v16,18,66,2,66,43v0,51,-99,50,-103,5r31,-4v-2,16,39,19,40,5v0,-4,-3,-6,-10,-7v-23,-2,-38,-7,-45,-13","w":389},"\u2105":{"d":"57,-184v0,39,35,45,40,14r36,2v-3,29,-26,47,-58,47v-36,0,-60,-25,-60,-61v0,-70,110,-87,118,-16r-36,2v-1,-14,-8,-21,-19,-21v-14,0,-21,11,-21,33xm85,0r133,-240r28,0r-133,240r-28,0xm194,-58v0,-35,24,-61,60,-61v37,0,62,26,61,62v0,34,-25,61,-61,61v-36,0,-60,-27,-60,-62xm275,-57v-1,-22,-2,-38,-20,-38v-19,0,-21,13,-21,37v0,22,3,37,21,38v13,0,20,-13,20,-37","w":329},"\u2113":{"d":"149,-243v18,1,29,15,29,34v0,34,-21,72,-63,114v-7,34,-10,55,-10,64v0,8,1,11,5,11v7,3,13,-24,23,-24v4,0,6,2,6,7v0,19,-19,44,-40,43v-28,-1,-30,-34,-29,-69v-10,12,-16,13,-19,0v2,-11,20,-25,22,-30v7,-41,17,-77,29,-106v12,-29,28,-44,47,-44xm120,-128v17,-18,35,-49,36,-78v0,-9,-2,-13,-6,-13v-9,0,-19,30,-30,91","w":211},"\u2116":{"d":"209,-240r0,240r-48,0r-94,-162r1,162r-44,0r0,-240r61,0r81,142r-1,-142r44,0xm232,-124v-1,-33,22,-58,56,-58v36,0,58,25,58,58v0,34,-24,59,-58,59v-34,0,-56,-25,-56,-59xm306,-123v0,-18,-1,-34,-17,-34v-16,0,-17,14,-17,33v0,22,6,33,17,33v11,0,17,-10,17,-32xm235,-38r109,0r0,38r-109,0r0,-38","w":360},"\u212e":{"d":"14,-93v0,-86,99,-132,157,-75v18,17,28,42,29,75r-146,0r0,65v37,35,99,25,122,-22r13,7v-23,32,-40,48,-82,49v-55,2,-93,-44,-93,-99xm159,-106r0,-53v-28,-28,-79,-28,-105,1r0,52r105,0","w":216},"\u215b":{"d":"3,-181r0,-32v27,-7,44,-17,52,-29r28,0r0,118r38,0r0,28r-118,0r0,-28r42,0r0,-78v-17,9,-30,17,-42,21xm74,0r133,-240r28,0r-133,240r-28,0xm250,-146v48,-7,78,47,35,68v53,27,18,85,-38,80v-53,8,-85,-56,-34,-74v-43,-22,-12,-81,37,-74xm258,-89v21,-6,18,-34,-9,-34v-19,0,-26,14,-15,24v3,3,11,6,24,10xm240,-59v-12,3,-18,9,-18,18v0,12,9,18,27,18v24,1,31,-12,20,-25v-3,-3,-12,-6,-29,-11","w":316},"\u215c":{"d":"89,-140v1,-20,-22,-17,-43,-17r0,-27v18,1,41,0,39,-16v-3,-23,-40,-19,-42,3r-34,-5v5,-49,111,-57,114,-1v0,15,-7,25,-23,31v19,5,28,17,28,34v3,45,-73,56,-104,31v-11,-9,-17,-19,-19,-32r35,-5v0,27,49,31,49,4xm78,0r133,-240r28,0r-133,240r-28,0xm250,-146v48,-7,78,47,35,68v53,27,18,85,-38,80v-53,8,-85,-56,-34,-74v-43,-22,-12,-81,37,-74xm258,-89v21,-6,18,-34,-9,-34v-19,0,-26,14,-15,24v3,3,11,6,24,10xm240,-59v-12,3,-18,9,-18,18v0,12,9,18,27,18v24,1,31,-12,20,-25v-3,-3,-12,-6,-29,-11","w":316},"\u215d":{"d":"91,-143v0,-22,-34,-29,-45,-10r-31,-5r6,-82r99,0r-4,31r-67,0r-2,28v29,-26,82,-4,82,36v0,32,-26,51,-61,51v-33,0,-54,-14,-62,-42r36,-5v3,27,49,24,49,-2xm77,0r133,-240r28,0r-133,240r-28,0xm246,-146v48,-7,78,47,35,68v53,27,18,85,-38,80v-53,8,-85,-56,-34,-74v-43,-22,-12,-81,37,-74xm254,-89v21,-6,18,-34,-9,-34v-19,0,-26,14,-15,24v3,3,11,6,24,10xm236,-59v-12,3,-18,9,-18,18v0,12,9,18,27,18v24,1,31,-12,20,-25v-3,-3,-12,-6,-29,-11","w":316},"\u215e":{"d":"36,-96v-1,-51,25,-86,50,-112r-76,0r3,-32r109,0r0,27v-24,27,-45,67,-43,117r-43,0xm61,0r133,-240r28,0r-133,240r-28,0xm245,-146v48,-7,78,47,35,68v53,27,18,85,-38,80v-53,8,-85,-56,-34,-74v-43,-22,-12,-81,37,-74xm253,-89v21,-6,18,-34,-9,-34v-19,0,-26,14,-15,24v3,3,11,6,24,10xm235,-59v-12,3,-18,9,-18,18v0,12,9,18,27,18v24,1,31,-12,20,-25v-3,-3,-12,-6,-29,-11","w":316},"\u2190":{"d":"86,-154r14,0v-9,20,-21,38,-34,54r280,0r0,18r-280,0v12,12,23,30,34,54r-13,0v-26,-30,-51,-50,-73,-60r0,-7v21,-8,44,-28,72,-59","w":360},"\u2191":{"d":"27,-163v31,-28,50,-51,58,-72r9,0v10,22,29,46,59,72r0,14v-24,-11,-42,-23,-54,-35r0,259r-18,0r0,-259v-16,13,-34,26,-54,35r0,-14","w":180},"\u2192":{"d":"273,-154v28,31,52,51,73,59r0,7v-22,10,-47,30,-73,60r-13,0v11,-24,22,-42,34,-54r-280,0r0,-18r280,0v-13,-16,-25,-34,-34,-54r13,0","w":360},"\u2193":{"d":"27,3r0,-14v20,9,38,22,54,35r0,-259r18,0r0,259v12,-12,30,-24,54,-35r0,14v-30,26,-49,50,-59,72r-9,0v-8,-21,-27,-44,-58,-72","w":180},"\u2194":{"d":"346,-95r0,8v-21,9,-45,29,-71,59r-14,0v8,-20,19,-38,34,-54r-230,0v15,16,26,34,34,54r-14,0v-26,-30,-50,-50,-71,-59r0,-8v21,-9,45,-29,71,-59r14,0v-8,20,-19,38,-34,54r230,0v-15,-16,-26,-34,-34,-54r14,0v26,30,50,50,71,59","w":360},"\u2195":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71","w":180},"\u21a8":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71xm27,92r126,0r0,17r-126,0r0,-17","w":180},"\u221f":{"d":"64,-225r17,0r0,207r208,0r0,18r-225,0r0,-225","w":352},"\u2229":{"d":"129,-209v-94,-4,-75,111,-76,209r-19,0r0,-83v-7,-95,20,-137,95,-145v76,8,103,49,96,145r0,83r-19,0r0,-84v5,-79,-13,-122,-77,-125","w":258},"\u2261":{"d":"36,-202r188,0r0,16r-188,0r0,-16xm36,-120r188,0r0,15r-188,0r0,-15xm36,-39r188,0r0,16r-188,0r0,-16","w":239},"\u2302":{"d":"27,0r0,-111r81,-92r81,92r0,111r-162,0xm41,-14r134,0r0,-91r-67,-76r-67,76r0,91","w":216},"\u2310":{"d":"77,0r-49,0r0,-97r156,0r0,44r-107,0r0,53","w":211},"\u2320":{"d":"156,-270v-15,2,-23,-30,-33,-10r-2,371r-25,0r0,-319v-1,-42,18,-73,51,-77v26,-3,34,32,9,35","w":217},"\u2321":{"d":"61,55v16,-2,23,30,34,10r1,-370r25,0r0,318v2,43,-18,74,-51,78v-25,3,-33,-33,-9,-36","w":217},"\u2500":{"d":"259,-94r-263,0r0,-31r263,0r0,31"},"\u2502":{"d":"112,109r0,-437r31,0r0,437r-31,0"},"\u250c":{"d":"259,-125r0,31r-116,0r0,203r-31,0r0,-234r147,0"},"\u2510":{"d":"112,-94r-116,0r0,-31r147,0r0,234r-31,0r0,-203"},"\u2514":{"d":"112,-94r0,-234r31,0r0,203r116,0r0,31r-147,0"},"\u2518":{"d":"143,-94r-147,0r0,-31r116,0r0,-203r31,0r0,234"},"\u251c":{"d":"112,109r0,-437r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0"},"\u2524":{"d":"112,109r0,-203r-116,0r0,-31r116,0r0,-203r31,0r0,437r-31,0"},"\u252c":{"d":"112,-94r-116,0r0,-31r263,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2534":{"d":"259,-94r-263,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31"},"\u253c":{"d":"112,-94r-116,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2550":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u2551":{"d":"146,109r0,-437r30,0r0,437r-30,0xm79,109r0,-437r31,0r0,437r-31,0"},"\u2552":{"d":"112,109r0,-267r147,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u2553":{"d":"79,109r0,-234r180,0r0,31r-83,0r0,203r-30,0r0,-203r-36,0r0,203r-31,0"},"\u2554":{"d":"110,109r-31,0r0,-267r180,0r0,31r-149,0r0,236xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0"},"\u2555":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r147,0r0,267r-31,0r0,-169"},"\u2556":{"d":"79,109r0,-203r-83,0r0,-31r180,0r0,234r-30,0r0,-203r-37,0r0,203r-30,0"},"\u2557":{"d":"146,109r0,-236r-150,0r0,-31r180,0r0,267r-30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169"},"\u2558":{"d":"112,-60r0,-268r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-147,0"},"\u2559":{"d":"259,-94r-180,0r0,-234r31,0r0,203r36,0r0,-203r30,0r0,203r83,0r0,31"},"\u255a":{"d":"110,-328r0,237r149,0r0,31r-180,0r0,-268r31,0xm176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170"},"\u255b":{"d":"143,-60r-147,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,268"},"\u255c":{"d":"176,-94r-180,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,234"},"\u255d":{"d":"146,-328r30,0r0,268r-180,0r0,-31r150,0r0,-237xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0"},"\u255e":{"d":"112,109r0,-437r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u255f":{"d":"146,109r0,-437r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0xm79,109r0,-437r31,0r0,437r-31,0"},"\u2560":{"d":"79,109r0,-437r31,0r0,437r-31,0xm146,-127r0,-201r30,0r0,170r83,0r0,31r-113,0xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0"},"\u2561":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,437r-31,0r0,-169"},"\u2562":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,437r-30,0xm146,109r0,-437r30,0r0,437r-30,0"},"\u2563":{"d":"146,109r0,-437r30,0r0,437r-30,0xm109,-328r0,201r-113,0r0,-31r83,0r0,-170r30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169"},"\u2564":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm112,-60r-116,0r0,-31r263,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u2565":{"d":"79,109r0,-203r-83,0r0,-31r263,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0"},"\u2566":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0"},"\u2567":{"d":"259,-127r-263,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u2568":{"d":"259,-94r-263,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31"},"\u2569":{"d":"109,-127r-113,0r0,-31r83,0r0,-170r30,0r0,201xm259,-127r-113,0r0,-201r30,0r0,170r83,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u256a":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u256b":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0"},"\u256c":{"d":"176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0"},"\u2580":{"d":"259,-109r-263,0r0,-219r263,0r0,219"},"\u2584":{"d":"259,109r-263,0r0,-218r263,0r0,218"},"\u2588":{"d":"-4,109r0,-437r263,0r0,437r-263,0"},"\u258c":{"d":"-4,109r0,-437r131,0r0,437r-131,0"},"\u2590":{"d":"128,109r0,-437r131,0r0,437r-131,0"},"\u2591":{"d":"0,-328r21,0r0,22r-21,0r0,-22xm85,-328r21,0r0,22r-21,0r0,-22xm170,-328r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm170,-240r21,0r0,22r-21,0r0,-22xm85,-240r21,0r0,22r-21,0r0,-22xm0,-240r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm0,-152r21,0r0,22r-21,0r0,-22xm85,-152r21,0r0,22r-21,0r0,-22xm170,-152r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm0,-65r21,0r0,22r-21,0r0,-22xm85,-65r21,0r0,22r-21,0r0,-22xm170,-65r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm170,23r21,0r0,22r-21,0r0,-22xm85,23r21,0r0,22r-21,0r0,-22xm0,23r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22"},"\u2592":{"d":"21,-328r21,0r0,22r-21,0r0,-22xm64,-328r21,0r0,22r-21,0r0,-22xm106,-328r21,0r0,22r-21,0r0,-22xm148,-328r22,0r0,22r-22,0r0,-22xm191,-328r21,0r0,22r-21,0r0,-22xm233,-328r21,0r0,22r-21,0r0,-22xm0,-284r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm85,-284r21,0r0,22r-21,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm170,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm21,-240r21,0r0,22r-21,0r0,-22xm64,-240r21,0r0,22r-21,0r0,-22xm106,-240r21,0r0,22r-21,0r0,-22xm148,-240r22,0r0,22r-22,0r0,-22xm191,-240r21,0r0,22r-21,0r0,-22xm233,-240r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm85,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm170,-196r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm0,-196r21,0r0,22r-21,0r0,-22xm21,-152r21,0r0,22r-21,0r0,-22xm64,-152r21,0r0,22r-21,0r0,-22xm106,-152r21,0r0,22r-21,0r0,-22xm148,-152r22,0r0,22r-22,0r0,-22xm191,-152r21,0r0,22r-21,0r0,-22xm233,-152r21,0r0,22r-21,0r0,-22xm0,-109r21,0r0,22r-21,0r0,-22xm85,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm170,-109r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm233,-65r21,0r0,22r-21,0r0,-22xm191,-65r21,0r0,22r-21,0r0,-22xm148,-65r22,0r0,22r-22,0r0,-22xm106,-65r21,0r0,22r-21,0r0,-22xm64,-65r21,0r0,22r-21,0r0,-22xm21,-65r21,0r0,22r-21,0r0,-22xm0,-21r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm85,-21r21,0r0,22r-21,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm170,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm233,23r21,0r0,22r-21,0r0,-22xm191,23r21,0r0,22r-21,0r0,-22xm148,23r22,0r0,22r-22,0r0,-22xm106,23r21,0r0,22r-21,0r0,-22xm64,23r21,0r0,22r-21,0r0,-22xm21,23r21,0r0,22r-21,0r0,-22xm0,67r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm85,67r21,0r0,22r-21,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm170,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22"},"\u2593":{"d":"254,-262r0,66r-21,0r0,22r21,0r0,65r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,21r-254,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-66r21,0r0,-22r21,0r0,22r22,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r22,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,44r-21,0r0,22r21,0xm21,-284r0,22r21,0r0,-22r-21,0xm64,-284r0,22r21,0r0,-22r-21,0xm106,-284r0,22r21,0r0,-22r-21,0xm148,-284r0,22r22,0r0,-22r-22,0xm191,-284r0,22r21,0r0,-22r-21,0xm233,-240r-21,0r0,22r21,0r0,-22xm191,-240r-21,0r0,22r21,0r0,-22xm148,-240r-21,0r0,22r21,0r0,-22xm106,-240r-21,0r0,22r21,0r0,-22xm64,-240r-22,0r0,22r22,0r0,-22xm21,-196r0,22r21,0r0,-22r-21,0xm64,-196r0,22r21,0r0,-22r-21,0xm106,-196r0,22r21,0r0,-22r-21,0xm148,-196r0,22r22,0r0,-22r-22,0xm191,-196r0,22r21,0r0,-22r-21,0xm64,-152r-22,0r0,22r22,0r0,-22xm85,-152r0,22r21,0r0,-22r-21,0xm127,-152r0,22r21,0r0,-22r-21,0xm170,-152r0,22r21,0r0,-22r-21,0xm212,-152r0,22r21,0r0,-22r-21,0xm21,-109r0,22r21,0r0,-22r-21,0xm106,-109r0,22r21,0r0,-22r-21,0xm85,-87r0,-22r-21,0r0,22r21,0xm148,-109r0,22r22,0r0,-22r-22,0xm191,-109r0,22r21,0r0,-22r-21,0xm233,-43r0,-22r-21,0r0,22r21,0xm191,-43r0,-22r-21,0r0,22r21,0xm148,-43r0,-22r-21,0r0,22r21,0xm106,-43r0,-22r-21,0r0,22r21,0xm64,-43r0,-22r-22,0r0,22r22,0xm21,-21r0,22r21,0r0,-22r-21,0xm64,-21r0,22r21,0r0,-22r-21,0xm106,-21r0,22r21,0r0,-22r-21,0xm148,-21r0,22r22,0r0,-22r-22,0xm191,-21r0,22r21,0r0,-22r-21,0xm233,45r0,-22r-21,0r0,22r21,0xm191,45r0,-22r-21,0r0,22r21,0xm148,45r0,-22r-21,0r0,22r21,0xm106,45r0,-22r-21,0r0,22r21,0xm64,45r0,-22r-22,0r0,22r22,0xm21,67r0,22r21,0r0,-22r-21,0xm64,67r0,22r21,0r0,-22r-21,0xm106,67r0,22r21,0r0,-22r-21,0xm148,67r0,22r22,0r0,-22r-22,0xm191,67r0,22r21,0r0,-22r-21,0"},"\u25a0":{"d":"26,-166r166,0r0,166r-166,0r0,-166","w":217},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"112,-167r0,96r-96,0r0,-96r96,0","w":127},"\u25ab":{"d":"112,-167r0,96r-96,0r0,-96r96,0xm98,-153r-68,0r0,68r68,0r0,-68","w":127},"\u25ac":{"d":"0,-124r360,0r0,68r-360,0r0,-68","w":360},"\u25b2":{"d":"53,0r125,-249r125,249r-250,0","w":356},"\u25ba":{"d":"51,-249r255,127r-255,127r0,-254","w":356},"\u25bc":{"d":"303,-244r-125,249r-125,-249r250,0","w":356},"\u25c4":{"d":"306,-249r0,254r-255,-127","w":356},"\u25cb":{"d":"31,-102v2,-43,34,-77,78,-77v44,0,76,33,77,77v1,41,-36,78,-77,78v-41,0,-80,-37,-78,-78xm173,-102v-1,-36,-28,-64,-64,-64v-36,0,-64,26,-64,64v0,35,29,65,64,65v35,0,64,-31,64,-65","w":217},"\u25cf":{"d":"109,-179v41,0,77,36,77,77v0,41,-36,78,-77,78v-41,0,-78,-37,-78,-78v0,-41,37,-77,78,-77","w":217},"\u25d8":{"d":"22,0r0,-172r173,0r0,172r-173,0xm144,-86v0,-19,-16,-36,-35,-36v-19,0,-37,16,-36,36v0,19,17,35,36,35v19,0,35,-16,35,-35","w":217},"\u25d9":{"d":"7,0r0,-203r203,0r0,203r-203,0xm186,-101v-1,-44,-33,-78,-77,-78v-45,0,-76,34,-78,78v-1,41,37,77,78,77v41,0,79,-35,77,-77xm45,-101v0,-38,28,-65,64,-65v36,0,63,28,64,65v0,35,-29,64,-64,64v-35,0,-64,-29,-64,-64","w":217},"\u25e6":{"d":"64,-169v26,0,50,24,50,50v0,27,-23,50,-50,50v-27,0,-50,-22,-50,-50v0,-27,23,-50,50,-50xm64,-82v20,0,37,-17,37,-37v0,-20,-17,-37,-37,-37v-20,0,-37,17,-37,37v0,20,17,37,37,37","w":127},"\u263a":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm276,-91v0,-56,-42,-96,-96,-96v-54,0,-96,40,-96,96v0,55,40,96,96,96v56,0,96,-41,96,-96xm123,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm209,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm232,-55v-15,42,-88,44,-104,0r11,-6v16,34,66,33,82,0","w":360},"\u263b":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm151,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm237,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm128,-55v15,42,88,44,104,0r-11,-6v-16,34,-66,33,-82,0","w":360},"\u263c":{"d":"97,-201v21,-13,34,-22,62,-25r0,-59r13,0r0,59v28,2,42,11,61,25r51,-50r9,9r-50,51v15,18,23,36,25,62r59,0r0,12r-59,0v-2,23,-10,43,-25,62r50,51r-10,9r-49,-50v-21,15,-32,22,-62,25r0,59r-13,0r0,-59v-28,-4,-43,-10,-61,-24r-52,49r-9,-9r50,-51v-14,-18,-22,-35,-25,-62r-59,0r0,-12r59,0v2,-28,10,-43,25,-61r-50,-51r9,-10xm255,-123v0,-52,-39,-90,-90,-90v-51,0,-90,38,-90,90v0,52,38,90,90,90v52,0,90,-38,90,-90","w":329},"\u2640":{"d":"227,-173v2,48,-40,92,-87,92r0,71r81,0r0,10r-81,0r0,77r-10,0r0,-77r-81,0r0,-10r81,0r0,-71v-47,-3,-87,-42,-87,-92v0,-53,39,-92,92,-92v53,0,91,39,92,92xm217,-173v-1,-47,-35,-82,-82,-82v-47,0,-82,35,-83,82v-1,44,38,83,83,83v45,0,83,-38,82,-83","w":270},"\u2642":{"d":"20,-46v-1,-59,58,-109,121,-87r63,-136r-94,47r-4,-10r108,-53r6,3r29,117r-10,3r-25,-102r-63,135v30,15,53,44,53,83v0,52,-40,92,-93,92v-52,0,-90,-39,-91,-92xm194,-46v-2,-47,-35,-82,-83,-82v-48,1,-80,35,-82,82v-1,45,38,83,82,83v44,1,84,-38,83,-83","w":270},"\u2660":{"d":"117,-82v-10,43,-87,45,-84,-5v3,-61,81,-67,85,-129v6,56,81,73,86,128v2,20,-18,40,-39,40v-23,-1,-35,-15,-45,-34v0,50,20,72,67,75r1,7r-139,0r1,-7v46,1,68,-28,67,-75","w":236},"\u2663":{"d":"178,-48v-32,-3,-44,-17,-58,-42v2,56,20,74,72,84r1,6r-149,0r1,-6v52,-7,68,-32,71,-84v-13,52,-106,57,-106,-7v0,-38,36,-63,71,-40v-27,-30,-5,-79,37,-79v41,0,64,47,37,79v31,-22,71,0,71,39v0,27,-20,52,-48,50","w":236},"\u2665":{"d":"118,-172v6,-54,96,-58,96,0v0,72,-83,110,-96,176v-11,-65,-87,-105,-96,-174v-3,-25,21,-47,45,-46v27,1,44,19,51,44","w":236},"\u2666":{"d":"118,4v-26,-44,-41,-62,-81,-110v21,-23,63,-78,81,-111v17,33,60,87,81,111v-17,18,-66,81,-81,110","w":236},"\u266a":{"d":"7,-33v-1,-37,44,-54,78,-35r0,-172v69,-5,91,20,88,87r-17,0v3,-35,-20,-48,-53,-47r0,147v12,65,-94,84,-96,20","w":180},"\u266b":{"d":"15,-17v-1,-38,45,-54,79,-35r0,-171r140,-44r0,195v12,66,-94,79,-97,19v-1,-37,46,-54,79,-36r0,-127r-105,32r0,147v3,41,-20,57,-55,59v-26,1,-41,-15,-41,-39","w":270},"\uf001":{"d":"113,-207v-26,-5,-40,2,-37,29r32,0r0,41r-32,0r0,137r-51,0r0,-137r-20,0r0,-41r20,0v-5,-61,31,-77,88,-70r0,41xm180,-178r0,178r-52,0r0,-178r52,0xm180,-245r0,53r-52,0r0,-53r52,0","w":201},"\uf002":{"d":"113,-207v-26,-5,-40,2,-37,29r32,0r0,41r-32,0r0,137r-51,0r0,-137r-20,0r0,-41r20,0v-5,-61,31,-77,88,-70r0,41xm128,0r0,-240r52,0r0,240r-52,0","w":201},"\uf003":{"d":"112,-242r0,86r22,0r0,27r-22,0r0,33r-36,0r0,-33r-69,0r0,-26r62,-87r43,0xm36,-154r41,0r0,-60","w":139},"\uf004":{"d":"125,-240r-32,71r-19,0r10,-71r41,0","w":180},"\uf005":{"d":"113,19r-32,68r-19,0r10,-68r41,0","w":180},"\uf007":{"d":"91,-143v0,-22,-34,-29,-45,-10r-31,-5r6,-82r99,0r-4,31r-67,0r-2,28v29,-26,82,-4,82,36v0,32,-26,51,-61,51v-33,0,-54,-14,-62,-42r36,-5v3,27,49,24,49,-2","w":139},"\uf008":{"d":"36,-96v-1,-51,25,-86,50,-112r-76,0r3,-32r109,0r0,27v-24,27,-45,67,-43,117r-43,0","w":139},"\uf009":{"d":"70,-242v48,-7,78,47,35,68v53,27,18,85,-38,80v-53,8,-85,-56,-34,-74v-43,-22,-12,-81,37,-74xm78,-185v21,-6,18,-34,-9,-34v-19,0,-26,14,-15,24v3,3,11,6,24,10xm60,-155v-12,3,-18,9,-18,18v0,12,9,18,27,18v24,1,31,-12,20,-25v-3,-3,-12,-6,-29,-11","w":139},"\u00a4":{"d":"11,-48r36,-36v-22,-30,-21,-70,0,-100r-36,-36r22,-23r36,37v31,-21,69,-24,101,-1r36,-36r23,23r-36,36v22,33,23,67,0,100r37,36r-22,22r-37,-36v-32,22,-69,23,-102,0r-36,36xm120,-84v26,0,50,-24,50,-50v0,-26,-24,-50,-50,-50v-26,0,-50,24,-50,50v0,26,24,50,50,50","w":239}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdictions. Portions copyright Microsoft
 * Corporation.  All rights reserved.
 * 
 * Trademark:
 * ITC Franklin Gothic is a trademark of The International Typeface Corporation
 * which may be registered in certain jurisdictions.
 * 
 * Description:
 * Designed in 1902 by Morris Fuller Benton for the American Type Founders
 * company, Franklin Gothic still reigns as one of the most-widely used sans serif
 * typefaces. Originally issued in only one weight, the ATF version of Franklin
 * Gothic was eventually expanded to include five additional weights, but no light
 * or intermediate weights were ever developed. In 1979, under license from ATF,
 * ITC developed four new weights in roman and italic: book, medium, demi and
 * heavy. Designed by Victor Caruso, ITCs new weights matched the original faces
 * characteristics, but featured a slightly enlarged lowercase x-height. ITC
 * Franklin Gothic also features a slightly condensed lowercase a-z alphabet. In
 * 1991, ITC commissioned the Font Bureau in Boston to create condensed, compressed
 * and extra compressed versions of ITC Franklin Gothic, which increased the
 * flexibility and usefulness of the design.
 * 
 * Manufacturer:
 * International Typeface Corporation
 * 
 * Designer:
 * Victor Caruso
 * 
 * Vendor URL:
 * http://www.itcfonts.com
 * 
 * License information:
 * http://www.itcfonts.com/itc/licensing.html
 */
Cufon.registerFont({"w":255,"face":{"font-family":"frank","font-weight":400,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 3 2 1 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-83 -353 424 110","underline-thickness":"17.9297","underline-position":"-18.1055","slope":"-9.5","unicode-range":"U+0020-U+FB02"},"glyphs":{" ":{"w":90},"!":{"d":"61,-72r-28,0r9,-168r62,0xm73,-53r-9,53r-54,0r9,-53r54,0","w":103},"\"":{"d":"57,-141r-28,0r10,-99r41,0xm120,-141r-29,0r10,-99r42,0","w":130},"#":{"d":"192,-109r-8,35r-34,0r-17,74r-35,0r17,-74r-25,0r-17,74r-35,0r17,-74r-38,0r7,-35r39,0r6,-27r-38,0r8,-35r38,0r16,-69r35,0r-16,69r25,0r16,-69r35,0r-16,69r34,0r-8,35r-33,0r-7,27r34,0xm129,-136r-27,0r-7,27r28,0","w":211},"$":{"d":"71,-106v-69,-31,-37,-141,46,-129r4,-30r29,0r-5,32v28,5,48,22,61,50r-41,19v-1,-36,-77,-47,-79,-6v-2,31,60,26,82,40v14,9,30,29,29,53v0,47,-36,76,-88,74r-6,38r-29,0r7,-40v-35,-3,-64,-29,-72,-65r47,-12v-4,39,82,54,84,11v1,-29,-48,-25,-69,-35","w":211},"%":{"d":"143,-179v0,34,-28,72,-63,72v-32,0,-55,-28,-55,-60v0,-39,26,-75,63,-75v32,1,55,26,55,63xm88,-210v-17,2,-23,29,-22,51v0,14,4,22,14,22v20,2,20,-35,21,-52v0,-13,-4,-21,-13,-21xm83,0r-33,0r182,-241r33,0xm290,-68v0,33,-26,69,-64,69v-34,0,-54,-28,-54,-60v-1,-36,25,-75,62,-74v34,1,57,26,56,65xm234,-101v-21,0,-33,71,-7,71v14,0,21,-17,21,-51v0,-13,-5,-20,-14,-20","w":304},"&":{"d":"138,-244v41,0,69,19,70,55v0,30,-20,52,-60,64r29,39v14,-13,24,-29,31,-51r48,7v-13,30,-31,55,-55,77v10,12,22,13,41,9r-5,42v-33,7,-54,2,-71,-20v-49,45,-159,30,-159,-43v0,-44,28,-64,73,-75v-38,-48,-4,-104,58,-104xm139,-209v-32,2,-33,32,-10,55v24,-7,36,-18,36,-33v0,-14,-12,-23,-26,-22xm101,-108v-49,7,-52,69,-5,71v16,0,31,-6,45,-16","w":257},"'":{"d":"57,-141r-28,0r10,-99r41,0","w":68},"(":{"d":"123,-240v-67,67,-100,199,-48,302r-30,0v-66,-122,-49,-205,44,-302r34,0","w":105},")":{"d":"-18,62v68,-65,101,-200,49,-302r29,0v67,121,51,205,-43,302r-35,0","w":105},"*":{"d":"110,-189r7,-52r27,4r-10,52r52,-10r4,28r-52,6r25,47r-25,12r-22,-48r-37,39r-19,-20r39,-36r-48,-23r13,-25","w":211},"+":{"d":"200,-140r0,38r-70,0r0,72r-38,0r0,-72r-70,0r0,-38r70,0r0,-73r38,0r0,73r70,0","w":211},",":{"d":"68,-54r-8,48r-43,61r-21,0r34,-55r-26,0r9,-54r55,0","w":92,"k":{"1":1}},"-":{"d":"85,-69r-84,0r7,-39r83,0","w":92,"k":{"\u0443":-4,"\u0442":2,"\u0423":5,"\u0422":8,"\u0410":-8,"Y":11,"W":-1,"V":-2,"T":8,"A":-7}},".":{"d":"59,0r-55,0r9,-54r55,0","w":92,"k":{"1":1}},"\/":{"d":"-8,62r-33,0r182,-302r32,0","w":159},"0":{"d":"206,-142v0,70,-36,146,-103,146v-57,0,-87,-48,-87,-106v0,-66,39,-145,105,-144v55,1,86,46,85,104xm72,-87v-1,32,6,48,32,50v37,3,47,-82,47,-117v0,-33,-7,-51,-32,-51v-44,0,-45,69,-47,118","w":211,"k":{"7":12,"1":10}},"1":{"d":"201,-46r-8,46r-180,0r8,-46r63,0r23,-137v-12,14,-37,19,-66,18r7,-45v38,0,66,-12,82,-36r40,0r-33,200r64,0","w":211,"k":{"9":-2,"8":-2,"7":18,"6":8,"4":-2,"3":-2,"2":-2,"1":3,"0":6,".":-11,",":-11}},"2":{"d":"207,-170v0,82,-72,83,-139,125r121,0r-7,45r-178,0r7,-52v68,-41,106,-69,120,-81v28,-24,24,-67,-13,-67v-22,0,-36,16,-43,45r-50,-12v10,-44,44,-79,95,-79v47,0,87,31,87,76","w":211,"k":{"7":9,"4":4,"1":9}},"3":{"d":"153,-123v77,32,27,129,-53,129v-51,0,-89,-31,-96,-73r46,-9v6,47,86,52,86,5v0,-32,-29,-35,-65,-33r6,-40v34,2,71,-3,69,-31v-3,-40,-66,-37,-74,0r-47,-13v17,-39,47,-58,90,-58v46,-1,86,23,86,66v-1,29,-20,53,-48,57","w":211,"k":{"7":11,"4":1,"1":9}},"4":{"d":"204,-98r-7,43r-36,0r-9,55r-54,0r9,-55r-100,0r7,-44r115,-144r63,0r-24,145r36,0xm115,-96r17,-97r-80,97r63,0","w":211,"k":{"7":16,"4":-2,"1":9}},"5":{"d":"144,-81v1,-39,-53,-48,-72,-17r-45,-15r30,-127r154,0r-13,47r-106,0r-13,55v40,-45,121,-7,121,54v0,102,-175,120,-191,21r53,-8v5,20,20,30,42,30v24,0,40,-18,40,-40","w":211,"k":{"7":10,"4":-2,"1":7}},"6":{"d":"19,-101v0,-71,39,-144,110,-144v45,0,76,29,80,70r-48,4v-3,-22,-14,-34,-33,-34v-29,0,-47,27,-53,83v32,-60,130,-24,126,42v-3,46,-38,84,-89,84v-58,0,-94,-44,-93,-105xm74,-74v-1,22,18,36,37,37v21,0,37,-17,37,-39v0,-22,-16,-38,-36,-38v-21,0,-37,20,-38,40","w":211,"k":{"4":-2,"1":7}},"7":{"d":"212,-240r-4,39v-47,40,-95,120,-101,201r-64,0v9,-75,67,-162,116,-194r-125,0r9,-46r169,0","w":211,"k":{":":19,"7":7,"6":13,"4":28,"1":13,".":29}},"8":{"d":"9,-58v0,-33,27,-55,57,-61v-69,-40,-13,-123,63,-123v41,0,78,18,79,55v0,25,-16,44,-50,57v82,38,25,131,-58,131v-47,0,-91,-16,-91,-59xm163,-178v3,-40,-80,-45,-80,-6v0,16,17,30,51,41v19,-8,29,-20,29,-35xm54,-66v-1,41,92,46,93,3v-5,-25,-28,-29,-56,-41v-19,3,-36,19,-37,38","w":211,"k":{"7":7,"1":8}},"9":{"d":"202,-144v0,69,-42,147,-113,147v-42,0,-68,-19,-80,-56r49,-10v7,34,54,31,69,4v8,-14,16,-37,22,-67v-28,67,-131,34,-128,-36v2,-44,40,-82,89,-82v59,0,92,43,92,100xm75,-166v-1,20,15,36,35,36v21,0,38,-17,38,-38v1,-20,-15,-36,-35,-36v-21,0,-38,17,-38,38","w":211,"k":{"7":14,"4":2,"1":13}},":":{"d":"79,-122r-55,0r10,-54r54,0xm59,0r-55,0r9,-54r55,0","w":92},";":{"d":"79,-122r-55,0r10,-54r54,0xm68,-54r-8,48r-43,61r-21,0r34,-55r-26,0r9,-54r55,0","w":92},"\u037e":{"d":"79,-122r-55,0r10,-54r54,0xm68,-54r-8,48r-43,61r-21,0r34,-55r-26,0r9,-54r55,0","w":92},"<":{"d":"189,-222r0,50r-104,52r104,52r0,49r-156,-81r0,-41","w":211},"=":{"d":"200,-172r0,39r-178,0r0,-39r178,0xm200,-106r0,39r-178,0r0,-39r178,0","w":211},">":{"d":"33,-19r0,-49r103,-52r-103,-53r0,-49r156,81r0,42","w":211},"?":{"d":"186,-181v0,62,-73,55,-78,108r-45,0v-6,-66,56,-60,68,-108v0,-16,-12,-28,-28,-27v-18,0,-30,13,-37,39r-46,-12v9,-37,43,-71,87,-71v42,0,79,29,79,71xm111,-54r-9,54r-53,0r9,-54r53,0","w":181},"@":{"d":"85,-111v0,-47,48,-93,89,-62r2,-8r33,0r-14,93v0,4,2,6,7,6v22,0,38,-29,38,-55v0,-46,-42,-81,-89,-81v-53,0,-96,45,-96,99v0,85,92,120,171,82r10,29v-24,11,-51,17,-83,17v-79,0,-132,-56,-134,-126v-2,-72,61,-132,132,-130v68,1,117,43,121,110v3,56,-62,115,-105,72v-31,38,-82,3,-82,-46xm147,-149v-29,-3,-37,62,-9,66v30,1,46,-64,9,-66","w":278},"A":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96","w":221,"k":{"\u2019":14,"\u201d":13,"\u00ab":2,"y":6,"w":4,"v":4,"u":1,"t":2,"o":2,"g":-5,"e":1,"c":2,"b":-1,"Y":17,"W":11,"V":10,"U":6,"T":18,"Q":7,"O":7,"G":7,"C":7,".":-10,"-":-8,",":-9}},"B":{"d":"220,-71v0,47,-33,71,-92,71r-119,0r40,-240v77,3,183,-19,181,60v0,31,-18,50,-54,57v29,8,44,25,44,52xm88,-144v38,-1,84,9,84,-29v0,-31,-42,-27,-74,-27xm162,-73v2,-36,-44,-29,-80,-30r-10,60v39,0,89,6,90,-30","w":235,"k":{"Y":7,"W":4,"V":3,"O":1}},"C":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104","w":224,"k":{"A":4}},"D":{"d":"226,-130v0,81,-43,135,-133,131r-84,-1r40,-240r71,0v74,-2,106,42,106,110xm69,-43v73,10,101,-31,101,-91v0,-53,-24,-69,-75,-64","w":235,"k":{"Y":13,"V":6,"T":8,"J":4,"A":8}},"E":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0","w":205},"F":{"d":"212,-240r-8,46r-107,0r-9,53r91,0r-7,46r-90,0r-16,95r-57,0r40,-240r163,0","w":191,"k":{"u":9,"r":8,"o":4,"e":4,"a":7,"O":2,"J":17,"A":12,".":18,"-":-8,",":18}},"G":{"d":"73,-94v0,29,14,53,45,52v23,0,38,-14,46,-43r-49,0r7,-44r101,0r-22,131r-22,0r-7,-33v-49,69,-155,23,-155,-68v0,-101,97,-189,180,-125v17,13,26,33,30,58r-52,8v-4,-29,-17,-42,-40,-42v-48,-1,-62,63,-62,106","w":236,"k":{"Y":12,"W":5,"V":5,"T":5}},"H":{"d":"232,-240r-40,240r-53,0r17,-100r-77,0r-17,100r-53,0r40,-240r53,0r-16,94r78,0r16,-94r52,0","w":231},"I":{"d":"104,-240r-40,240r-55,0r40,-240r55,0","w":103},"J":{"d":"144,-240v-14,68,-16,151,-40,210v-12,31,-68,41,-116,30r7,-43v26,7,60,3,64,-18r31,-179r54,0","w":140,"k":{"A":5}},"K":{"d":"235,-240r-75,86r46,154r-57,0r-30,-111r-47,53r-10,58r-53,0r40,-240r53,0r-19,113r96,-113r56,0","w":225,"k":{"y":14,"u":9,"o":10,"e":10,"a":5,"T":-4,"O":10,"G":10,"C":10}},"L":{"d":"104,-240r-32,194r94,0r-7,46r-150,0r40,-240r55,0","w":175,"k":{"\u2019":32,"\u201d":31,"y":14,"Y":24,"W":17,"V":17,"U":4,"T":19,"O":7,"G":6,"C":7,"-":-2}},"M":{"d":"312,-240r-40,240r-56,0r33,-201r-96,201r-32,0r-33,-203r-34,203r-45,0r40,-240r84,0r22,147r70,-147r87,0","w":310},"N":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0","w":234,"k":{"A":1,".":-3,",":-3}},"O":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54","w":231,"k":{"Y":12,"X":8,"W":5,"V":4,"T":5,"A":7}},"P":{"d":"222,-171v-2,53,-31,85,-92,81r-51,0r-15,90r-55,0r40,-240v82,0,177,-13,173,69xm169,-167v0,-32,-36,-31,-72,-30r-11,65v40,1,83,3,83,-35","w":216,"k":{"J":20,"A":14,".":25,"-":-4,",":25}},"Q":{"d":"131,-244v128,0,115,205,27,235v-2,16,27,17,45,14r-2,40v-43,8,-79,-5,-75,-43v-66,12,-109,-39,-109,-103v0,-71,42,-143,114,-143xm131,-199v-45,0,-59,65,-59,107v0,35,13,51,41,51v44,0,58,-62,58,-103v0,-37,-13,-55,-40,-55","w":233},"R":{"d":"229,-171v0,33,-21,60,-54,67r30,104r-56,0r-25,-95r-45,0r-16,95r-54,0r40,-240r89,0v58,-3,91,21,91,69xm173,-170v0,-35,-43,-27,-78,-28r-10,61v40,-1,88,7,88,-33","w":236,"k":{"y":-1,"u":5,"o":6,"e":5,"Y":10,"W":8,"V":7,"U":5,"T":2,"O":5,"G":5,"C":5}},"S":{"d":"55,-111v-62,-40,-22,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41v21,10,35,29,35,59v0,76,-106,101,-162,61v-17,-12,-28,-30,-32,-54r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43","w":206,"k":{"Y":9,"W":6,"V":5,"T":2,"A":1}},"T":{"d":"194,-194r-61,0r-32,194r-55,0r32,-194r-60,0r7,-46r176,0","w":176,"k":{"\u00ab":18,"y":17,"w":18,"v":17,"u":18,"s":14,"r":17,"o":19,"j":-1,"i":-1,"g":17,"e":18,"c":19,"a":19,"Y":-17,"W":-12,"V":-14,"S":-7,"J":19,"A":18,";":16,":":16,".":14,"-":7,",":15}},"U":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0","w":231,"k":{"A":6}},"V":{"d":"224,-240r-110,240r-58,0r-36,-240r56,0r23,180r77,-180r48,0","w":197,"k":{"\u00ab":9,"y":-4,"u":7,"r":7,"o":9,"g":7,"e":9,"a":9,"T":-13,"S":-1,"O":4,"G":4,"C":5,"A":11,";":6,":":6,".":13,"-":-2,",":13}},"W":{"d":"341,-240r-99,240r-51,0r-22,-167r-64,167r-51,0r-29,-240r55,0r15,166r64,-166r50,0r20,166r63,-166r49,0","w":319,"k":{"\u00ab":8,"y":-4,"u":7,"r":6,"o":8,"g":6,"e":7,"a":8,"T":-10,"O":4,"G":4,"C":4,"A":10,":":6,".":10,"-":-3,",":10}},"X":{"d":"227,-240r-84,112r58,128r-60,0r-39,-91r-63,91r-55,0r97,-128r-52,-112r60,0r33,75r51,-75r54,0","w":214,"k":{"y":12,"o":12,"e":11,"Q":10,"O":10,"C":10,"-":4}},"Y":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0","w":190,"k":{"\u00ab":18,"u":11,"p":10,"o":16,"g":14,"e":15,"a":16,"T":-16,"S":-1,"O":7,"G":7,"C":8,"A":15,";":10,":":10,".":17,"-":8,",":17}},"Z":{"d":"-1,-39r140,-157r-110,2r8,-46r178,0r-5,37r-141,159r123,-2r-8,46r-192,0","w":206},"[":{"d":"111,-218r-39,0r-44,259r39,0r-3,21r-72,0r51,-302r71,0","w":105},"\\":{"d":"116,62r-81,-302r31,0r81,302r-31,0","w":159},"]":{"d":"-5,40r39,0r43,-258r-39,0r4,-22r71,0r-50,302r-72,0","w":105},"^":{"d":"57,-120r-50,0r56,-122r64,0r57,122r-51,0r-38,-83","w":180},"_":{"d":"5,17r180,0r0,42r-180,0r0,-42","w":180},"`":{"d":"139,-204r-69,-35r17,-27r63,42","w":180},"a":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37","w":194,"k":{"y":5,"w":2,"v":3}},"b":{"d":"184,-109v0,55,-30,113,-82,113v-24,0,-42,-11,-53,-32v-6,10,-11,19,-14,28r-28,0r40,-240r51,0r-14,86v30,-56,100,-24,100,45xm70,-61v0,17,8,29,24,29v29,0,38,-55,39,-85v0,-17,-8,-30,-24,-30v-30,-2,-39,57,-39,86","w":194,"k":{"y":3,"v":1}},"c":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33","w":182},"d":{"d":"11,-70v0,-50,27,-113,78,-113v23,0,36,12,42,34r15,-91r52,0r-40,240r-48,0r4,-28v-30,60,-103,27,-103,-42xm64,-64v0,18,7,30,22,31v33,4,36,-57,39,-82v2,-17,-9,-31,-25,-31v-27,0,-36,52,-36,82","w":194},"e":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0","w":189,"k":{"y":5,"x":4,"w":2,"v":2}},"f":{"d":"40,-179v5,-57,39,-78,99,-70r-3,41v-27,-4,-44,1,-45,29r35,0r-7,41r-34,0r-23,138r-52,0r23,-138r-21,0r5,-41r23,0","w":114,"k":{"t":-9,"s":-6,"o":-1,"l":-1,"j":-1,"i":-1,"f":-9,"e":-1,"a":-1}},"g":{"d":"42,-86v-48,-34,-3,-96,57,-96v13,0,23,1,31,3v5,-33,24,-46,57,-41r-2,35v-17,-3,-32,0,-34,14v54,32,11,109,-52,100v-7,0,-18,-1,-31,-3v-10,4,-14,9,-14,16v0,11,11,12,26,12v60,1,86,4,93,49v-4,45,-39,61,-101,60v-49,0,-86,-4,-86,-39v0,-16,12,-28,34,-36v-29,-25,-14,-62,22,-74xm97,-99v19,0,31,-13,31,-31v0,-15,-9,-23,-26,-23v-19,-1,-31,13,-31,28v0,18,9,26,26,26xm30,16v5,25,97,24,95,-1v-2,-24,-57,-9,-76,-16v-7,1,-19,9,-19,17","w":184},"h":{"d":"84,-153v20,-44,99,-37,97,16v-1,38,-15,97,-21,137r-51,0r19,-124v-4,-30,-45,-17,-48,5r-22,119r-51,0r40,-240r51,0","w":196,"k":{"y":4}},"i":{"d":"101,-243r-8,51r-54,0r8,-51r54,0xm90,-179r-30,179r-53,0r30,-179r53,0","w":96},"j":{"d":"92,-192r-53,0r8,-51r54,0xm90,-179r-26,157v-5,68,-29,97,-100,85r6,-41v38,6,37,-17,42,-53r25,-148r53,0","w":96},"k":{"d":"206,-179r-62,61r38,118r-54,0r-25,-82r-37,35r-8,47r-51,0r40,-240r51,0r-24,140r77,-79r55,0","w":194,"k":{"u":2,"o":4,"g":-5,"e":3,"a":2,".":-7,",":-7}},"l":{"d":"98,-240r-40,240r-51,0r40,-240r51,0","w":94},"m":{"d":"174,-149v22,-50,106,-41,103,18v-2,40,-15,91,-21,131r-50,0r19,-120v2,-25,-28,-27,-39,-12v-18,25,-21,93,-30,132r-50,0r20,-123v-5,-35,-44,-15,-47,6r-21,117r-51,0r30,-179r46,0r-5,31v17,-43,80,-49,96,-1","w":293,"k":{"y":4,"w":2,"v":2}},"n":{"d":"79,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0","w":196,"k":{"y":4,"w":1,"v":2}},"o":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34","w":192,"k":{"y":5,"x":4,"w":2,"v":3,"t":1}},"p":{"d":"108,4v-22,0,-39,-14,-45,-30r-15,88r-52,0r41,-241r47,0r-6,32v29,-62,106,-32,106,39v0,52,-28,112,-76,112xm69,-64v-1,18,9,31,25,32v28,1,37,-56,37,-84v0,-15,-7,-29,-23,-29v-32,0,-37,55,-39,81","w":194,"k":{"y":3}},"q":{"d":"10,-67v4,-53,31,-117,85,-115v23,0,39,11,48,32v7,-8,13,-18,17,-29r29,0r-41,241r-52,0r15,-85v-29,54,-106,19,-101,-44xm101,-149v-28,-3,-39,63,-39,87v0,22,7,33,22,33v31,0,41,-66,41,-92v1,-17,-9,-27,-24,-28","w":194},"r":{"d":"128,-130v-64,2,-54,75,-68,130r-53,0r30,-179r49,0r-6,41v12,-26,19,-43,53,-43","w":126,"k":{"z":-3,"y":-8,"x":-4,"w":-7,"v":-8,"t":-7,"s":-5,"p":2,"o":-1,"k":2,"h":2,"f":-7,".":12,"-":1,",":12}},"s":{"d":"25,-87v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35v40,39,-3,101,-62,101v-41,0,-76,-18,-81,-54r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39","w":167,"k":{"t":-2}},"t":{"d":"130,-138r-42,0r-14,87v-2,16,27,17,41,13r-6,39v-42,8,-93,2,-89,-40v2,-25,13,-71,18,-99r-28,0r7,-41r30,0r12,-49r45,-1r-8,50r41,0","w":129,"k":{"a":-1}},"u":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36","w":193},"v":{"d":"178,-179r-88,179r-43,0r-36,-179r55,0r19,111r52,-111r41,0","w":163,"k":{"s":-2,"o":3,"g":2,"e":3,"c":3,"a":4,".":9,"-":-7,",":9}},"w":{"d":"271,-179r-81,179r-46,0r-13,-115r-45,115r-45,0r-26,-179r53,0r14,112r42,-112r48,0r11,112r48,-112r40,0","w":259,"k":{"s":-2,"o":2,"g":1,"e":2,"c":2,"a":3,".":8,"-":-7,",":8}},"x":{"d":"182,-179r-68,85r43,94r-56,0r-26,-63r-45,63r-46,0r74,-96r-39,-83r57,0r23,52r37,-52r46,0","w":170,"k":{"q":2,"o":4,"e":3,"c":4,"a":3}},"y":{"d":"176,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0","w":161,"k":{"s":-2,"o":2,"g":1,"e":2,"c":2,"a":3,".":8,"-":-7,",":8}},"z":{"d":"155,-144r-93,106r78,0r-7,38r-141,0r6,-34r94,-107r-74,0r7,-38r136,0","w":155},"{":{"d":"74,62v-41,4,-64,-4,-57,-48r12,-76v0,-11,-5,-17,-16,-19r3,-19v62,-16,-8,-159,109,-139v-3,7,1,21,-9,21v-19,0,-15,4,-20,23v-10,39,-3,92,-39,106v34,24,2,80,2,121v0,11,8,8,19,9","w":105},"|":{"d":"70,-240r50,0r0,300r-50,0r0,-300","w":180},"}":{"d":"40,-239v36,-6,64,4,57,47r-12,76v0,11,5,17,16,19r-3,19v-63,16,10,158,-109,140v3,-7,-1,-21,9,-21v18,0,15,-4,20,-23v10,-40,4,-92,39,-107v-35,-23,0,-78,-2,-120v2,-12,-9,-8,-19,-9","w":105},"~":{"d":"141,-87v-6,2,-58,-18,-66,-18v-10,0,-18,8,-25,22r-27,-19v14,-31,21,-47,55,-50v28,-2,79,41,93,-1r27,17v-14,33,-33,49,-57,49","w":211},"\u00c4":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm190,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm132,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":221},"\u00c5":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm174,-288v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm126,-288v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":221},"\u00c7":{"d":"214,-78v-14,46,-48,84,-106,82r-7,14v21,-5,38,5,39,23v1,39,-59,47,-87,25r9,-15v18,12,43,14,45,-7v2,-13,-17,-14,-32,-10r14,-32v-46,-8,-72,-51,-72,-102v-2,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44","w":224},"\u00c9":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm120,-260r-9,-20r72,-42r14,29","w":205},"\u00d1":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0xm92,-288v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":234},"\u00d6":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm197,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm139,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":231},"\u00dc":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm199,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm141,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":231},"\u00e1":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm99,-204r-9,-20r72,-42r14,29","w":194},"\u00e0":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm137,-204r-69,-35r17,-27r63,42","w":194},"\u00e2":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm179,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":194},"\u00e4":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm169,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm111,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":194},"\u00e3":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm59,-230v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":194},"\u00e5":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm153,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm105,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":194},"\u00e7":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-14,44,-41,66,-82,67r-7,14v16,-4,32,6,31,22v0,34,-50,42,-75,22r8,-15v14,9,36,15,37,-5v1,-11,-14,-12,-26,-10r15,-30v-103,-20,-64,-184,32,-184v46,0,74,28,74,69r-47,3v0,-21,-9,-33,-26,-33","w":182},"\u00e9":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm94,-204r-9,-20r72,-42r14,29","w":189},"\u00e8":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm132,-204r-69,-35r17,-27r63,42","w":189},"\u00ea":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm176,-208r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":189},"\u00eb":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm167,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm109,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":189},"\u00ed":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm47,-204r-9,-20r72,-42r14,29","w":97},"\u00ec":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm88,-205r-69,-35r17,-27r63,42","w":97},"\u00ee":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm130,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":97},"\u00ef":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm120,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm62,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":97},"\u00f1":{"d":"79,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0xm58,-231v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":196},"\u00f3":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm95,-204r-9,-20r72,-42r14,29","w":192},"\u00f2":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm133,-204r-69,-35r17,-27r63,42","w":192},"\u00f4":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm178,-210r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":192},"\u00f6":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm168,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm110,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":192},"\u00f5":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm57,-230v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":192},"\u00fa":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm98,-204r-9,-20r72,-42r14,29","w":193},"\u00f9":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm135,-204r-69,-35r17,-27r63,42","w":193},"\u00fb":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm180,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":193},"\u00fc":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm170,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm112,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":193},"\u2020":{"d":"106,-240r50,0r-11,63r62,0r-6,41r-63,0r-33,198r-50,0r33,-198r-62,0r7,-41r62,0","w":211},"\u00b0":{"d":"173,-194v0,27,-22,51,-49,51v-27,0,-51,-24,-51,-51v0,-27,23,-51,50,-51v27,0,50,23,50,51xm99,-194v0,13,11,24,24,24v13,0,24,-11,24,-24v0,-13,-11,-25,-24,-25v-13,0,-24,12,-24,25","w":211},"\u00a2":{"d":"90,-39v-56,-10,-66,-96,-31,-140v15,-18,33,-29,57,-30r6,-35r24,0r-6,38v30,6,47,26,51,60r-44,5v2,-21,-8,-34,-26,-34v-38,0,-54,100,-8,102v15,0,25,-11,32,-31r40,8v-13,38,-37,58,-71,59r-8,47r-24,0","w":211},"\u00a3":{"d":"84,-46v41,1,64,0,72,-33r48,14v-23,50,-43,65,-117,65r-98,0r5,-46v49,4,69,-13,66,-64r-35,0r6,-36r28,0v-2,-59,25,-99,82,-99v38,0,61,16,69,48r-48,18v-2,-16,-9,-24,-21,-24v-22,0,-29,26,-27,57r39,0r-6,36r-34,0v-2,30,-12,51,-29,64","w":211},"\u00a7":{"d":"61,-145v-41,-41,14,-97,66,-97v31,0,54,13,70,41r-39,12v-8,-27,-59,-29,-62,0v12,38,93,26,93,82v0,19,-9,38,-29,56v49,43,-5,116,-69,116v-43,0,-75,-22,-85,-54r46,-7v7,32,80,35,80,0v0,-43,-104,-32,-104,-89v0,-21,11,-40,33,-60xm94,-126v-34,29,-14,40,32,57v32,-29,12,-40,-32,-57","w":211},"\u2022":{"d":"126,-173v27,0,49,24,49,51v0,27,-23,50,-49,50v-26,0,-50,-24,-50,-50v0,-27,23,-51,50,-51","w":239},"\u00b6":{"d":"24,-167v3,-60,33,-73,107,-73r97,0r-3,22r-27,0r-46,278r-21,0r46,-278r-21,0r-47,278r-22,0r30,-177v-54,3,-96,-1,-93,-50xm69,-170v-1,31,18,31,51,31r14,-79v-45,-3,-64,9,-65,48","w":211},"\u00df":{"d":"120,-173v35,6,56,-49,12,-49v-41,0,-36,28,-44,74r-28,166r-55,0r24,-146r-18,0r7,-40r18,0v8,-55,49,-91,107,-92v38,-1,67,19,68,53v1,39,-44,49,-75,60v36,20,78,28,78,74v1,58,-75,98,-132,64r18,-31v21,13,64,10,63,-19v-3,-37,-72,-28,-69,-70v0,-15,9,-29,26,-44","w":224},"\u00ae":{"d":"268,-120v0,65,-57,124,-124,124v-66,0,-123,-58,-123,-124v0,-66,57,-124,123,-124v68,0,124,59,124,124xm38,-120v0,56,49,106,106,106v58,0,106,-50,106,-106v0,-56,-47,-106,-106,-106v-57,0,-106,50,-106,106xm100,-192v52,-1,116,-5,115,42v0,20,-11,34,-33,40r19,62r-38,0r-17,-56r-24,0r-9,56r-38,0xm176,-149v3,-20,-24,-16,-44,-16r-6,34v23,0,52,3,50,-18","w":278},"\u00a9":{"d":"268,-120v0,65,-57,124,-124,124v-66,0,-123,-58,-123,-124v0,-66,57,-124,123,-124v68,0,124,59,124,124xm38,-120v0,56,49,106,106,106v58,0,106,-50,106,-106v0,-56,-47,-106,-106,-106v-57,0,-106,50,-106,106xm76,-109v0,-60,63,-112,115,-72v11,9,16,25,17,45r-37,1v2,-17,-5,-30,-21,-30v-33,0,-51,89,-10,90v13,0,23,-9,29,-27r34,6v-15,73,-127,64,-127,-13","w":278},"\u2122":{"d":"130,-212r-37,0r-18,109r-38,0r19,-109r-37,0r4,-28r112,0xm310,-240r-23,137r-38,0r17,-102r-53,102r-22,0r-20,-104r-17,104r-31,0r22,-137r55,0r14,78r39,-78r57,0","w":297},"\u00b4":{"d":"84,-204r-9,-20r72,-42r14,29","w":180},"\u00a8":{"d":"163,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm105,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":180},"\u2260":{"d":"115,-171r20,-39r31,16r-12,23r35,0r0,44r-55,0r-12,24r67,0r0,44r-87,0r-17,35r-32,-16r10,-19r-30,0r0,-44r49,0r13,-24r-62,0r0,-44r82,0","w":211},"\u00c6":{"d":"308,-194r-107,0r-8,48r89,0r-7,44r-89,0r-10,56r109,0r-8,46r-161,0r10,-60r-59,0r-36,60r-48,0r145,-240r187,0xm90,-102r43,0r16,-96","w":303},"\u00d8":{"d":"41,-25v-72,-89,19,-272,137,-205r20,-29r33,0r-31,46v69,87,-13,266,-137,205r-17,27r-34,0xm152,-193v-60,-29,-91,61,-78,119xm89,-47v62,29,87,-58,79,-119","w":231},"\u221e":{"d":"69,-181v21,1,40,17,50,31v27,-62,111,-49,111,21v0,35,-21,61,-54,61v-22,0,-41,-13,-57,-40v-10,14,-28,30,-50,30v-26,0,-43,-24,-43,-51v0,-28,17,-52,43,-52xm204,-130v0,-17,-9,-36,-27,-35v-13,0,-26,11,-41,35v18,24,16,34,40,36v18,2,29,-18,28,-36xm51,-130v3,35,35,30,53,0v-12,-17,-22,-25,-33,-25v-11,0,-21,11,-20,25","w":256},"\u00b1":{"d":"193,-140r0,38r-70,0r0,72r-38,0r0,-72r-70,0r0,-38r70,0r0,-73r38,0r0,73r70,0xm193,-20r0,38r-178,0r0,-38r178,0","w":211},"\u2264":{"d":"189,-241r0,46r-103,47r103,47r0,47r-156,-73r0,-42xm189,-44r0,44r-156,0r0,-44r156,0","w":211},"\u2265":{"d":"33,-54r0,-47r103,-47r-103,-47r0,-46r156,72r0,42xm33,0r0,-44r156,0r0,44r-156,0","w":211},"\u00a5":{"d":"27,-154r36,0r-33,-86r58,0r32,97r57,-97r51,0r-56,86r42,0r-5,29r-56,0v-5,10,-15,15,-16,29r67,0r-4,29r-68,0r-11,67r-54,0r11,-67r-66,0r5,-29r66,0v2,-11,-7,-19,-9,-29r-52,0","w":211},"\u00b5":{"d":"77,-85v-6,28,-7,52,18,55v28,-4,32,-21,38,-55r16,-94r52,0r-30,179r-42,0r4,-28v-12,39,-61,48,-66,3r-15,87r-51,0r40,-241r51,0","w":211},"\u2202":{"d":"145,-166v7,-63,-55,-88,-78,-31r-24,-15v9,-29,32,-50,65,-50v45,0,65,43,64,97v-2,80,-31,168,-109,170v-34,0,-56,-25,-55,-62v1,-67,62,-112,137,-109xm48,-59v0,42,50,35,69,2v12,-20,22,-44,26,-76v-54,-5,-95,29,-95,74","w":177},"\u2211":{"d":"24,-270r218,0r0,29r-174,0r107,141r-114,147r183,0r0,28r-223,0r0,-33r109,-141r-106,-140r0,-31","w":256},"\u220f":{"d":"28,-270r240,0r0,345r-34,0r0,-314r-172,0r0,314r-34,0r0,-345","w":296},"\uf006":{"d":"12,0r24,-141r-21,0r6,-38r197,0r-7,38r-20,0r-24,141r-52,0r24,-141r-51,0r-24,141r-52,0","w":209},"\u222b":{"d":"0,17v1,-25,28,-14,37,-6v5,0,6,-3,6,-10v-4,-82,-14,-243,2,-300v9,-31,45,-38,53,-10v0,24,-24,20,-36,9v-5,0,-7,3,-7,11v4,88,11,121,6,225v-4,67,-2,93,-40,103v-12,0,-21,-9,-21,-22","w":98},"\u00aa":{"d":"32,-211v5,-42,101,-51,101,-3v0,26,-10,52,-8,78r-35,0v0,-4,-2,-8,0,-11v-15,24,-68,17,-68,-16v0,-25,25,-39,75,-41v3,-11,0,-21,-12,-20v-10,0,-16,5,-20,16xm94,-187v-23,1,-35,8,-35,20v0,8,4,12,11,12v12,0,20,-11,24,-32","w":127},"\u00ba":{"d":"87,-246v27,0,48,22,48,52v0,32,-25,61,-58,61v-29,0,-51,-20,-51,-49v0,-36,24,-64,61,-64xm78,-156v20,-1,33,-65,6,-67v-22,-2,-33,66,-6,67","w":126},"\u2126":{"d":"149,-226v-84,-4,-116,152,-40,183r-6,43r-113,0r5,-40v25,0,47,3,71,4v-36,-15,-54,-45,-54,-88v-2,-77,61,-140,139,-140v76,0,115,34,115,103v0,60,-34,107,-82,125r71,-4r-6,40r-113,0r6,-43v69,-15,106,-178,7,-183","w":276},"\u00e6":{"d":"163,-166v57,-44,150,2,128,86r-119,0v-14,52,54,65,67,19r45,8v-21,69,-123,79,-155,17v-20,52,-125,55,-125,-10v0,-60,55,-61,125,-66v7,-20,2,-38,-21,-38v-19,0,-31,9,-37,27r-48,-7v14,-51,96,-70,140,-36xm242,-110v5,-23,-7,-39,-27,-40v-20,0,-33,14,-39,40r66,0xm59,-50v0,13,9,21,21,21v22,0,36,-19,44,-58v-44,1,-65,14,-65,37","w":302},"\u00f8":{"d":"34,-18v-64,-67,13,-207,110,-155r16,-22r27,0r-26,36v57,68,-14,202,-110,154r-15,21r-27,0xm102,-149v-32,-1,-40,57,-37,87r56,-79v-4,-5,-11,-8,-19,-8xm73,-36v42,24,57,-37,55,-78","w":192},"\u00bf":{"d":"70,-124r9,-54r53,0r-9,54r-53,0xm-5,4v0,-63,73,-56,78,-109r45,0v6,68,-57,59,-68,109v0,15,12,27,28,26v18,0,30,-12,37,-38r46,12v-9,37,-43,70,-87,70v-41,-1,-79,-27,-79,-70","w":180},"\u00a1":{"d":"31,-124r9,-54r53,0r-9,54r-53,0xm42,-105r28,0r-9,167r-61,0","w":103},"\u00ac":{"d":"139,0r0,-53r-106,0r0,-44r156,0r0,97r-50,0","w":211},"\u221a":{"d":"184,-329r13,0r-55,343r-87,-180r-35,16r-6,-11r53,-27r71,145","w":197},"\u0192":{"d":"106,-193v15,-55,45,-81,111,-69r-13,40v-28,-4,-40,3,-45,29r31,0r-13,41r-32,0r-42,127v-13,56,-43,80,-111,71r14,-41v39,3,40,-16,51,-49r36,-108r-20,0r13,-41r20,0","w":211},"\u2248":{"d":"141,-126v-7,2,-59,-19,-66,-18v-10,0,-18,7,-25,21r-27,-17v14,-31,21,-48,55,-51v27,-2,78,41,93,0r27,16v-14,33,-33,49,-57,49xm141,-51v-7,2,-59,-19,-66,-18v-10,0,-18,7,-25,21r-27,-17v14,-31,20,-49,55,-51v27,-2,78,41,93,0r27,16v-14,32,-33,49,-57,49","w":211},"\u2206":{"d":"216,0r-211,0r110,-244xm174,-14r-70,-170r-77,170r147,0","w":220},"\u00ab":{"d":"101,-37r-17,0r-24,-52r37,-51r18,0r-26,53xm53,-37r-16,0r-25,-51r38,-52r18,0r-27,53","w":124,"k":{"\u0443":5,"\u0442":4,"\u043b":1,"\u042f":4,"\u0427":2,"\u0423":8,"\u0422":17,"\u041b":-4}},"\u00bb":{"d":"23,-140r17,0r24,51r-37,52r-18,0r26,-53xm71,-140r16,0r25,51r-37,52r-18,0r26,-53","w":124,"k":{"Y":21,"W":9,"V":9,"T":18,"A":2}},"\u2026":{"d":"60,0r-55,0r10,-54r54,0xm156,0r-55,0r9,-54r55,0xm251,0r-54,0r9,-54r54,0","w":286},"\u00a0":{"w":90},"\u00c0":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm157,-260r-69,-35r17,-27r63,42","w":221},"\u00c3":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm81,-288v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":221},"\u00d5":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm89,-289v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":231},"\u0152":{"d":"17,-100v0,-92,74,-180,164,-133r1,-7r160,0r-8,46r-109,0r-9,49r91,0r-8,43r-90,0r-9,56r109,0r-7,46r-156,0r2,-10v-63,38,-131,-15,-131,-90xm74,-96v-4,49,48,74,75,37r20,-120v-7,-15,-18,-22,-34,-22v-45,2,-57,59,-61,105","w":327},"\u0153":{"d":"172,-81v-4,26,4,50,29,49v18,0,29,-9,36,-29r45,7v-13,53,-95,81,-139,38v-47,48,-141,12,-132,-62v-9,-80,88,-139,146,-83v52,-51,150,-8,130,80r-115,0xm240,-110v7,-37,-32,-53,-52,-28v-7,8,-10,17,-12,28r64,0xm91,-29v31,0,36,-44,37,-82v0,-25,-9,-37,-26,-37v-31,0,-38,49,-38,79v0,26,9,40,27,40","w":298},"\u2013":{"d":"179,-69r-154,0r7,-39r154,0","w":211},"\u2014":{"d":"242,-69r-250,0r6,-39r250,0","w":239},"\u201c":{"d":"98,-138r9,-48r41,-54r20,0r-35,50r22,0r-8,52r-49,0xm29,-138r8,-48r41,-54r20,0r-34,50r22,0r-9,52r-48,0","w":158,"k":{"Y":-9,"W":-7,"V":-9,"T":-3,"A":14}},"\u201d":{"d":"94,-240r-8,47r-41,55r-20,0r34,-50r-22,0r9,-52r48,0xm164,-240r-8,47r-42,55r-19,0r34,-50r-22,0r8,-52r49,0","w":158,"k":{"Y":-7,"W":-6,"V":-8,"T":-2,"A":16}},"\u2018":{"d":"30,-138r8,-48r42,-54r20,0r-35,50r22,0r-8,52r-49,0","w":92},"\u2019":{"d":"96,-240r-8,47r-42,55r-19,0r34,-50r-22,0r8,-52r49,0","w":92},"\u00f7":{"d":"111,-207v13,0,23,11,23,24v0,13,-10,24,-23,24v-13,1,-24,-11,-24,-24v0,-13,11,-24,24,-24xm200,-140r0,38r-178,0r0,-38r178,0xm111,-83v13,-1,24,11,24,24v0,13,-11,24,-24,24v-13,0,-25,-11,-24,-24v0,-12,12,-24,24,-24","w":211},"\u25ca":{"d":"169,-134r-70,134r-21,0r-70,-134r70,-134r21,0xm147,-134r-58,-115r-59,115r59,114","w":177},"\u00ff":{"d":"176,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0xm154,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm96,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":161},"\u0178":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm175,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm117,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":190},"\u2215":{"d":"-50,0r-33,0r182,-241r33,0","w":38},"\u20ac":{"d":"33,-157v9,-93,176,-126,188,-13r-59,4v-7,-55,-64,-28,-71,9r40,0r-3,28r-43,0r-3,21r43,0r-4,27r-39,0v3,53,58,50,69,3r58,6v-18,48,-39,76,-98,76v-52,0,-85,-34,-88,-85r-16,0r3,-27r14,0v1,-10,2,-17,3,-21r-14,0r4,-28r16,0","w":210},"\u2039":{"d":"53,-37r-17,0r-24,-52r37,-51r18,0r-26,53","w":76},"\u203a":{"d":"23,-140r17,0r24,51r-37,52r-18,0r26,-53","w":76},"\ufb01":{"d":"40,-179v5,-55,34,-78,91,-69r-3,40v-24,-7,-33,3,-38,29r33,0r-7,40r-33,0r-23,139r-51,0r24,-139r-22,0r6,-40r23,0xm201,-244r-8,52r-54,0r8,-52r54,0xm160,0r-53,0r30,-179r54,0","w":196},"\ufb02":{"d":"40,-179v3,-52,35,-79,92,-69r-3,40v-26,-5,-35,2,-39,29r32,0r-7,41r-32,0r-23,138r-50,0r23,-138r-23,0r7,-41r23,0xm160,0r-54,0r40,-240r54,0","w":196},"\u2021":{"d":"106,-240r50,0r-11,63r63,0r-7,41r-63,0r-14,87r62,0r-7,42r-62,0r-12,69r-50,0r12,-69r-62,0r7,-42r62,0r15,-87r-63,0r7,-41r62,0","w":211},"\u2219":{"d":"55,-62r-55,0r9,-54r55,0","w":63},"\u201a":{"d":"64,-52r-8,48r-41,54r-20,0r34,-50r-22,0r9,-52r48,0","w":92},"\u201e":{"d":"62,-52r-8,48r-41,54r-20,0r34,-50r-22,0r9,-52r48,0xm132,-52r-8,48r-41,54r-20,0r34,-50r-22,0r9,-52r48,0","w":158,"k":{"Y":21,"W":14,"V":14,"T":15,"A":-8}},"\u2030":{"d":"143,-179v0,34,-28,72,-63,72v-32,0,-55,-28,-55,-60v0,-39,26,-75,63,-75v32,1,55,26,55,63xm88,-210v-17,2,-23,29,-22,51v0,14,4,22,14,22v20,2,20,-35,21,-52v0,-13,-4,-21,-13,-21xm83,0r-33,0r182,-241r33,0xm424,-68v0,32,-25,69,-63,69v-35,0,-55,-28,-55,-60v-1,-36,25,-76,62,-74v37,2,56,25,56,65xm368,-101v-21,0,-33,69,-6,71v14,0,20,-17,20,-51v0,-13,-5,-20,-14,-20xm290,-68v0,33,-26,69,-64,69v-34,0,-54,-28,-54,-60v-1,-36,25,-75,62,-74v34,1,57,26,56,65xm234,-101v-21,0,-33,71,-7,71v14,0,21,-17,21,-51v0,-13,-5,-20,-14,-20","w":438},"\u00c2":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm199,-265r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":221},"\u00ca":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm202,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":205},"\u00c1":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm119,-260r-9,-20r72,-42r14,29","w":221},"\u00cb":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm190,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm132,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":205},"\u00c8":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm159,-261r-69,-35r17,-27r63,42","w":205},"\u00cd":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm62,-260r-9,-20r72,-42r14,29","w":103},"\u00ce":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm144,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":103},"\u00cf":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm134,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm76,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":103},"\u00cc":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm100,-259r-69,-35r17,-27r63,42","w":103},"\u00d3":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm125,-260r-9,-20r72,-42r14,29","w":231},"\u00d4":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm206,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":231},"\u00d2":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm164,-260r-69,-35r17,-27r63,42","w":231},"\u00da":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm130,-260r-9,-20r72,-42r14,29","w":231},"\u00db":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm207,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":231},"\u00d9":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm167,-260r-69,-35r17,-27r63,42","w":231},"\u0131":{"d":"90,-179r-30,179r-53,0r30,-179r53,0","w":97},"\u02c6":{"d":"172,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":180},"\u02dc":{"d":"54,-230v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":180},"\u02c9":{"d":"166,-216r-111,0r4,-25r111,0","w":180},"\u02d8":{"d":"172,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":180},"\u02d9":{"d":"134,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":180},"\u02da":{"d":"148,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm100,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":180},"\u00b8":{"d":"105,40v-1,35,-50,42,-75,22r8,-15v14,9,36,14,38,-5v1,-11,-14,-12,-27,-10r17,-32r17,0r-9,18v16,-4,32,6,31,22","w":180},"\u02dd":{"d":"66,-204r-10,-17r58,-45r15,24xm127,-204r-10,-17r58,-45r16,24","w":180},"\u02db":{"d":"158,55v-21,12,-66,10,-66,-18v0,-19,24,-42,59,-37v-18,10,-27,20,-27,30v0,15,17,17,32,11","w":180},"\u02c7":{"d":"53,-258r35,-4r24,25r34,-25r35,4r-74,55","w":180},"\u0141":{"d":"104,-240r-13,80r51,-43r-7,46r-52,43r-11,68r94,0r-7,46r-150,0r13,-81r-25,22r8,-46r25,-21r19,-114r55,0","w":174},"\u0142":{"d":"106,-144r-24,18r-21,126r-52,0r17,-99r-25,19r6,-34r24,-19r18,-107r52,0r-14,80r25,-18","w":99},"\u0160":{"d":"55,-111v-62,-40,-22,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41v21,10,35,29,35,59v0,76,-106,101,-162,61v-17,-12,-28,-30,-32,-54r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43xm65,-314r35,-4r24,25r34,-25r35,4r-74,55","w":206},"\u0161":{"d":"25,-87v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35v40,39,-3,101,-62,101v-41,0,-76,-18,-81,-54r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39xm38,-258r35,-4r24,25r34,-25r35,4r-74,55","w":167},"\u017d":{"d":"-1,-39r140,-157r-110,2r8,-46r178,0r-5,37r-141,159r123,-2r-8,46r-192,0xm71,-314r35,-4r24,25r34,-25r35,4r-74,55","w":206},"\u017e":{"d":"155,-144r-93,106r78,0r-7,38r-141,0r6,-34r94,-107r-74,0r7,-38r136,0xm43,-259r35,-4r24,25r34,-25r35,4r-74,55","w":155},"\u00a6":{"d":"70,-240r50,0r0,125r-50,0r0,-125xm70,-55r50,0r0,115r-50,0r0,-115","w":180},"\u00d0":{"d":"226,-131v0,82,-42,135,-133,131r-84,0r18,-106r-22,0r6,-36r22,0r16,-98r71,0v77,-1,106,41,106,109xm69,-43v74,10,101,-31,101,-92v0,-53,-25,-67,-75,-63r-10,56r46,0r-6,36r-46,0","w":235},"\u00f0":{"d":"11,-81v0,-64,66,-127,120,-85v-4,-19,-10,-34,-18,-42r-32,15r-11,-17r29,-13v-8,-5,-17,-9,-28,-13r6,-19v19,3,36,9,50,18r31,-14r14,16r-29,13v63,62,53,228,-54,226v-48,0,-78,-36,-78,-85xm90,-31v35,0,47,-76,31,-105v-37,-28,-57,24,-57,70v0,23,9,35,26,35","w":190},"\u00dd":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm109,-260r-9,-20r72,-42r14,29","w":190},"\u00fd":{"d":"176,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0xm85,-204r-9,-20r72,-42r14,29","w":161},"\u00de":{"d":"217,-138v0,51,-30,84,-92,80r-51,0r-10,58r-55,0r40,-240r55,0r-5,32v68,-5,118,9,118,70xm163,-134v0,-32,-35,-32,-71,-31r-11,65v39,1,82,3,82,-34","w":218},"\u00fe":{"d":"108,4v-22,0,-39,-14,-45,-30r-15,88r-52,0r51,-302r51,0r-14,86v32,-54,100,-18,100,46v0,52,-28,112,-76,112xm70,-63v-1,17,9,31,24,31v28,0,37,-57,37,-84v0,-16,-7,-29,-23,-29v-32,0,-36,55,-38,82","w":194},"\u2212":{"d":"200,-140r0,38r-178,0r0,-38r178,0","w":211},"\u00d7":{"d":"160,-198r28,27r-50,50r51,51r-27,27r-51,-51r-49,49r-28,-27r50,-49r-51,-52r27,-27r51,52","w":211},"\u00b9":{"d":"138,-126r-5,30r-108,0r5,-30r35,0r13,-76v-9,7,-26,11,-42,8r5,-28v25,0,42,-8,52,-22r28,0r-20,118r37,0","w":139},"\u00b2":{"d":"145,-197v0,47,-36,44,-84,72r74,0r-5,29r-116,0r4,-33v56,-36,75,-31,88,-68v-7,-26,-42,-21,-46,9r-34,-7v5,-59,119,-66,119,-2","w":139},"\u00b3":{"d":"114,-169v49,25,11,76,-37,76v-34,0,-58,-17,-64,-45r32,-5v4,26,53,31,53,4v0,-19,-20,-19,-42,-18r4,-27v20,1,46,0,44,-16v-2,-23,-41,-20,-46,1r-33,-8v14,-48,116,-50,116,4v0,17,-9,28,-27,34","w":139},"\u00bd":{"d":"127,-126r-5,30r-108,0r5,-30r35,0r13,-76v-9,7,-26,11,-42,8r5,-28v25,0,42,-8,52,-22r28,0r-20,118r37,0xm89,0r-32,0r173,-241r33,0xm310,-101v0,47,-36,44,-84,72r74,0r-5,29r-116,0r4,-33v56,-36,75,-31,88,-68v-7,-26,-42,-21,-46,9r-34,-7v5,-59,119,-66,119,-2","w":316},"\u00bc":{"d":"127,-125r-5,30r-108,0r5,-30r35,0r13,-76v-9,7,-26,11,-42,8r5,-28v25,0,42,-8,52,-22r28,0r-20,118r37,0xm89,0r-32,0r173,-241r33,0xm309,-60r-4,27r-23,0r-6,33r-35,0r6,-33r-66,0r4,-27r73,-86r43,0r-14,86r22,0xm253,-57r10,-61r-52,61r42,0","w":316},"\u00be":{"d":"107,-170v49,25,11,76,-37,76v-34,0,-58,-17,-64,-45r32,-5v4,26,53,31,53,4v0,-19,-20,-19,-42,-18r4,-27v20,1,46,0,44,-16v-2,-23,-41,-20,-46,1r-33,-8v14,-48,116,-50,116,4v0,17,-9,28,-27,34xm103,0r-32,0r173,-241r33,0xm312,-60r-4,27r-23,0r-6,33r-35,0r6,-33r-66,0r4,-27r73,-86r43,0r-14,86r22,0xm256,-57r10,-61r-52,61r42,0","w":316},"\u20a3":{"d":"78,-68r38,0r-6,37r-38,0r-6,31r-57,0r5,-31r-21,0r6,-37r21,0r29,-172r163,0r-8,46r-107,0r-9,53r91,0r-7,46r-90,0","w":191},"\u011e":{"d":"73,-94v0,29,14,53,45,52v23,0,38,-14,46,-43r-49,0r7,-44r101,0r-22,131r-22,0r-7,-33v-49,69,-155,23,-155,-68v0,-101,97,-189,180,-125v17,13,26,33,30,58r-52,8v-4,-29,-17,-42,-40,-42v-48,-1,-62,63,-62,106xm210,-312v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":236},"\u011f":{"d":"166,-260v-4,57,-117,71,-107,0r27,0v1,34,47,28,52,0r28,0xm42,-86v-47,-34,-2,-97,59,-97v20,0,36,5,51,14v11,-26,33,-36,61,-26r-7,34v-18,-4,-28,-6,-36,8v25,58,-38,94,-102,79v-10,4,-14,9,-14,16v0,11,11,12,26,12v60,1,86,4,93,49v-4,45,-39,61,-101,60v-49,0,-86,-4,-86,-39v0,-16,12,-28,34,-36v-29,-25,-14,-62,22,-74xm97,-99v19,0,31,-13,31,-31v0,-15,-9,-23,-26,-23v-19,-1,-31,13,-31,28v0,18,9,26,26,26xm30,16v5,25,97,24,95,-1v-2,-24,-57,-9,-76,-16v-7,1,-19,9,-19,17","w":184},"\u0130":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm104,-285v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":103},"\u015e":{"d":"158,-134v73,40,19,157,-68,138r-7,14v20,-5,37,6,38,23v0,39,-58,47,-86,25r8,-15v19,12,43,14,46,-7v2,-13,-18,-14,-32,-10r14,-32v-41,-8,-65,-31,-72,-70r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43v-60,-37,-25,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41","w":206},"\u015f":{"d":"137,-97v41,41,-4,110,-66,101r-7,14v16,-4,32,6,31,22v-1,33,-50,42,-75,22r8,-15v14,9,36,15,37,-5v1,-11,-14,-12,-26,-10r15,-30v-36,-6,-56,-23,-60,-52r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35","w":167},"\u0106":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104xm125,-260r-9,-20r72,-42r14,29","w":224},"\u0107":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33xm97,-204r-9,-20r72,-42r14,29","w":182},"\u010c":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104xm87,-314r35,-4r24,25r34,-25r35,4r-74,55","w":224},"\u010d":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33xm59,-258r35,-4r24,25r34,-25r35,4r-74,55","w":182},"\u0111":{"d":"11,-70v0,-49,25,-111,77,-111v23,0,37,11,43,33r8,-47r-46,0r4,-24r46,0r3,-21r52,0r-3,21r20,0r-4,24r-20,0r-33,195r-48,0r4,-28v-30,60,-103,28,-103,-42xm64,-64v0,18,7,30,22,31v33,4,36,-57,39,-82v2,-16,-9,-32,-25,-31v-27,0,-36,52,-36,82","w":194},"\u00ad":{"d":"85,-69r-84,0r7,-39r83,0","w":92},"\u00af":{"d":"5,-322r180,0r0,42r-180,0r0,-42","w":180},"\u00b7":{"d":"55,-62r-55,0r9,-54r55,0","w":63},"\u0100":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm193,-271r-111,0r4,-25r111,0","w":221},"\u0101":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm172,-216r-111,0r4,-25r111,0","w":194},"\u0102":{"d":"208,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm81,-95r56,0r-14,-96xm203,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":221},"\u0103":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm181,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":194},"\u0104":{"d":"217,58v-25,13,-70,10,-71,-20v0,-16,12,-29,36,-38r-31,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0r41,240v-19,9,-28,20,-28,32v0,15,21,17,35,11xm81,-95r56,0r-14,-96","w":221},"\u0105":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130v-18,10,-27,20,-27,30v0,15,17,17,32,11r3,14v-22,11,-66,11,-67,-18v0,-15,12,-28,35,-37r-26,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37","w":194},"\u0108":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104xm206,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":224},"\u0109":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33xm172,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":182},"\u010a":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104xm167,-285v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":224},"\u010b":{"d":"105,-143v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33xm137,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":182},"\u010e":{"d":"226,-130v0,81,-43,135,-133,131r-84,-1r40,-240r71,0v74,-2,106,42,106,110xm69,-43v73,10,101,-31,101,-91v0,-53,-24,-69,-75,-64xm78,-315r35,-4r24,25r34,-25r35,4r-74,55","w":235},"\u010f":{"d":"11,-70v0,-50,27,-113,78,-113v23,0,36,12,42,34r15,-91r52,0r-40,240r-48,0r4,-28v-30,60,-103,27,-103,-42xm64,-64v0,18,7,30,22,31v33,4,36,-57,39,-82v2,-17,-9,-31,-25,-31v-27,0,-36,52,-36,82xm262,-240r-40,71r-19,0r19,-71r40,0","w":235},"\u0110":{"d":"226,-131v0,82,-42,135,-133,131r-84,0r18,-106r-22,0r6,-36r22,0r16,-98r71,0v77,-1,106,41,106,109xm69,-43v74,10,101,-31,101,-92v0,-53,-25,-67,-75,-63r-10,56r46,0r-6,36r-46,0","w":235},"\u0112":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm194,-271r-111,0r4,-25r111,0","w":205},"\u0113":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm170,-216r-111,0r4,-25r111,0","w":189},"\u0114":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm202,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":205},"\u0115":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm178,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":189},"\u0116":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm161,-285v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":205},"\u0117":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm138,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":189},"\u0118":{"d":"189,58v-25,13,-70,10,-71,-20v0,-16,13,-29,37,-38r-146,0r40,-240r169,0r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46v-19,9,-28,19,-28,31v-1,15,21,18,35,12","w":205},"\u0119":{"d":"172,-53v-7,33,-61,50,-61,81v0,15,17,18,32,12r3,14v-22,10,-66,9,-66,-18v0,-13,9,-25,26,-33v-57,12,-96,-29,-96,-81v0,-53,39,-106,94,-105v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0","w":189},"\u011a":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm83,-314r35,-4r24,25r34,-25r35,4r-74,55","w":205},"\u011b":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm58,-259r35,-4r24,25r34,-25r35,4r-74,55","w":189},"\u011c":{"d":"73,-94v0,29,14,53,45,52v23,0,38,-14,46,-43r-49,0r7,-44r101,0r-22,131r-22,0r-7,-33v-49,69,-155,23,-155,-68v0,-101,97,-189,180,-125v17,13,26,33,30,58r-52,8v-4,-29,-17,-42,-40,-42v-48,-1,-62,63,-62,106xm209,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":236},"\u011d":{"d":"161,-218r-34,3r-19,-24r-29,24r-34,-3r68,-56xm42,-86v-47,-34,-2,-97,59,-97v20,0,36,5,51,14v11,-26,33,-36,61,-26r-7,34v-18,-4,-28,-6,-36,8v25,58,-38,94,-102,79v-10,4,-14,9,-14,16v0,11,11,12,26,12v60,1,86,4,93,49v-4,45,-39,61,-101,60v-49,0,-86,-4,-86,-39v0,-16,12,-28,34,-36v-29,-25,-14,-62,22,-74xm97,-99v19,0,31,-13,31,-31v0,-15,-9,-23,-26,-23v-19,-1,-31,13,-31,28v0,18,9,26,26,26xm30,16v5,25,97,24,95,-1v-2,-24,-57,-9,-76,-16v-7,1,-19,9,-19,17","w":184},"\u0120":{"d":"73,-94v0,29,14,53,45,52v23,0,38,-14,46,-43r-49,0r7,-44r101,0r-22,131r-22,0r-7,-33v-49,69,-155,23,-155,-68v0,-101,97,-189,180,-125v17,13,26,33,30,58r-52,8v-4,-29,-17,-42,-40,-42v-48,-1,-62,63,-62,106xm170,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":236},"\u0121":{"d":"128,-230v0,12,-9,21,-21,21v-12,0,-21,-9,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm42,-86v-47,-34,-2,-97,59,-97v20,0,36,5,51,14v11,-26,33,-36,61,-26r-7,34v-18,-4,-28,-6,-36,8v25,58,-38,94,-102,79v-10,4,-14,9,-14,16v0,11,11,12,26,12v60,1,86,4,93,49v-4,45,-39,61,-101,60v-49,0,-86,-4,-86,-39v0,-16,12,-28,34,-36v-29,-25,-14,-62,22,-74xm97,-99v19,0,31,-13,31,-31v0,-15,-9,-23,-26,-23v-19,-1,-31,13,-31,28v0,18,9,26,26,26xm30,16v5,25,97,24,95,-1v-2,-24,-57,-9,-76,-16v-7,1,-19,9,-19,17","w":184},"\u0122":{"d":"73,-94v0,29,14,53,45,52v23,0,38,-14,46,-43r-49,0r7,-44r101,0r-22,131r-22,0r-7,-33v-49,69,-155,23,-155,-68v0,-101,97,-189,180,-125v17,13,26,33,30,58r-52,8v-4,-29,-17,-42,-40,-42v-48,-1,-62,63,-62,106xm128,19r-41,68r-19,0r19,-68r41,0","w":236},"\u0123":{"d":"85,-207r40,-68r19,0r-18,68r-41,0xm42,-86v-47,-34,-2,-97,59,-97v20,0,36,5,51,14v11,-26,33,-36,61,-26r-7,34v-18,-4,-28,-6,-36,8v25,58,-38,94,-102,79v-10,4,-14,9,-14,16v0,11,11,12,26,12v60,1,86,4,93,49v-4,45,-39,61,-101,60v-49,0,-86,-4,-86,-39v0,-16,12,-28,34,-36v-29,-25,-14,-62,22,-74xm97,-99v19,0,31,-13,31,-31v0,-15,-9,-23,-26,-23v-19,-1,-31,13,-31,28v0,18,9,26,26,26xm30,16v5,25,97,24,95,-1v-2,-24,-57,-9,-76,-16v-7,1,-19,9,-19,17","w":184},"\u0124":{"d":"232,-240r-40,240r-53,0r17,-100r-77,0r-17,100r-53,0r40,-240r53,0r-16,94r78,0r16,-94r52,0xm206,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":231},"\u0125":{"d":"84,-153v20,-44,99,-37,97,16v-1,38,-15,97,-21,137r-51,0r19,-124v-4,-30,-45,-17,-48,5r-22,119r-51,0r40,-240r51,0xm142,-265r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":196},"\u0126":{"d":"249,-212r-6,36r-21,0r-30,176r-53,0r17,-100r-77,0r-17,100r-53,0r30,-176r-22,0r6,-36r22,0r4,-28r53,0r-5,28r78,0r5,-28r52,0r-4,28r21,0xm91,-176r-5,30r78,0r5,-30r-78,0","w":231},"\u0127":{"d":"127,-108v9,-28,-17,-43,-36,-28v-24,28,-21,92,-33,136r-51,0r32,-195r-20,0r4,-24r20,0r4,-21r51,0r-3,21r45,0r-4,24r-45,0r-7,44v19,-43,99,-40,97,14v-2,38,-15,97,-21,137r-51,0","w":196},"\u0128":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm24,-288v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":103},"\u0129":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm10,-230v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":97},"\u012a":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm135,-272r-111,0r4,-25r111,0","w":103},"\u012b":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm123,-216r-111,0r4,-25r111,0","w":97},"\u012c":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm143,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":103},"\u012d":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm134,-259v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":97},"\u012e":{"d":"72,58v-26,13,-67,9,-67,-20v0,-15,12,-28,35,-38r-31,0r41,-240r55,0r-40,240v-17,11,-26,21,-26,31v1,16,15,18,31,12","w":103},"\u012f":{"d":"101,-243r-8,51r-54,0r8,-51r54,0xm65,55v-60,28,-80,-36,-28,-55r-30,0r30,-179r54,0r-30,179v-16,12,-24,22,-24,30v0,14,14,17,26,11","w":96},"\u0132":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm246,-240v-14,68,-16,151,-40,210v-12,31,-68,41,-116,30r7,-43v26,7,60,3,64,-18r31,-179r54,0","w":242},"\u0133":{"d":"101,-243r-8,51r-54,0r8,-51r54,0xm90,-179r-30,179r-53,0r30,-179r53,0xm188,-192r-54,0r9,-51r53,0xm186,-179r-27,157v-6,67,-28,98,-99,85r6,-41v37,6,36,-18,42,-53r24,-148r54,0","w":192},"\u0134":{"d":"144,-240v-14,68,-16,151,-40,210v-12,31,-68,41,-116,30r7,-43v26,7,60,3,64,-18r31,-179r54,0xm183,-266r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":140},"\u0135":{"d":"128,-209r-35,4r-23,-24r-34,24r-35,-4r73,-55xm90,-179r-26,157v-5,68,-29,97,-100,85r6,-41v38,6,37,-17,42,-53r25,-148r53,0","w":96},"\u0136":{"d":"235,-240r-75,86r46,154r-57,0r-30,-111r-47,53r-10,58r-53,0r40,-240r53,0r-19,113r96,-113r56,0xm123,19r-41,68r-19,0r19,-68r41,0","w":225},"\u0137":{"d":"206,-179r-62,61r38,118r-54,0r-25,-82r-37,35r-8,47r-51,0r40,-240r51,0r-24,140r77,-79r55,0xm112,19r-41,68r-19,0r19,-68r41,0","w":194},"\u0138":{"d":"206,-179r-62,61r38,118r-54,0r-25,-82r-37,35r-8,47r-51,0r30,-179r51,0r-14,79r77,-79r55,0","w":194},"\u0139":{"d":"104,-240r-32,194r94,0r-7,46r-150,0r40,-240r55,0xm65,-260r-9,-20r72,-42r14,29","w":175},"\u013a":{"d":"100,-240r-40,240r-55,0r40,-240r55,0xm60,-260r-9,-20r72,-42r14,29","w":103},"\u013b":{"d":"104,-240r-32,194r94,0r-7,46r-150,0r40,-240r55,0xm102,19r-41,68r-19,0r19,-68r41,0","w":175},"\u013c":{"d":"100,-240r-40,240r-55,0r40,-240r55,0xm53,19r-41,68r-19,0r19,-68r41,0","w":103},"\u013d":{"d":"104,-240r-32,194r94,0r-7,46r-150,0r40,-240r55,0xm184,-240r-40,71r-19,0r19,-71r40,0","w":175},"\u013e":{"d":"100,-240r-40,240r-55,0r40,-240r55,0xm162,-240r-40,71r-19,0r19,-71r40,0","w":135},"\u013f":{"d":"104,-240r-32,194r94,0r-7,46r-150,0r40,-240r55,0xm167,-96r-55,0r9,-54r55,0","w":175},"\u0140":{"d":"100,-240r-40,240r-55,0r40,-240r55,0xm151,-96r-55,0r9,-54r55,0","w":103},"\u0143":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0xm130,-260r-9,-20r72,-42r14,29","w":234},"\u0144":{"d":"79,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0xm98,-204r-9,-20r72,-42r14,29","w":196},"\u0145":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0xm123,19r-41,68r-19,0r19,-68r41,0","w":234},"\u0146":{"d":"79,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0xm102,20r-41,68r-19,0r19,-68r41,0","w":196},"\u0147":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0xm87,-314r35,-4r24,25r34,-25r35,4r-74,55","w":234},"\u0148":{"d":"79,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0xm59,-259r35,-4r24,25r34,-25r35,4r-74,55","w":196},"\u0149":{"d":"94,-239r-8,47r-42,55r-19,0r34,-50r-22,0r8,-52r49,0xm144,-145v19,-53,102,-47,102,11v0,40,-15,93,-21,134r-52,0r20,-124v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0","w":261},"\u014a":{"d":"163,-140v19,-49,-22,-78,-53,-50v-40,36,-32,128,-48,190r-53,0r40,-240r49,0r-8,46v17,-33,40,-50,69,-50v54,0,68,47,56,109r-29,154v-11,40,-51,55,-102,43r6,-41v50,9,50,-24,58,-73","w":231},"\u014b":{"d":"79,-145v19,-53,100,-47,102,11v-20,81,4,226,-117,197r6,-41v39,3,35,-9,43,-53r15,-93v-4,-33,-43,-16,-48,4v-9,34,-15,82,-22,120r-51,0r30,-179r48,0","w":196},"\u014c":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm200,-271r-111,0r4,-25r111,0","w":231},"\u014d":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm171,-216r-111,0r4,-25r111,0","w":192},"\u014e":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm204,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":231},"\u014f":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm173,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":192},"\u0150":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm110,-260r-10,-17r58,-45r15,24xm171,-260r-10,-17r58,-45r16,24","w":231},"\u0151":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm76,-204r-10,-17r58,-45r15,24xm137,-204r-10,-17r58,-45r16,24","w":192},"\u0154":{"d":"229,-171v0,33,-21,60,-54,67r30,104r-56,0r-25,-95r-45,0r-16,95r-54,0r40,-240r89,0v58,-3,91,21,91,69xm173,-170v0,-35,-43,-27,-78,-28r-10,61v40,-1,88,7,88,-33xm121,-260r-9,-20r72,-42r14,29","w":236},"\u0155":{"d":"128,-130v-64,2,-54,75,-68,130r-53,0r30,-179r49,0r-6,41v12,-26,19,-43,53,-43xm76,-204r-9,-20r72,-42r14,29","w":126},"\u0156":{"d":"229,-171v0,33,-21,60,-54,67r30,104r-56,0r-25,-95r-45,0r-16,95r-54,0r40,-240r89,0v58,-3,91,21,91,69xm173,-170v0,-35,-43,-27,-78,-28r-10,61v40,-1,88,7,88,-33xm123,18r-41,68r-19,0r19,-68r41,0","w":236},"\u0157":{"d":"128,-130v-64,2,-54,75,-68,130r-53,0r30,-179r49,0r-6,41v12,-26,19,-43,53,-43xm52,19r-41,68r-19,0r19,-68r41,0","w":126},"\u0158":{"d":"229,-171v0,33,-21,60,-54,67r30,104r-56,0r-25,-95r-45,0r-16,95r-54,0r40,-240r89,0v58,-3,91,21,91,69xm173,-170v0,-35,-43,-27,-78,-28r-10,61v40,-1,88,7,88,-33xm80,-314r35,-4r24,25r34,-25r35,4r-74,55","w":236},"\u0159":{"d":"128,-130v-64,2,-54,75,-68,130r-53,0r30,-179r49,0r-6,41v12,-26,19,-43,53,-43xm35,-259r35,-4r24,25r34,-25r35,4r-74,55","w":126},"\u015a":{"d":"55,-111v-62,-40,-22,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41v21,10,35,29,35,59v0,76,-106,101,-162,61v-17,-12,-28,-30,-32,-54r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43xm104,-260r-9,-20r72,-42r14,29","w":206},"\u015b":{"d":"25,-87v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35v40,39,-3,101,-62,101v-41,0,-76,-18,-81,-54r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39xm79,-203r-9,-20r72,-42r14,29","w":167},"\u015c":{"d":"55,-111v-62,-40,-22,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41v21,10,35,29,35,59v0,76,-106,101,-162,61v-17,-12,-28,-30,-32,-54r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43xm185,-265r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":206},"\u015d":{"d":"25,-87v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35v40,39,-3,101,-62,101v-41,0,-76,-18,-81,-54r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39xm159,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":167},"\u0162":{"d":"194,-194r-61,0r-32,194r-55,0r32,-194r-60,0r7,-46r176,0xm91,19r-41,68r-19,0r19,-68r41,0","w":176},"\u0163":{"d":"130,-138r-42,0r-14,87v-2,16,27,17,41,13r-6,39v-42,8,-93,2,-89,-40v2,-25,13,-71,18,-99r-28,0r7,-41r30,0r12,-49r45,-1r-8,50r41,0xm80,19r-41,68r-19,0r19,-68r41,0","w":129},"\u0164":{"d":"194,-194r-61,0r-32,194r-55,0r32,-194r-60,0r7,-46r176,0xm62,-315r35,-4r24,25r34,-25r35,4r-74,55","w":176},"\u0165":{"d":"130,-138r-42,0r-14,87v-2,16,27,17,41,13r-6,39v-42,8,-93,2,-89,-40v2,-25,13,-71,18,-99r-28,0r7,-41r30,0r12,-49r45,-1r-8,50r41,0xm177,-270r-40,71r-19,0r19,-71r40,0","w":147},"\u0166":{"d":"172,-157r-6,36r-45,0r-20,121r-55,0r20,-121r-46,0r6,-36r46,0r6,-37r-60,0r7,-46r176,0r-7,46r-61,0r-6,37r45,0","w":176},"\u0167":{"d":"119,-111r-4,24r-36,0v-2,22,-16,53,18,51v8,0,13,-1,18,-2r-6,39v-42,8,-89,3,-89,-40v0,-8,5,-31,7,-48r-23,0r4,-24r24,0r6,-27r-28,0r7,-41r30,0r12,-49r45,-1r-8,50r41,0r-7,41r-42,0r-5,27r36,0","w":129},"\u0168":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm98,-288v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":231},"\u0169":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm60,-231v25,-27,54,-19,81,-6v8,0,17,-5,27,-14r11,19v-25,30,-53,23,-83,9v-7,0,-16,4,-25,11","w":193},"\u016a":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm203,-272r-111,0r4,-25r111,0","w":231},"\u016b":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm174,-216r-111,0r4,-25r111,0","w":193},"\u016c":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm218,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":231},"\u016d":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm181,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":193},"\u016e":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm183,-288v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm135,-288v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":231},"\u016f":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm153,-233v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm105,-233v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13","w":193},"\u0170":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0r-34,187v-11,36,-46,55,-94,55v-61,0,-97,-32,-87,-93r25,-149r60,0xm112,-261r-10,-17r58,-45r15,24xm173,-261r-10,-17r58,-45r16,24","w":231},"\u0171":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179r-48,0r6,-32v-14,24,-33,36,-55,36xm80,-205r-10,-17r58,-45r15,24xm141,-205r-10,-17r58,-45r16,24","w":193},"\u0172":{"d":"83,-100v-22,56,53,76,76,35v10,-46,21,-123,30,-175r48,0v-15,66,-18,143,-41,202v-10,25,-62,40,-62,69v0,15,22,17,35,10r2,16v-24,12,-70,11,-70,-20v0,-14,10,-26,30,-36v-70,8,-121,-20,-109,-92r25,-149r60,0","w":231},"\u0173":{"d":"60,4v-81,0,-26,-122,-23,-183r51,0r-20,126v6,30,38,11,44,-7v10,-31,16,-82,23,-119r52,0r-30,179v-18,10,-27,20,-27,30v0,15,17,17,32,11r2,14v-21,11,-66,11,-66,-18v0,-15,12,-28,35,-37r-24,0r6,-32v-14,24,-33,36,-55,36","w":193},"\u0174":{"d":"341,-240r-99,240r-51,0r-22,-167r-64,167r-51,0r-29,-240r55,0r15,166r64,-166r50,0r20,166r63,-166r49,0xm249,-265r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":319},"\u0175":{"d":"271,-179r-81,179r-46,0r-13,-115r-45,115r-45,0r-26,-179r53,0r14,112r42,-112r48,0r11,112r48,-112r40,0xm210,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":259},"\u0176":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm187,-265r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":190},"\u0177":{"d":"176,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0xm165,-209r-35,4r-24,-24r-34,24r-35,-4r74,-55","w":161},"\u0179":{"d":"-1,-39r140,-157r-110,2r8,-46r178,0r-5,37r-141,159r123,-2r-8,46r-192,0xm110,-260r-9,-20r72,-42r14,29","w":206},"\u017a":{"d":"155,-144r-93,106r78,0r-7,38r-141,0r6,-34r94,-107r-74,0r7,-38r136,0xm80,-205r-9,-20r72,-42r14,29","w":155},"\u017b":{"d":"-1,-39r140,-157r-110,2r8,-46r178,0r-5,37r-141,159r123,-2r-8,46r-192,0xm152,-285v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":206},"\u017c":{"d":"155,-144r-93,106r78,0r-7,38r-141,0r6,-34r94,-107r-74,0r7,-38r136,0xm121,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20","w":155},"\u017f":{"d":"110,0r-52,0v15,-72,18,-161,43,-222v10,-25,48,-33,86,-27r-3,41v-29,-3,-40,1,-45,29","w":211},"\u01fa":{"d":"94,-295r-8,-20r73,-38r13,29xm136,-297v34,0,57,40,33,65r39,232r-57,0r-8,-53r-80,0r-23,53r-52,0r112,-236v-20,-27,4,-61,36,-61xm119,-258v0,10,7,17,17,17v9,0,17,-8,17,-16v0,-10,-7,-17,-17,-17v-9,0,-17,7,-17,16xm81,-95r56,0r-12,-103","w":221},"\u01fb":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37xm153,-226v0,18,-17,33,-35,33v-19,0,-33,-17,-33,-33v0,-16,15,-34,34,-33v18,1,34,15,34,33xm105,-226v0,7,7,13,14,13v7,0,14,-6,14,-13v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13xm105,-267r-9,-20r72,-42r14,29","w":194},"\u01fc":{"d":"308,-194r-107,0r-8,48r89,0r-7,44r-89,0r-10,56r109,0r-8,46r-161,0r10,-60r-59,0r-36,60r-48,0r145,-240r187,0xm90,-102r43,0r16,-96xm205,-260r-9,-20r72,-42r14,29","w":303},"\u01fd":{"d":"163,-166v57,-44,150,2,128,86r-119,0v-14,52,54,65,67,19r45,8v-21,69,-123,79,-155,17v-20,52,-125,55,-125,-10v0,-60,55,-61,125,-66v7,-20,2,-38,-21,-38v-19,0,-31,9,-37,27r-48,-7v14,-51,96,-70,140,-36xm242,-110v5,-23,-7,-39,-27,-40v-20,0,-33,14,-39,40r66,0xm59,-50v0,13,9,21,21,21v22,0,36,-19,44,-58v-44,1,-65,14,-65,37xm142,-205r-9,-20r72,-42r14,29","w":302},"\u01fe":{"d":"41,-25v-72,-89,19,-272,137,-205r20,-29r33,0r-31,46v69,87,-13,266,-137,205r-17,27r-34,0xm152,-193v-60,-29,-91,61,-78,119xm89,-47v62,29,87,-58,79,-119xm111,-260r-9,-20r72,-42r14,29","w":231},"\u01ff":{"d":"34,-18v-64,-67,13,-207,110,-155r16,-22r27,0r-26,36v57,68,-14,202,-110,154r-15,21r-27,0xm102,-149v-32,-1,-40,57,-37,87r56,-79v-4,-5,-11,-8,-19,-8xm73,-36v42,24,57,-37,55,-78xm85,-204r-9,-20r72,-42r14,29","w":192},"\u0384":{"d":"-2,-257r27,17r-61,68r-16,-12","w":180},"\u0385":{"d":"152,-316r17,23r-57,37r-11,-16xm163,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm105,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":180},"\u0386":{"d":"51,-257r27,17r-61,68r-16,-12xm205,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm78,-95r56,0r-14,-96","w":216},"\u0387":{"d":"55,-62r-55,0r9,-54r55,0","w":63},"\u0388":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm9,-257r27,17r-61,68r-16,-12","w":204},"\u0389":{"d":"232,-240r-40,240r-53,0r17,-100r-77,0r-17,100r-53,0r40,-240r53,0r-16,94r78,0r16,-94r52,0xm8,-256r27,17r-61,68r-16,-12","w":231},"\u038a":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm8,-257r27,17r-61,68r-16,-12","w":103},"\u038c":{"d":"226,-137v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm131,-199v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54xm29,-257r27,17r-61,68r-16,-12","w":231},"\u038e":{"d":"227,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm-19,-257r27,17r-61,68r-16,-12","w":190},"\u038f":{"d":"132,-202v-66,-3,-81,129,-30,156r-8,46r-97,0r7,-46r61,0v-92,-46,-41,-207,66,-199v61,4,101,31,102,93v0,52,-24,87,-70,106r64,0r-8,46r-99,0r7,-46v31,-14,49,-53,49,-96v0,-35,-13,-59,-44,-60xm18,-257r27,17r-61,68r-16,-12","w":238},"\u0390":{"d":"111,-316r17,23r-57,37r-11,-16xm122,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm64,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20xm90,-179r-30,179r-53,0r30,-179r53,0","w":180},"\u0391":{"d":"206,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm79,-95r56,0r-14,-96","w":216},"\u0392":{"d":"220,-71v0,47,-33,71,-92,71r-119,0r40,-240v77,3,183,-19,181,60v0,31,-18,50,-54,57v29,8,44,25,44,52xm88,-144v38,-1,84,9,84,-29v0,-31,-42,-27,-74,-27xm162,-73v2,-36,-44,-29,-80,-30r-10,60v39,0,89,6,90,-30","w":234},"\u0393":{"d":"9,0r40,-240r142,0r-7,46r-90,0r-32,194r-53,0","w":165},"\u0394":{"d":"-19,0r112,-240r66,0r39,240r-217,0xm52,-44r84,0r-19,-149r-3,0","w":203},"\u0395":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0","w":204},"\u0396":{"d":"-1,-39r140,-157r-110,2r8,-46r178,0r-5,37r-141,159r123,-2r-8,46r-192,0","w":206},"\u0397":{"d":"232,-240r-40,240r-53,0r17,-100r-77,0r-17,100r-53,0r40,-240r53,0r-16,94r78,0r16,-94r52,0","w":231},"\u0398":{"d":"18,-98v0,-76,53,-147,127,-147v60,0,98,44,98,106v0,76,-52,144,-128,144v-60,0,-97,-42,-97,-103xm188,-137v0,-34,-16,-63,-48,-63v-42,0,-67,50,-67,98v0,36,16,62,48,62v42,0,68,-50,67,-97xm164,-142r-5,39r-61,0r4,-39r62,0","w":247},"\u0399":{"d":"104,-240r-40,240r-55,0r40,-240r55,0","w":103},"\u039a":{"d":"235,-240r-75,86r46,154r-57,0r-30,-111r-47,53r-10,58r-53,0r40,-240r53,0r-19,113r96,-113r56,0","w":225},"\u039b":{"d":"27,0r-51,0r110,-240r66,0r33,240r-58,0r-20,-194","w":188},"\u039c":{"d":"311,-241r-40,240r-56,0r33,-201r-96,201r-32,0r-33,-203r-34,203r-45,0r40,-240r84,0r22,147r70,-147r87,0","w":308},"\u039d":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0","w":234},"\u039e":{"d":"30,-196r7,-44r164,0r-7,44r-164,0xm37,-102r7,-42r119,0r-7,42r-119,0xm-3,0r8,-46r164,0r-8,46r-164,0","w":188},"\u039f":{"d":"225,-138v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-200v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54","w":231},"\u03a0":{"d":"9,0r40,-240r176,0r-40,240r-53,0r33,-196r-70,0r-33,196r-53,0","w":223},"\u03a1":{"d":"222,-171v-2,53,-31,85,-92,81r-51,0r-15,90r-55,0r40,-240v82,0,177,-13,173,69xm169,-167v0,-32,-36,-31,-72,-30r-11,65v40,1,83,3,83,-35","w":216},"\u03a3":{"d":"-4,0r7,-44r82,-79r-51,-73r7,-44r158,0r-7,44r-97,0r48,69r-83,81r113,0r-7,46r-170,0","w":185},"\u03a4":{"d":"194,-194r-61,0r-32,194r-55,0r32,-194r-60,0r7,-46r176,0","w":176},"\u03a5":{"d":"227,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0","w":191},"\u03a6":{"d":"179,-216v47,5,81,35,80,87v-1,65,-44,105,-112,106r-5,30r-52,0r5,-31v-86,-5,-96,-104,-50,-157v18,-21,45,-33,82,-36r5,-30r53,0xm121,-178v-59,7,-74,97,-19,115xm154,-61v57,2,78,-101,19,-115","w":265},"\u03a7":{"d":"229,-240r-84,112r58,128r-60,0r-39,-91r-63,91r-55,0r97,-128r-52,-112r60,0r33,75r51,-75r54,0","w":218},"\u03a8":{"d":"117,-43v-79,2,-103,-47,-82,-126r12,-71r52,0r-17,118v0,26,15,32,42,34r26,-152r53,0r-26,152v81,4,58,-91,77,-152r53,0v-18,94,-12,206,-137,197r-7,43r-53,0","w":301},"\u03a9":{"d":"132,-202v-66,-3,-81,129,-30,156r-8,46r-97,0r7,-46r61,0v-92,-46,-41,-207,66,-199v61,4,101,31,102,93v0,52,-24,87,-70,106r64,0r-8,46r-99,0r7,-46v31,-14,49,-53,49,-96v0,-35,-13,-59,-44,-60","w":238},"\u03aa":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm134,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm76,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":103},"\u03ab":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm176,-285v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm118,-285v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":190},"\u03ac":{"d":"104,-184v31,0,44,16,53,39r15,-34r55,0r-46,85r26,94r-57,0r-9,-41v-35,74,-129,52,-129,-33v0,-57,36,-110,92,-110xm65,-73v0,33,27,61,48,31v7,-9,14,-26,24,-49v-9,-39,-6,-53,-32,-58v-26,1,-40,43,-40,76xm97,-204r-9,-20r72,-42r14,29","w":224},"\u03ad":{"d":"73,-126v0,19,14,18,40,19r-5,31v-31,-1,-47,1,-47,26v0,14,8,21,24,21v17,0,29,-9,35,-27r46,7v-9,67,-158,78,-159,2v0,-25,15,-41,45,-48v-19,-10,-30,-16,-30,-37v0,-35,35,-52,76,-52v46,0,71,17,75,50r-47,8v-1,-16,-10,-23,-26,-23v-17,-1,-27,9,-27,23xm84,-204r-9,-20r72,-42r14,29","w":170},"\u03ae":{"d":"79,-149v23,-45,108,-50,108,7v0,70,-22,137,-32,204r-52,0r31,-186v1,-26,-32,-25,-44,-10v-24,31,-21,90,-32,134r-51,0r30,-179r47,0xm98,-205r-9,-20r72,-42r14,29","w":200},"\u03af":{"d":"38,-204r-9,-20r72,-42r14,29xm90,-179r-30,179r-53,0r30,-179r53,0","w":180},"\u03b0":{"d":"161,-28v-23,46,-150,51,-145,-21v3,-44,14,-88,20,-130r51,0r-20,132v-4,22,39,21,45,8v14,-32,20,-98,29,-140r51,0v-9,48,-14,114,-31,151xm162,-317r17,23r-57,37r-11,-16xm173,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm115,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":196},"\u03b1":{"d":"104,-184v31,0,44,16,53,39r15,-34r55,0r-46,85r26,94r-57,0r-9,-41v-35,74,-129,52,-129,-33v0,-57,36,-110,92,-110xm65,-73v0,33,27,61,48,31v7,-9,14,-26,24,-49v-9,-39,-6,-53,-32,-58v-26,1,-40,43,-40,76","w":224},"\u03b2":{"d":"143,-130v85,16,57,135,-24,135v-23,0,-42,-8,-56,-23r-14,80r-51,0v17,-87,26,-190,50,-268v17,-56,147,-53,147,17v0,32,-17,52,-52,59xm141,-82v-3,-22,-9,-32,-36,-31r5,-29v22,0,33,-15,33,-45v0,-28,-37,-33,-45,-15v-17,37,-22,111,-31,158v26,34,79,6,74,-38","w":207},"\u03b3":{"d":"29,62r10,-62r-28,-179r54,0r16,117r58,-117r44,0r-92,179r-10,62r-52,0","w":162},"\u03b4":{"d":"12,-71v0,-54,34,-87,86,-91r-50,-44r6,-34r133,0r-7,38r-68,0v41,28,76,52,78,109v1,57,-38,98,-96,98v-50,0,-82,-28,-82,-76xm95,-30v33,1,41,-36,41,-68v0,-24,-9,-36,-28,-36v-28,0,-42,23,-42,68v0,24,9,36,29,36","w":201},"\u03b5":{"d":"73,-126v0,19,14,18,40,19r-5,31v-31,-1,-47,1,-47,26v0,14,8,21,24,21v17,0,29,-9,35,-27r46,7v-9,67,-158,78,-159,2v0,-25,15,-41,45,-48v-19,-10,-30,-16,-30,-37v0,-35,35,-52,76,-52v46,0,71,17,75,50r-47,8v-1,-16,-10,-23,-26,-23v-17,-1,-27,9,-27,23","w":170},"\u03b6":{"d":"10,-55v0,-69,44,-109,98,-147r-69,0r7,-38r116,0r-4,33v-45,22,-88,82,-93,138v-4,48,70,12,70,62v0,19,-8,42,-24,69r-41,-6v11,-18,16,-31,16,-41v0,-12,-7,-14,-22,-15v-36,-1,-54,-20,-54,-55","w":149},"\u03b7":{"d":"79,-149v23,-45,108,-50,108,7v0,70,-22,137,-32,204r-52,0r31,-186v1,-26,-32,-25,-44,-10v-24,31,-21,90,-32,134r-51,0r30,-179r47,0","w":200},"\u03b8":{"d":"18,-92v0,-75,31,-154,103,-153v53,1,76,39,76,98v0,74,-30,153,-103,152v-53,-1,-76,-38,-76,-97xm144,-140v3,-32,1,-70,-26,-70v-22,0,-36,23,-43,70r69,0xm71,-109v-5,33,-2,79,26,79v22,0,37,-26,44,-79r-70,0","w":201},"\u03b9":{"d":"90,-179r-30,179r-53,0r30,-179r53,0","w":97},"\u03ba":{"d":"139,-118r39,118r-54,0r-26,-82r-30,27r-10,55r-51,0r30,-179r51,0r-12,74r73,-74r55,0","w":190},"\u03bb":{"d":"-17,0r79,-165r-19,-75r52,0r58,240r-51,0r-26,-114r-52,114r-41,0","w":154},"\u03bc":{"d":"72,-85v-5,29,-7,53,18,55v28,-4,32,-21,38,-55r16,-94r52,0r-30,179r-42,0r4,-28v-12,39,-61,48,-66,3r-15,87r-51,0r40,-241r52,0","w":202},"\u03bd":{"d":"177,-179r-88,179r-43,0r-36,-179r55,0r19,111r52,-111r41,0","w":158},"\u03be":{"d":"62,-66v0,46,88,7,88,60v0,17,-8,42,-23,72r-40,-11v10,-24,21,-35,9,-50v-43,-8,-91,-10,-88,-59v2,-44,23,-59,63,-73v-53,-12,-47,-64,10,-75r-46,0r6,-38r135,0r-6,38v-41,-2,-78,-2,-81,33v-2,24,29,28,59,26r-6,37v-43,-1,-79,2,-80,40","w":164},"\u03bf":{"d":"10,-76v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm90,-30v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34","w":192},"\u03c0":{"d":"12,0r24,-141r-21,0r6,-38r197,0r-7,38r-20,0r-24,141r-52,0r24,-141r-51,0r-24,141r-52,0","w":209},"\u03c1":{"d":"192,-100v0,57,-32,106,-87,105v-22,0,-37,-9,-46,-25r-14,82r-51,0v27,-95,-1,-242,115,-246v54,-2,83,31,83,84xm97,-30v34,0,42,-44,42,-80v0,-26,-9,-39,-28,-39v-35,0,-42,46,-42,83v0,24,9,36,28,36","w":202},"\u03c2":{"d":"64,-88v0,70,97,26,95,87v0,16,-6,39,-19,67r-43,-9v12,-21,26,-53,-7,-56v-50,-4,-77,-25,-81,-78v-5,-77,87,-141,149,-88v13,11,18,28,18,46r-48,8v0,-26,-9,-38,-26,-38v-26,1,-38,30,-38,61","w":178},"\u03c3":{"d":"11,-75v0,-70,49,-123,129,-104r71,0r-6,38r-37,0v50,58,-1,146,-77,146v-51,0,-80,-29,-80,-80xm94,-30v35,-1,41,-42,42,-80v0,-26,-10,-38,-29,-38v-34,0,-42,39,-43,79v0,26,10,39,30,39","w":207},"\u03c4":{"d":"33,0r23,-141r-48,0r6,-38r148,0r-6,38r-48,0r-24,141r-51,0","w":145},"\u03c5":{"d":"161,-28v-23,46,-150,51,-145,-21v3,-44,14,-88,20,-130r51,0r-20,132v-4,22,39,21,45,8v14,-32,20,-98,29,-140r51,0v-9,48,-14,114,-31,151","w":196},"\u03c6":{"d":"120,-183v74,-9,125,20,125,83v0,59,-42,102,-108,106r-10,56r-48,0r10,-57v-111,-5,-88,-163,-9,-180r8,38v-32,21,-38,96,7,105xm143,-31v54,-3,72,-101,20,-117"},"\u03c7":{"d":"56,-68r-39,-111r54,0r27,80r49,-80r45,0r-79,119r44,122r-54,0r-30,-93r-59,93r-46,0","w":177},"\u03c8":{"d":"87,62r10,-58v-66,0,-87,-30,-77,-88r16,-95r51,0r-19,121v1,20,12,25,35,25r24,-146r48,0r-24,146v42,-1,41,-11,48,-50r16,-96r52,0r-16,95v-9,67,-30,89,-106,88r-10,58r-48,0","w":272},"\u03c9":{"d":"127,-29v-28,59,-117,37,-117,-35v0,-46,20,-86,59,-120r35,18v-27,33,-41,68,-41,106v0,36,32,36,39,11v5,-17,11,-60,15,-84r47,0v-3,25,-10,51,-11,78v0,16,6,24,18,24v42,-2,40,-102,11,-135r39,-18v56,47,50,194,-44,189v-31,-1,-40,-10,-50,-34","w":267},"\u03ca":{"d":"90,-179r-30,179r-53,0r30,-179r53,0xm121,-230v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm63,-230v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":97},"\u03cb":{"d":"161,-28v-23,46,-150,51,-145,-21v3,-44,14,-88,20,-130r51,0r-20,132v-4,22,39,21,45,8v14,-32,20,-98,29,-140r51,0v-9,48,-14,114,-31,151xm172,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm114,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":196},"\u03cc":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34xm90,-204r-9,-20r72,-42r14,29","w":192},"\u03cd":{"d":"161,-28v-23,46,-150,51,-145,-21v3,-44,14,-88,20,-130r51,0r-20,132v-4,22,39,21,45,8v14,-32,20,-98,29,-140r51,0v-9,48,-14,114,-31,151xm98,-205r-9,-20r72,-42r14,29","w":196},"\u03ce":{"d":"127,-29v-28,59,-117,37,-117,-35v0,-46,20,-86,59,-120r35,18v-27,33,-41,68,-41,106v0,36,32,36,39,11v5,-17,11,-60,15,-84r47,0v-3,25,-10,51,-11,78v0,16,6,24,18,24v42,-2,40,-102,11,-135r39,-18v56,47,50,194,-44,189v-31,-1,-40,-10,-50,-34xm133,-205r-9,-20r72,-42r14,29","w":267},"\u0401":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0xm190,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm132,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":205},"\u0402":{"d":"20,0r33,-198r-38,0r7,-42r173,0r-7,42r-82,0r-11,65v26,-40,120,-45,118,16v-1,30,-17,153,-43,162v-15,12,-37,17,-65,17r4,-36v36,-6,32,-17,42,-63v6,-29,8,-50,8,-62v0,-16,-9,-24,-26,-24v-57,-2,-49,76,-60,123r-53,0","w":226},"\u0403":{"d":"9,0r40,-240r142,0r-7,46r-90,0r-32,194r-53,0xm102,-260r-9,-20r72,-42r14,29","w":165,"k":{"\u045e":-5,"\u0459":24,"\u0454":19,"\u044f":12,"\u044e":5,"\u044a":-8,"\u0446":7,"\u0444":23,"\u0443":-4,"\u0442":-5,"\u0441":18,"\u0440":5,"\u043f":7,"\u043e":18,"\u043d":7,"\u043c":7,"\u043b":24,"\u043a":7,"\u0438":7,"\u0437":10,"\u0436":-2,"\u0435":18,"\u0434":27,"\u0432":7,"\u0430":17,"\u0427":-7,"\u0424":7,"\u0423":-14,"\u0422":-12,"\u041b":11,"\u0414":18,"\u040e":-14,"\u040b":-13,"\u0409":10}},"\u0404":{"d":"17,-101v-1,-76,41,-144,117,-144v48,0,80,22,93,66r-50,13v-6,-23,-21,-34,-45,-34v-32,0,-51,19,-57,58r84,0r-6,37r-82,0v-6,36,11,65,45,65v24,0,42,-13,53,-38r48,10v-14,42,-44,73,-100,73v-67,0,-98,-41,-100,-106","w":219},"\u0405":{"d":"58,-111v-62,-40,-22,-133,55,-133v46,0,76,21,90,63r-49,11v-4,-36,-74,-41,-74,-5v0,33,64,26,81,41v21,10,35,29,35,59v0,76,-106,101,-162,61v-17,-12,-28,-30,-32,-54r51,-7v1,41,84,49,87,7v2,-32,-58,-28,-82,-43","w":205},"\u0406":{"d":"104,-240r-40,240r-55,0r40,-240r55,0","w":103},"\u0407":{"d":"104,-240r-40,240r-55,0r40,-240r55,0xm131,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm73,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":103},"\u0408":{"d":"144,-240v-14,68,-16,151,-40,210v-12,31,-68,41,-116,30r7,-43v26,7,60,3,64,-18r31,-179r54,0","w":140},"\u0409":{"d":"299,-87v-2,55,-34,87,-98,87r-80,0r-9,-195r-2,0r-81,195r-49,0r103,-240r80,0r6,89v69,-2,132,-4,130,64xm173,-109r5,65v37,2,66,-3,66,-38v0,-31,-39,-27,-71,-27","w":306,"k":{"\u044a":1,"\u042a":10,"\u0427":3,"\u0423":4,"\u0422":16,"\u040e":4,"\u040b":7}},"\u040a":{"d":"335,-87v-1,55,-34,87,-98,87r-100,0r17,-104r-75,0r-17,104r-53,0r40,-240r53,0r-16,94r75,0r16,-94r53,0r-15,89v66,-3,122,0,120,64xm197,-44v41,1,83,4,83,-38v0,-32,-40,-27,-72,-27","w":342,"k":{"\u044a":1,"\u042a":10,"\u0427":3,"\u0423":4,"\u0422":16,"\u040e":4,"\u040b":7}},"\u040b":{"d":"106,-198r-11,64v28,-42,122,-43,117,24v-2,36,-12,75,-17,110r-52,0r16,-101v0,-15,-9,-22,-27,-22v-61,-1,-45,77,-59,123r-53,0r33,-198r-38,0r7,-42r173,0r-7,42r-82,0","w":230},"\u040c":{"d":"235,-240r-75,86r46,154r-57,0r-30,-111r-47,53r-10,58r-53,0r40,-240r53,0r-19,113r96,-113r56,0xm123,-260r-9,-20r72,-42r14,29","w":225,"k":{"\u045e":13,"\u0454":10,"\u0447":16,"\u0444":12,"\u0443":15,"\u0442":13,"\u0441":10,"\u043e":10,"\u0437":4,"\u0435":10,"\u0431":8,"\u0430":5,"\u0424":14,"\u0421":10,"\u041e":10,"\u0417":5,"\u0404":10}},"\u040e":{"d":"77,-72r-59,-168r57,0r35,110r61,-110r50,0r-101,178v-26,46,-44,65,-112,62r7,-44v33,2,53,-5,62,-28xm191,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":187,"k":{"\u0459":15,"\u0454":13,"\u044f":9,"\u044e":7,"\u0446":7,"\u0444":14,"\u0442":-5,"\u0441":13,"\u0440":7,"\u043f":7,"\u043e":12,"\u043d":7,"\u043c":7,"\u043b":15,"\u043a":7,"\u0438":7,"\u0437":6,"\u0436":-2,"\u0435":13,"\u0434":18,"\u0431":6,"\u0430":12,"\u042f":-1,"\u0427":-10,"\u0424":8,"\u0422":-16,"\u0421":5,"\u041e":4,"\u041b":7,"\u0417":-4,"\u0414":13,"\u0410":13,"\u040e":-19,"\u040b":-18,"\u0409":8,"\u0404":3}},"\u040f":{"d":"69,-44r77,0r33,-196r53,0r-41,240r-71,0r-9,51r-39,0r8,-51r-71,0r40,-240r53,0","w":230},"\u0410":{"d":"205,0r-57,0r-8,-53r-80,0r-23,53r-52,0r114,-240r65,0xm78,-95r56,0r-14,-96","w":216,"k":{"\u045e":6,"\u0459":-15,"\u044a":1,"\u0447":7,"\u0444":2,"\u0443":6,"\u0442":5,"\u043b":-15,"\u0437":-2,"\u042a":7,"\u0427":9,"\u0424":9,"\u0423":-2,"\u0422":13,"\u0421":6,"\u041e":5,"\u041b":-18,"\u0417":-1,"\u040e":-2,"\u040b":4,"\u0409":-16,"\u0404":5,";":-4,":":-4,".":-12,"-":-10,",":-11}},"\u0411":{"d":"207,-84v-1,52,-36,84,-93,84r-105,0r40,-240r158,0r-7,42r-105,0r-9,54v64,-2,121,0,121,60xm69,-44v38,0,81,5,81,-34v0,-29,-40,-25,-71,-25","w":219,"k":{"\u045e":7,"\u044a":4,"\u0443":7,"\u0442":7,"\u0436":3,"\u0428":2,"\u0427":6,"\u0423":4,"\u0422":7,"\u0416":1,"\u040e":4,"\u040b":2}},"\u0412":{"d":"220,-71v0,47,-33,71,-92,71r-119,0r40,-240v77,3,183,-19,181,60v0,31,-18,50,-54,57v29,8,44,25,44,52xm88,-144v38,-1,84,9,84,-29v0,-31,-42,-27,-74,-27xm162,-73v2,-36,-44,-29,-80,-30r-10,60v39,0,89,6,90,-30","w":234,"k":{"\u045e":-1,"\u044a":-6,"\u0447":2,"\u0443":-1,"\u0442":-4,"\u0427":2,"\u0423":3,"\u040e":3}},"\u0413":{"d":"9,0r40,-240r135,0r-8,46r-82,0r-32,194r-53,0","w":158,"k":{"\u045e":-5,"\u0459":22,"\u0454":19,"\u044f":12,"\u044e":5,"\u044a":-8,"\u0446":7,"\u0444":23,"\u0443":-4,"\u0442":-5,"\u0441":18,"\u0440":5,"\u043f":7,"\u043e":18,"\u043d":7,"\u043c":7,"\u043b":22,"\u043a":7,"\u0438":7,"\u0437":10,"\u0436":-2,"\u0435":18,"\u0434":25,"\u0432":7,"\u0430":17,"\u0427":-7,"\u0424":7,"\u0423":-14,"\u0422":-12,"\u041b":11,"\u0414":18,"\u040e":-14,"\u040b":-13,"\u0409":10,";":7,":":7,".":25,"-":16,",":25}},"\u0414":{"d":"14,-44r83,-196r86,0r17,196r21,0r-16,94r-34,0r2,-50r-146,0r-15,50r-34,0r16,-94r20,0xm63,-44r78,0r-8,-156r-9,0","w":229},"\u0415":{"d":"218,-240r-7,46r-113,0r-8,49r94,0r-7,43r-95,0r-9,56r115,0r-8,46r-171,0r40,-240r169,0","w":204,"k":{"\u0424":5}},"\u0416":{"d":"233,-133r65,133r-57,0r-52,-107r-12,4r-17,103r-51,0r17,-103r-11,-4r-87,107r-54,0r105,-124r-55,-116r55,0r45,100r7,3r18,-103r51,0r-17,103r8,-3r78,-100r52,0","w":295,"k":{"\u045e":5,"\u0454":5,"\u0447":12,"\u0444":6,"\u0443":8,"\u0442":3,"\u0441":5,"\u043e":5,"\u0437":-3,"\u0435":5,"\u0431":3,"\u0430":-3,"\u0424":9,"\u0421":4,"\u041e":4,"\u0417":-1,"\u0404":4}},"\u0417":{"d":"92,5v-55,0,-92,-24,-91,-76r49,-7v2,26,15,38,43,38v48,9,65,-66,13,-65r-19,0r6,-36v30,4,50,-10,51,-34v-6,-38,-77,-31,-81,8r-44,-7v12,-47,44,-71,96,-71v48,0,85,19,85,60v0,28,-16,47,-49,57v29,9,44,27,44,53v-1,49,-47,80,-103,80","w":208,"k":{"\u0447":1,"\u0445":2,"\u0442":-1,"\u0427":3,"\u0425":5,"\u0423":4,"\u0422":1,"\u041b":-4,"\u0417":-4,"\u0416":1,"\u0414":-5,"\u0410":1,"\u040e":4,"\u0409":-3}},"\u0418":{"d":"65,-20r-3,20r-53,0r40,-240r53,0r-28,157v35,-56,69,-87,108,-135r4,-22r53,0r-40,240r-53,0r17,-105v2,-13,6,-30,11,-50v-26,48,-74,93,-109,135","w":237},"\u0419":{"d":"65,-20r-3,20r-53,0r40,-240r53,0r-28,157v35,-56,69,-87,108,-135r4,-22r53,0r-40,240r-53,0r17,-105v2,-13,6,-30,11,-50v-26,48,-74,93,-109,135xm214,-313v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":237},"\u041a":{"d":"235,-240r-75,86r46,154r-57,0r-30,-111r-47,53r-10,58r-53,0r40,-240r53,0r-19,113r96,-113r56,0","w":225,"k":{"\u045e":13,"\u0454":10,"\u0447":16,"\u0444":12,"\u0443":15,"\u0442":13,"\u0441":10,"\u043e":10,"\u0437":4,"\u0435":10,"\u0431":8,"\u0430":5,"\u0424":14,"\u0421":10,"\u041e":10,"\u0417":5,"\u0404":10}},"\u041b":{"d":"27,0r-51,0r110,-240r66,0r33,240r-58,0r-20,-194","w":188},"\u041c":{"d":"311,-240r-40,240r-56,0r33,-201r-96,201r-32,0r-33,-203r-34,203r-45,0r40,-240r84,0r22,147r70,-147r87,0","w":308},"\u041d":{"d":"232,-240r-40,240r-53,0r17,-100r-77,0r-17,100r-53,0r40,-240r53,0r-16,94r78,0r16,-94r52,0","w":231},"\u041e":{"d":"225,-137v0,73,-42,142,-114,142v-58,0,-94,-46,-94,-105v0,-70,43,-143,112,-143v60,0,96,44,96,106xm130,-199v-42,0,-59,61,-58,107v0,35,13,52,40,52v43,0,57,-65,58,-105v0,-36,-13,-54,-40,-54","w":231,"k":{"\u0459":-1,"\u043b":-1,"\u042f":1,"\u042a":1,"\u0427":1,"\u0425":9,"\u0423":5,"\u0422":5,"\u041b":1,"\u0417":-2,"\u0416":6,"\u0414":1,"\u0410":6,"\u040e":5,"\u040b":1,"\u0409":1}},"\u041f":{"d":"9,0r40,-240r176,0r-40,240r-53,0r33,-196r-70,0r-33,196r-53,0","w":223},"\u0420":{"d":"222,-171v-2,53,-31,85,-92,81r-51,0r-15,90r-55,0r40,-240v82,0,177,-13,173,69xm169,-167v0,-32,-36,-31,-72,-30r-11,65v40,1,83,3,83,-35","w":216,"k":{"\u0459":12,"\u0454":1,"\u0444":2,"\u0441":1,"\u043b":12,"\u0437":-5,"\u0435":1,"\u0434":15,"\u0433":2,"\u0432":2,"\u0430":1,"\u042f":-2,"\u0427":-3,"\u0421":-2,"\u041b":7,"\u0414":14,"\u0410":13,"\u0409":7,".":25,"-":-4,",":25}},"\u0421":{"d":"17,-100v0,-72,45,-147,116,-145v54,2,91,35,91,95r-55,3v2,-29,-9,-51,-36,-52v-42,-2,-57,67,-57,108v0,31,13,48,40,49v24,0,39,-14,48,-44r50,8v-18,55,-52,82,-102,82v-61,0,-95,-46,-95,-104","w":224,"k":{"\u045e":-3,"\u0447":-2,"\u0443":-2,"\u0442":-8,"\u0425":7,"\u0423":4,"\u0422":1,"\u041b":-2,"\u0417":-5,"\u0416":4,"\u0410":2,"\u040e":4,"\u0409":-1}},"\u0422":{"d":"194,-194r-61,0r-32,194r-55,0r32,-194r-60,0r7,-46r176,0","w":176,"k":{"\u045e":-5,"\u0459":15,"\u0454":15,"\u044f":12,"\u044a":-8,"\u0446":7,"\u0444":18,"\u0443":-4,"\u0442":-5,"\u0441":15,"\u0440":5,"\u043f":7,"\u043e":15,"\u043d":7,"\u043c":7,"\u043b":15,"\u043a":7,"\u0438":7,"\u0437":10,"\u0436":-3,"\u0435":15,"\u0434":17,"\u0433":7,"\u0432":7,"\u0430":15,"\u042f":-5,"\u0424":7,"\u0423":-15,"\u0422":-12,"\u0421":1,"\u041b":7,"\u0417":-8,"\u0414":13,"\u0410":13,"\u040e":-15,"\u040b":-14,"\u0409":8,"\u0404":-1,"\u00bb":17,";":7,":":7,".":14,"-":7,",":15}},"\u0423":{"d":"77,-72r-59,-168r57,0r35,110r61,-110r50,0r-101,178v-26,46,-44,65,-112,62r7,-44v33,2,53,-5,62,-28","w":187,"k":{"\u045e":-4,"\u0459":15,"\u0454":13,"\u044f":9,"\u044e":7,"\u0447":1,"\u0446":7,"\u0444":14,"\u0443":-3,"\u0442":-5,"\u0441":13,"\u0440":7,"\u043f":7,"\u043e":12,"\u043d":7,"\u043c":7,"\u043b":15,"\u043a":7,"\u0438":7,"\u0437":6,"\u0436":-2,"\u0435":13,"\u0434":18,"\u0431":6,"\u0430":12,"\u042f":-1,"\u0427":-10,"\u0424":8,"\u0423":-19,"\u0422":-16,"\u0421":5,"\u041e":4,"\u041b":7,"\u0417":-4,"\u0414":13,"\u0410":13,"\u040b":-18,"\u0409":8,"\u0404":3,"\u00bb":12,";":6,":":6,".":21,"-":2,",":21}},"\u0424":{"d":"179,-216v47,5,81,35,80,87v-1,65,-44,105,-112,106r-5,30r-52,0r5,-31v-86,-5,-96,-104,-50,-157v18,-21,45,-33,82,-36r5,-30r53,0xm121,-178v-59,7,-74,97,-19,115xm154,-61v57,2,78,-101,19,-115","w":265,"k":{"\u0459":1,"\u043b":1,"\u0434":5,"\u042f":4,"\u042a":7,"\u0427":1,"\u0425":12,"\u0423":9,"\u041b":1,"\u0416":9,"\u0414":6,"\u0410":7,"\u040e":9,"\u0409":2}},"\u0425":{"d":"228,-239r-84,112r58,128r-60,0r-39,-91r-63,91r-55,0r97,-128r-52,-112r60,0r33,75r51,-75r54,0","w":218,"k":{"\u0454":12,"\u0447":18,"\u0444":14,"\u0443":14,"\u0442":12,"\u0441":12,"\u043e":12,"\u0437":5,"\u0435":12,"\u0430":5,"\u0424":15,"\u0421":11,"\u041e":11,"\u0417":7,"\u0404":10}},"\u0426":{"d":"11,0r40,-240r53,0r-33,194r77,0r33,-194r52,0r-32,194r29,0r-16,97r-36,0r4,-51r-171,0","w":236},"\u0427":{"d":"141,-95v-36,34,-124,31,-122,-30v1,-33,13,-81,18,-115r52,0r-16,104v3,31,54,18,74,5r18,-109r53,0r-40,240r-53,0","w":217},"\u0428":{"d":"11,0r40,-240r53,0r-33,194r66,0r32,-194r53,0r-33,194r66,0r32,-194r53,0r-40,240r-289,0","w":340},"\u0429":{"d":"308,-46r30,0r-16,97r-35,0r3,-51r-279,0r40,-240r53,0r-33,194r66,0r32,-194r53,0r-33,194r66,0r32,-194r53,0","w":343},"\u042a":{"d":"231,-87v-2,54,-34,87,-98,87r-101,0r33,-194r-56,0r8,-46r108,0r-14,89v66,-3,122,0,120,64xm93,-44v41,1,82,4,82,-38v0,-31,-39,-27,-71,-27","w":238,"k":{"\u044a":1,"\u042a":10,"\u0427":3,"\u0423":4,"\u0422":16,"\u040e":4,"\u040b":7}},"\u042b":{"d":"210,-87v-2,54,-35,87,-99,87r-100,0r40,-240r53,0r-15,89v67,-3,122,1,121,64xm71,-44v41,1,83,4,83,-38v0,-32,-40,-27,-72,-27xm314,-241r-40,240r-51,0r40,-240r51,0","w":315},"\u042c":{"d":"208,-87v-2,54,-35,87,-99,87r-100,0r40,-240r53,0r-15,89v67,-3,122,1,121,64xm69,-44v41,1,83,4,83,-38v0,-32,-40,-27,-72,-27","w":214,"k":{"\u044a":1,"\u042a":11,"\u0427":3,"\u0423":4,"\u0422":16,"\u040e":4,"\u040b":7}},"\u042d":{"d":"217,-137v0,78,-43,142,-119,142v-54,0,-87,-34,-96,-75r50,-10v4,44,63,52,89,23v10,-12,16,-28,18,-48r-84,0r6,-37r83,0v9,-66,-78,-77,-97,-24r-46,-13v21,-44,55,-66,100,-66v64,0,96,43,96,108","w":223,"k":{"\u0459":-1,"\u0427":1,"\u0423":5,"\u0422":5,"\u0410":5,"\u040e":5}},"\u042e":{"d":"213,5v-56,-1,-92,-46,-90,-108r-40,0r-18,103r-52,0r40,-240r53,0r-16,95r38,0v12,-51,45,-100,104,-100v58,0,96,46,95,107v-1,73,-42,144,-114,143xm215,-40v44,0,57,-60,57,-107v0,-36,-14,-54,-40,-54v-44,-1,-57,63,-58,108v0,35,14,53,41,53","w":333,"k":{"\u042f":1,"\u042a":1,"\u0427":1,"\u0425":9,"\u0423":6,"\u0422":6,"\u041b":1,"\u0417":-2,"\u0416":6,"\u0414":1,"\u0410":6,"\u040e":6,"\u040b":1,"\u0409":1}},"\u042f":{"d":"56,-106v-63,-39,-26,-134,64,-134r107,0r-40,240r-54,0r16,-95r-47,0r-56,95r-59,0xm79,-165v0,36,41,28,77,29r10,-61v-40,1,-87,-9,-87,32","w":225},"\u0430":{"d":"22,-127v10,-66,157,-80,157,-3v0,33,-20,93,-16,130r-50,0r2,-31v-17,51,-115,47,-111,-13v4,-54,49,-64,121,-68v8,-19,0,-38,-20,-37v-18,0,-30,9,-36,27xm58,-50v0,26,33,28,47,7v7,-11,13,-25,16,-44v-42,2,-63,14,-63,37","w":196,"k":{"\u045e":7,"\u0459":-4,"\u0447":5,"\u0443":7}},"\u0431":{"d":"91,5v-120,0,-80,-192,-18,-227v14,-16,59,-11,66,-34r51,0v-8,60,-110,24,-118,91v54,-36,117,-3,117,65v0,59,-40,105,-98,105xm94,-31v34,0,41,-40,42,-77v0,-25,-10,-37,-29,-37v-34,0,-43,40,-43,77v0,25,10,37,30,37","w":200,"k":{"\u045e":7,"\u044f":1,"\u0445":5,"\u0443":7,"\u0442":1,"\u0436":4}},"\u0432":{"d":"179,-53v0,70,-101,51,-172,53r30,-179v57,2,151,-14,151,41v0,23,-16,38,-47,44v26,6,38,20,38,41xm76,-106v27,-1,64,6,61,-22v2,-21,-32,-17,-54,-17xm64,-35v30,0,65,6,65,-27v0,-24,-33,-19,-57,-19","w":196,"k":{"\u045e":4,"\u044f":-1,"\u0447":1,"\u0445":2,"\u0443":4,"\u0442":-4,"\u0437":-2}},"\u0433":{"d":"152,-179r-6,38r-64,0r-24,141r-51,0r30,-179r115,0","w":138,"k":{"\u045e":-10,"\u0459":10,"\u0454":-1,"\u044f":-4,"\u0444":1,"\u0441":-1,"\u043e":-2,"\u043b":10,"\u0434":14,";":-1,":":-2,".":18,"-":11,",":19}},"\u0434":{"d":"11,-37r64,-141r72,0r11,141r22,0r-13,78r-31,0r1,-41r-118,0r-12,41r-31,0r13,-78r22,0xm50,-37r57,0r-5,-105r-7,0","w":186},"\u0435":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0","w":191,"k":{"\u045e":7,"\u044f":1,"\u0445":5,"\u0443":7,"\u043b":1,"\u0437":-1,"\u0436":3}},"\u0436":{"d":"205,-105r45,105r-53,0r-32,-78r-13,4r-12,74r-52,0r12,-74r-12,-4r-58,78r-49,0r77,-98r-43,-81r51,0r33,67r7,2r12,-69r51,0r-11,69r7,-2r56,-67r51,0","w":256,"k":{"\u045e":-12,"\u0454":2,"\u0444":4,"\u0441":2,"\u043e":2,"\u0435":1,"\u0431":-2}},"\u0437":{"d":"105,-56v0,-21,-16,-19,-43,-20r5,-31v28,0,40,-4,42,-24v-3,-27,-48,-22,-52,5r-45,-7v8,-63,150,-73,150,-4v0,20,-13,34,-39,42v23,6,35,19,35,40v2,78,-155,81,-159,6r48,-7v2,18,11,27,27,27v18,0,31,-10,31,-27","w":171,"k":{"\u045e":4,"\u0459":-3,"\u044f":-1,"\u0447":2,"\u0445":2,"\u0443":4,"\u0442":-3,"\u043b":-3}},"\u0438":{"d":"135,-108v-20,43,-62,61,-77,108r-51,0r30,-179r51,0r-19,107v23,-33,48,-58,73,-87r3,-20r52,0r-30,179r-52,0","w":203},"\u0439":{"d":"135,-108v-20,43,-62,61,-77,108r-51,0r30,-179r51,0r-19,107v23,-33,48,-58,73,-87r3,-20r52,0r-30,179r-52,0xm184,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":203,"k":{"\u0459":-2}},"\u043a":{"d":"139,-118r39,118r-54,0r-26,-82r-30,27r-10,55r-51,0r30,-179r51,0r-12,74r73,-74r55,0","w":189,"k":{"\u045e":-10,"\u0454":3,"\u0444":5,"\u0441":3,"\u043e":3,"\u0437":1,"\u0435":3,"\u0431":-1,"\u0430":2}},"\u043b":{"d":"-19,0r89,-178r58,0r24,178r-52,0r-13,-130r-3,0r-64,130r-39,0","w":162},"\u043c":{"d":"7,0r30,-179r73,0r15,145r65,-145r71,0r-30,179r-47,0r24,-143r-3,0r-64,143r-52,0r-16,-143r-3,0r-24,143r-39,0","w":267},"\u043d":{"d":"7,0r30,-179r51,0r-11,65r55,0r11,-65r51,0r-29,179r-52,0r13,-76r-55,0r-13,76r-51,0","w":201},"\u043e":{"d":"11,-77v0,-58,36,-106,92,-106v47,0,78,35,78,84v0,54,-40,103,-92,103v-45,0,-78,-36,-78,-81xm91,-31v31,0,37,-56,38,-84v0,-23,-9,-34,-26,-34v-31,0,-38,52,-39,84v0,23,9,34,27,34","w":192,"k":{"\u045e":7,"\u0459":1,"\u044a":-1,"\u0445":5,"\u0443":6,"\u0442":1,"\u043b":1,"\u0437":-1,"\u0436":3}},"\u043f":{"d":"7,0r30,-179r151,0r-30,179r-52,0r24,-143r-48,0r-24,143r-51,0","w":194},"\u0440":{"d":"108,4v-22,0,-39,-14,-45,-30r-15,88r-52,0r41,-241r47,0r-6,32v29,-62,106,-32,106,39v0,52,-28,112,-76,112xm69,-64v-1,18,9,31,25,32v28,1,37,-56,37,-84v0,-15,-7,-29,-23,-29v-32,0,-37,55,-39,81","w":194,"k":{"\u045e":5,"\u0454":-1,"\u044f":-1,"\u0445":3,"\u0443":4,"\u0442":-1,"\u0437":-1,"\u0436":1,";":-1,":":-1,".":-3,"-":-14,",":-2}},"\u0441":{"d":"105,-142v-29,0,-39,37,-38,73v0,47,54,41,61,1r43,6v-15,45,-42,67,-82,67v-48,1,-78,-35,-78,-83v0,-53,38,-103,93,-103v46,0,74,29,74,69r-47,3v0,-21,-9,-33,-26,-33","w":182,"k":{"\u0447":-2,"\u0445":3,"\u0443":4,"\u0442":-4,"\u043e":-1,"\u0437":-3,"\u0436":1,"\u0430":-2,"\u040e":6}},"\u0442":{"d":"31,0r23,-141r-48,0r6,-38r148,0r-6,38r-48,0r-24,141r-51,0","w":140,"k":{"\u045e":-13,"\u0459":5,"\u0454":-3,"\u044f":-7,"\u0447":-9,"\u0444":-1,"\u0443":-13,"\u0442":-15,"\u0441":-4,"\u043e":-4,"\u043b":5,"\u0437":-10,"\u0435":-4,"\u0434":9,"\u0430":-4,"\u00bb":3,";":-4,":":-4,".":8,",":8}},"\u0443":{"d":"179,-180r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0","w":164,"k":{"\u0459":2,"\u0454":2,"\u0447":-7,"\u0444":4,"\u0442":-13,"\u0441":2,"\u043e":1,"\u043b":2,"\u0437":-3,"\u0435":1,"\u0434":6,"\u0430":2,"\u00bb":2,";":-1,":":-1,".":7,"-":-8,",":7}},"\u0444":{"d":"88,1v-77,0,-99,-100,-48,-147v19,-19,45,-30,78,-33r10,-61r47,0r-11,62v75,1,98,99,49,148v-19,18,-45,30,-79,32r-10,60r-47,0xm113,-151v-52,4,-74,102,-20,120xm139,-28v52,-5,74,-102,20,-120","w":251,"k":{"\u045e":9,"\u0459":3,"\u044f":3,"\u0445":7,"\u0443":8,"\u0442":2,"\u043b":3,"\u0436":5,"\u0433":2}},"\u0445":{"d":"183,-179r-68,85r43,94r-56,0r-26,-63r-45,63r-46,0r74,-96r-39,-83r57,0r23,52r37,-52r46,0","w":173,"k":{"\u045e":-8,"\u0454":5,"\u0444":7,"\u0441":5,"\u043e":5,"\u0437":3,"\u0435":4,"\u0430":4}},"\u0446":{"d":"7,0r30,-179r51,0r-23,141r51,0r24,-141r51,0r-23,141r26,0r-14,79r-31,0r1,-41r-143,0","w":200},"\u0447":{"d":"105,-67v-40,30,-114,14,-91,-50r10,-62r52,0r-12,78v1,22,33,16,46,6r14,-84r52,0r-30,179r-52,0","w":182},"\u0448":{"d":"8,0r30,-179r51,0r-23,141r47,0r24,-141r51,0r-23,141r47,0r24,-141r51,0r-30,179r-249,0","w":294},"\u0449":{"d":"8,0r30,-179r52,0r-24,141r47,0r24,-141r51,0r-23,141r47,0r24,-141r51,0r-23,141r27,0r-13,79r-32,0r2,-41r-240,0","w":297},"\u044a":{"d":"189,-65v0,78,-88,65,-166,65r24,-141r-47,0r7,-38r98,0r-11,64v51,-3,95,2,95,50xm141,-61v0,-25,-27,-21,-52,-21r-8,47v29,1,60,3,60,-26","w":200,"k":{"\u045e":13,"\u044a":10,"\u0447":1,"\u0443":13,"\u0442":13}},"\u044b":{"d":"173,-65v0,77,-88,65,-165,65r30,-179r51,0r-10,64v51,-3,94,2,94,50xm126,-61v0,-26,-29,-20,-53,-21r-8,47v29,1,61,3,61,-26xm267,-179r-30,179r-53,0r30,-179r53,0","w":273},"\u044c":{"d":"172,-65v0,77,-88,65,-165,65r30,-179r51,0r-10,64v51,-3,94,2,94,50xm125,-61v0,-26,-29,-20,-53,-21r-8,47v29,1,61,3,61,-26","w":183,"k":{"\u045e":13,"\u044a":9,"\u0447":1,"\u0443":13,"\u0442":13}},"\u044d":{"d":"175,-102v0,63,-36,108,-100,107v-41,0,-67,-18,-76,-53r48,-8v11,44,71,31,71,-18r-69,0r6,-34r67,0v11,-46,-54,-55,-63,-17r-47,-8v16,-34,43,-51,82,-51v51,0,81,30,81,82","w":185,"k":{"\u045e":6,"\u044a":-3,"\u0447":-1,"\u0443":5}},"\u044e":{"d":"185,4v-43,0,-76,-33,-76,-78r-38,0r-13,74r-51,0r30,-179r51,0r-11,68r36,0v9,-40,40,-71,85,-72v47,0,78,35,78,84v0,54,-39,104,-91,103xm186,-31v31,0,37,-56,38,-83v0,-23,-9,-35,-26,-35v-31,0,-38,52,-39,84v0,23,9,34,27,34","w":287,"k":{"\u045e":7,"\u0459":1,"\u044a":-1,"\u0445":5,"\u0443":7,"\u0442":1,"\u043b":1,"\u0436":3}},"\u044f":{"d":"43,-79v-49,-30,-17,-100,49,-100r92,0r-31,179r-49,0r12,-69r-36,0r-42,69r-48,0xm121,-103r8,-42v-28,1,-60,-7,-60,25v0,24,30,16,52,17","w":190},"\u0451":{"d":"104,-183v54,1,84,46,74,103r-115,0v-14,53,53,65,65,19r44,8v-12,31,-40,58,-83,58v-47,1,-79,-36,-79,-83v0,-53,39,-106,94,-105xm131,-110v5,-22,-6,-40,-26,-40v-20,0,-33,13,-39,40r65,0xm161,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm103,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":189},"\u0452":{"d":"8,0r32,-196r-29,0r5,-29r29,0r4,-20r51,0r-3,20r68,0r-5,29r-68,0r-9,51v24,-40,102,-43,100,17v0,22,-20,172,-43,174v-16,12,-35,19,-59,16r3,-37v35,-7,30,-25,40,-73v6,-32,8,-53,8,-62v2,-30,-30,-27,-43,-12v-22,28,-20,82,-30,122r-51,0","w":196},"\u0453":{"d":"152,-179r-6,38r-64,0r-24,141r-51,0r30,-179r115,0xm74,-204r-9,-20r72,-42r14,29","w":138,"k":{"\u0459":10,"\u0454":-1,"\u044f":-4,"\u0441":-1,"\u043e":-2,"\u043b":10,"\u0434":14}},"\u0454":{"d":"11,-78v0,-57,39,-106,100,-106v40,0,65,17,74,51r-49,8v-2,-16,-11,-24,-28,-24v-22,0,-35,13,-39,41r69,0r-5,34r-68,0v-10,51,55,60,66,18r46,8v-15,35,-41,53,-80,53v-54,1,-86,-30,-86,-83","w":188},"\u0455":{"d":"26,-87v-32,-41,4,-96,59,-96v42,0,67,17,75,51r-40,8v0,-28,-55,-35,-59,-8v4,26,65,16,77,35v40,39,-3,101,-62,101v-41,0,-76,-18,-81,-54r44,-5v-3,28,66,36,68,7v-4,-26,-75,-18,-81,-39","w":166},"\u0456":{"d":"101,-243r-8,51r-54,0r8,-51r54,0xm90,-179r-30,179r-53,0r30,-179r53,0","w":97},"\u0457":{"d":"89,-179r-30,179r-53,0r30,-179r53,0xm117,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm59,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":97},"\u0458":{"d":"92,-192r-53,0r8,-51r54,0xm90,-179r-26,157v-5,68,-29,97,-100,85r6,-41v38,6,37,-17,42,-53r25,-148r53,0","w":96},"\u0459":{"d":"239,-65v0,72,-77,67,-151,65r-4,-130r-64,130r-39,0r89,-178r58,0r5,63v53,-2,106,-3,106,50xm191,-61v0,-28,-31,-20,-56,-21r3,47v27,1,53,0,53,-26","w":250,"k":{"\u045e":13,"\u044a":10,"\u0447":1,"\u0443":13,"\u0442":14}},"\u045a":{"d":"276,-65v-2,41,-27,65,-80,65r-86,0r13,-76r-52,0r-13,76r-51,0r30,-179r51,0r-11,65r52,0r11,-65r52,0r-11,64v51,-3,99,2,95,50xm228,-61v0,-25,-27,-21,-52,-21r-8,47v29,1,60,3,60,-26","w":287,"k":{"\u045e":13,"\u044a":10,"\u0447":1,"\u0443":13,"\u0442":13}},"\u045b":{"d":"131,-99v12,-35,-24,-44,-42,-23v-24,27,-19,82,-30,122r-51,0r32,-196r-29,0r5,-29r29,0r4,-20r51,0r-3,20r67,0r-5,29r-67,0r-9,51v32,-51,113,-33,101,39r-18,106r-51,0","w":198},"\u045c":{"d":"139,-118r39,118r-54,0r-26,-82r-30,27r-10,55r-51,0r30,-179r51,0r-12,74r73,-74r55,0xm99,-204r-9,-20r72,-42r14,29","w":189,"k":{"\u045e":-10,"\u0454":3,"\u0444":6,"\u0441":3,"\u043e":3,"\u0437":1,"\u0435":3,"\u0430":2}},"\u045e":{"d":"179,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0xm168,-258v-3,53,-110,74,-112,9r0,-9r28,0v0,35,52,29,57,0r27,0","w":161,"k":{"\u0454":2,"\u0447":-7,"\u0444":4,"\u0442":-13,"\u0441":2,"\u043e":2,"\u043b":2,"\u0437":-3,"\u0435":2,"\u0434":6,"\u0430":2}},"\u045f":{"d":"7,0r30,-179r51,0r-23,142r51,0r24,-142r51,0r-30,179r-57,0r-11,41r-31,0r2,-41r-57,0","w":197},"\u0490":{"d":"199,-285r-15,91r-90,0r-32,194r-53,0r40,-240r102,0r8,-45r40,0","w":165},"\u0491":{"d":"116,-179r6,-39r37,0r-13,77r-64,0r-24,141r-51,0r30,-179r79,0","w":138},"\u1e80":{"d":"341,-240r-99,240r-51,0r-22,-167r-64,167r-51,0r-29,-240r55,0r15,166r64,-166r50,0r20,166r63,-166r49,0xm214,-260r-69,-35r17,-27r63,42","w":319},"\u1e81":{"d":"271,-179r-81,179r-46,0r-13,-115r-45,115r-45,0r-26,-179r53,0r14,112r42,-112r48,0r11,112r48,-112r40,0xm179,-204r-69,-35r17,-27r63,42","w":259},"\u1e82":{"d":"341,-240r-99,240r-51,0r-22,-167r-64,167r-51,0r-29,-240r55,0r15,166r64,-166r50,0r20,166r63,-166r49,0xm166,-260r-9,-20r72,-42r14,29","w":319},"\u1e83":{"d":"271,-179r-81,179r-46,0r-13,-115r-45,115r-45,0r-26,-179r53,0r14,112r42,-112r48,0r11,112r48,-112r40,0xm125,-204r-9,-20r72,-42r14,29","w":259},"\u1e84":{"d":"341,-240r-99,240r-51,0r-22,-167r-64,167r-51,0r-29,-240r55,0r15,166r64,-166r50,0r20,166r63,-166r49,0xm240,-286v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm182,-286v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":319},"\u1e85":{"d":"271,-179r-81,179r-46,0r-13,-115r-45,115r-45,0r-26,-179r53,0r14,112r42,-112r48,0r11,112r48,-112r40,0xm202,-231v0,12,-9,21,-21,21v-11,0,-21,-10,-21,-21v0,-10,10,-20,21,-20v12,0,21,8,21,20xm144,-231v0,12,-10,21,-22,21v-11,0,-21,-10,-20,-21v0,-10,9,-20,20,-20v12,0,22,9,22,20","w":259},"\u1ef2":{"d":"225,-240r-97,139r-17,101r-55,0r17,-101r-60,-139r60,0r37,95r62,-95r53,0xm155,-260r-69,-35r17,-27r63,42","w":190},"\u1ef3":{"d":"176,-179r-80,169v-24,51,-35,75,-104,72r3,-40v32,5,50,0,58,-24r-42,-177r54,0r22,109r48,-109r41,0xm133,-204r-69,-35r17,-27r63,42","w":161},"\u2015":{"d":"242,-69r-250,0r6,-39r250,0","w":239},"\u2017":{"d":"5,17r180,0r0,28r-180,0r0,-28xm5,60r180,0r0,28r-180,0r0,-28","w":180},"\u201b":{"d":"48,-240r48,0r-9,52r-24,0r8,50r-17,0r-15,-55","w":92},"\u2032":{"d":"43,-141r-29,0r44,-99r41,0","w":68},"\u2033":{"d":"41,-141r-29,0r44,-99r41,0xm110,-141r-28,0r43,-99r42,0","w":130},"\u203c":{"d":"75,-240v3,63,-7,113,-14,166r-25,0v-7,-53,-17,-103,-14,-166r53,0xm168,-240v3,62,-6,113,-13,166r-25,0v-7,-53,-17,-103,-14,-166r52,0xm76,-53r0,53r-55,0r0,-53r55,0xm169,-53r0,53r-54,0r0,-53r54,0","w":180},"\u203e":{"d":"-7,-329r216,0r0,13r-216,0r0,-13","w":201},"\u2044":{"d":"-50,0r-33,0r182,-241r33,0","w":38},"\u207f":{"d":"67,-192v19,-29,75,-9,58,36r-10,60r-36,0r12,-74v1,-14,-19,-11,-23,-3v-9,17,-11,54,-16,77r-36,0r18,-108r34,0","w":128},"\u20a4":{"d":"204,-65v-23,50,-43,65,-117,65r-98,0r5,-46v37,3,61,-4,65,-37r-38,0r4,-28r35,0v0,-8,-1,-14,-1,-20r-30,0r5,-28r25,0v2,-52,29,-87,82,-86v38,0,61,16,69,48r-48,18v0,-27,-30,-31,-42,-14v-4,7,-6,19,-6,34r42,0r-5,28r-37,0v0,9,-1,16,-1,20r35,0r-5,28r-35,0v-3,15,-11,27,-24,37v41,1,64,0,72,-33","w":211},"\u20a7":{"d":"210,-171v-2,67,-51,89,-131,81r-15,90r-53,0r41,-240v79,-2,160,-8,158,69xm159,-167v0,-30,-30,-31,-62,-30r-11,65v37,2,73,0,73,-35xm272,-81r-27,0r-8,49v-1,9,18,9,27,7r-5,26v-42,6,-72,-7,-55,-49r6,-33r-17,0r5,-27r19,0r7,-29r32,-1r-6,30r26,0xm291,-52v-21,-26,3,-58,38,-58v27,0,42,10,48,31v-9,0,-23,7,-29,3v0,-13,-32,-19,-32,-3v16,18,58,6,58,43v0,48,-96,51,-103,6r32,-4v1,10,8,15,22,15v14,0,22,-9,14,-17v-13,-3,-45,-8,-48,-16","w":390},"\u2105":{"d":"84,-217v-26,0,-41,66,-8,68v11,0,19,-7,23,-21r32,4v-13,64,-114,57,-114,-10v0,-36,28,-69,66,-69v32,0,53,19,53,47r-34,3v1,-13,-6,-22,-18,-22xm94,0r-33,0r182,-241r33,0xm197,-50v-1,-40,26,-71,65,-71v33,0,55,23,55,56v0,37,-27,69,-65,69v-33,0,-55,-23,-55,-54xm253,-20v20,2,27,-36,26,-55v0,-15,-5,-22,-17,-22v-26,-1,-42,75,-9,77","w":330},"\u2113":{"d":"149,-243v18,1,29,15,29,34v0,34,-21,72,-63,114v-7,34,-10,55,-10,64v0,8,1,11,5,11v7,3,13,-24,23,-24v4,0,6,2,6,7v0,19,-19,44,-40,43v-28,-1,-30,-34,-29,-69v-10,12,-16,13,-19,0v2,-11,20,-25,22,-30v7,-41,17,-77,29,-106v12,-29,28,-44,47,-44xm120,-128v17,-18,35,-49,36,-78v0,-9,-2,-13,-6,-13v-9,0,-19,30,-30,91","w":211},"\u2116":{"d":"236,-240r-40,240r-45,0r-70,-174v-1,33,-20,130,-27,174r-45,0r40,-240r61,0r58,146v1,-18,17,-113,23,-146r45,0xm304,-182v29,0,51,23,51,53v0,34,-27,65,-61,65v-31,0,-54,-22,-54,-52v1,-37,24,-66,64,-66xm295,-90v20,-1,33,-65,6,-67v-22,-1,-33,65,-6,67xm334,0r-110,0r6,-39r111,0","w":360},"\u212e":{"d":"14,-93v0,-86,99,-132,157,-75v18,17,28,42,29,75r-146,0r0,65v37,35,99,25,122,-22r13,7v-23,32,-40,48,-82,49v-55,2,-93,-44,-93,-99xm159,-106r0,-53v-28,-28,-79,-28,-105,1r0,52r105,0","w":216},"\u215b":{"d":"127,-126r-5,30r-108,0r5,-30r35,0r13,-76v-9,7,-26,11,-42,8r5,-28v25,0,42,-8,52,-22r28,0r-20,118r37,0xm89,0r-32,0r173,-241r33,0xm182,-36v0,-18,16,-34,34,-36v-41,-26,-3,-79,43,-74v51,-5,73,53,22,68v16,7,25,19,25,33v3,54,-124,64,-124,9xm280,-106v2,-23,-47,-26,-49,-4v0,9,11,16,32,22v11,-4,17,-10,17,-18xm214,-41v-1,24,55,26,57,3v-3,-16,-19,-17,-35,-24v-12,1,-21,11,-22,21","w":316},"\u215c":{"d":"107,-169v49,25,11,76,-37,76v-34,0,-58,-17,-64,-45r32,-5v4,26,53,31,53,4v0,-19,-20,-19,-42,-18r4,-27v20,1,46,0,44,-16v-2,-23,-41,-20,-46,1r-33,-8v14,-48,116,-50,116,4v0,17,-9,28,-27,34xm94,0r-32,0r173,-241r33,0xm185,-36v0,-18,16,-34,34,-36v-41,-26,-3,-79,43,-74v51,-5,73,53,22,68v16,7,25,19,25,33v3,54,-124,64,-124,9xm283,-106v2,-23,-47,-26,-49,-4v0,9,11,16,32,22v11,-4,17,-10,17,-18xm217,-41v-1,24,55,26,57,3v-3,-16,-19,-17,-35,-24v-12,1,-21,11,-22,21","w":316},"\u215d":{"d":"96,-145v0,-24,-34,-28,-45,-9r-31,-9r19,-77r101,0r-8,30r-68,0r-7,28v29,-24,78,-1,78,36v0,62,-115,70,-125,11r36,-6v4,26,50,25,50,-4xm97,0r-32,0r173,-241r33,0xm186,-36v0,-18,16,-34,34,-36v-41,-26,-3,-79,43,-74v51,-5,73,53,22,68v16,7,25,19,25,33v3,54,-124,64,-124,9xm284,-106v2,-23,-47,-26,-49,-4v0,9,11,16,32,22v11,-4,17,-10,17,-18xm218,-41v-1,24,55,26,57,3v-3,-16,-19,-17,-35,-24v-12,1,-21,11,-22,21","w":316},"\u215e":{"d":"134,-240r-3,24v-29,23,-61,72,-63,120r-43,0v6,-45,29,-82,69,-114r-77,0r6,-30r111,0xm71,0r-32,0r173,-241r33,0xm178,-36v0,-18,16,-34,34,-36v-41,-26,-3,-79,43,-74v51,-5,73,53,22,68v16,7,25,19,25,33v3,54,-124,64,-124,9xm276,-106v2,-23,-47,-26,-49,-4v0,9,11,16,32,22v11,-4,17,-10,17,-18xm210,-41v-1,24,55,26,57,3v-3,-16,-19,-17,-35,-24v-12,1,-21,11,-22,21","w":316},"\u2190":{"d":"86,-154r14,0v-9,20,-21,38,-34,54r280,0r0,18r-280,0v12,12,23,30,34,54r-13,0v-26,-30,-51,-50,-73,-60r0,-7v21,-8,44,-28,72,-59","w":360},"\u2191":{"d":"27,-163v31,-28,50,-51,58,-72r9,0v10,22,29,46,59,72r0,14v-24,-11,-42,-23,-54,-35r0,259r-18,0r0,-259v-16,13,-34,26,-54,35r0,-14","w":180},"\u2192":{"d":"273,-154v28,31,52,51,73,59r0,7v-22,10,-47,30,-73,60r-13,0v11,-24,22,-42,34,-54r-280,0r0,-18r280,0v-13,-16,-25,-34,-34,-54r13,0","w":360},"\u2193":{"d":"27,3r0,-14v20,9,38,22,54,35r0,-259r18,0r0,259v12,-12,30,-24,54,-35r0,14v-30,26,-49,50,-59,72r-9,0v-8,-21,-27,-44,-58,-72","w":180},"\u2194":{"d":"346,-95r0,8v-21,9,-45,29,-71,59r-14,0v8,-20,19,-38,34,-54r-230,0v15,16,26,34,34,54r-14,0v-26,-30,-50,-50,-71,-59r0,-8v21,-9,45,-29,71,-59r14,0v-8,20,-19,38,-34,54r230,0v-15,-16,-26,-34,-34,-54r14,0v26,30,50,50,71,59","w":360},"\u2195":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71","w":180},"\u21a8":{"d":"86,-257r8,0v9,21,29,45,59,71r0,14v-20,-8,-39,-19,-55,-34r0,230v16,-15,35,-26,55,-34r0,14v-30,26,-50,50,-59,71r-8,0v-9,-21,-29,-45,-59,-71r0,-14v20,8,38,19,54,34r0,-230v-16,15,-34,26,-54,34r0,-14v30,-26,50,-50,59,-71xm27,92r126,0r0,17r-126,0r0,-17","w":180},"\u221f":{"d":"64,-225r17,0r0,207r208,0r0,18r-225,0r0,-225","w":352},"\u2229":{"d":"130,-230v-96,0,-63,132,-68,230r-37,0r0,-112v-7,-100,25,-144,105,-153v79,9,104,53,104,153r0,112r-37,0r0,-113v5,-77,-9,-117,-67,-117","w":258},"\u2261":{"d":"33,-203r156,0r0,44r-156,0r0,-44xm33,-143r156,0r0,45r-156,0r0,-45xm33,-82r156,0r0,44r-156,0r0,-44","w":211},"\u2302":{"d":"27,0r0,-111r81,-92r81,92r0,111r-162,0xm41,-14r134,0r0,-91r-67,-76r-67,76r0,91","w":216},"\u2310":{"d":"82,0r-49,0r0,-97r156,0r0,44r-107,0r0,53","w":211},"\u2320":{"d":"156,-270v-15,2,-23,-30,-33,-10r-2,371r-25,0r0,-319v-1,-42,18,-73,51,-77v26,-3,34,32,9,35","w":217},"\u2321":{"d":"61,55v16,-2,23,30,34,10r1,-370r25,0r0,318v2,43,-18,74,-51,78v-25,3,-33,-33,-9,-36","w":217},"\u2500":{"d":"259,-94r-263,0r0,-31r263,0r0,31"},"\u2502":{"d":"112,109r0,-437r31,0r0,437r-31,0"},"\u250c":{"d":"259,-125r0,31r-116,0r0,203r-31,0r0,-234r147,0"},"\u2510":{"d":"112,-94r-116,0r0,-31r147,0r0,234r-31,0r0,-203"},"\u2514":{"d":"112,-94r0,-234r31,0r0,203r116,0r0,31r-147,0"},"\u2518":{"d":"143,-94r-147,0r0,-31r116,0r0,-203r31,0r0,234"},"\u251c":{"d":"112,109r0,-437r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0"},"\u2524":{"d":"112,109r0,-203r-116,0r0,-31r116,0r0,-203r31,0r0,437r-31,0"},"\u252c":{"d":"112,-94r-116,0r0,-31r263,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2534":{"d":"259,-94r-263,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31"},"\u253c":{"d":"112,-94r-116,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0r0,-203"},"\u2550":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u2551":{"d":"146,109r0,-437r30,0r0,437r-30,0xm79,109r0,-437r31,0r0,437r-31,0"},"\u2552":{"d":"112,109r0,-267r147,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u2553":{"d":"79,109r0,-234r180,0r0,31r-83,0r0,203r-30,0r0,-203r-36,0r0,203r-31,0"},"\u2554":{"d":"110,109r-31,0r0,-267r180,0r0,31r-149,0r0,236xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0"},"\u2555":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r147,0r0,267r-31,0r0,-169"},"\u2556":{"d":"79,109r0,-203r-83,0r0,-31r180,0r0,234r-30,0r0,-203r-37,0r0,203r-30,0"},"\u2557":{"d":"146,109r0,-236r-150,0r0,-31r180,0r0,267r-30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169"},"\u2558":{"d":"112,-60r0,-268r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-147,0"},"\u2559":{"d":"259,-94r-180,0r0,-234r31,0r0,203r36,0r0,-203r30,0r0,203r83,0r0,31"},"\u255a":{"d":"110,-328r0,237r149,0r0,31r-180,0r0,-268r31,0xm176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170"},"\u255b":{"d":"143,-60r-147,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,268"},"\u255c":{"d":"176,-94r-180,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,234"},"\u255d":{"d":"146,-328r30,0r0,268r-180,0r0,-31r150,0r0,-237xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0"},"\u255e":{"d":"112,109r0,-437r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0"},"\u255f":{"d":"146,109r0,-437r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0xm79,109r0,-437r31,0r0,437r-31,0"},"\u2560":{"d":"79,109r0,-437r31,0r0,437r-31,0xm146,-127r0,-201r30,0r0,170r83,0r0,31r-113,0xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0"},"\u2561":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,437r-31,0r0,-169"},"\u2562":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,437r-30,0xm146,109r0,-437r30,0r0,437r-30,0"},"\u2563":{"d":"146,109r0,-437r30,0r0,437r-30,0xm109,-328r0,201r-113,0r0,-31r83,0r0,-170r30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169"},"\u2564":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm112,-60r-116,0r0,-31r263,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u2565":{"d":"79,109r0,-203r-83,0r0,-31r263,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0"},"\u2566":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0"},"\u2567":{"d":"259,-127r-263,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u2568":{"d":"259,-94r-263,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31"},"\u2569":{"d":"109,-127r-113,0r0,-31r83,0r0,-170r30,0r0,201xm259,-127r-113,0r0,-201r30,0r0,170r83,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31"},"\u256a":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0r0,-169"},"\u256b":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0"},"\u256c":{"d":"176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0"},"\u2580":{"d":"259,-109r-263,0r0,-219r263,0r0,219"},"\u2584":{"d":"259,109r-263,0r0,-218r263,0r0,218"},"\u2588":{"d":"-4,109r0,-437r263,0r0,437r-263,0"},"\u258c":{"d":"-4,109r0,-437r131,0r0,437r-131,0"},"\u2590":{"d":"128,109r0,-437r131,0r0,437r-131,0"},"\u2591":{"d":"0,-328r21,0r0,22r-21,0r0,-22xm85,-328r21,0r0,22r-21,0r0,-22xm170,-328r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm170,-240r21,0r0,22r-21,0r0,-22xm85,-240r21,0r0,22r-21,0r0,-22xm0,-240r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm0,-152r21,0r0,22r-21,0r0,-22xm85,-152r21,0r0,22r-21,0r0,-22xm170,-152r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm0,-65r21,0r0,22r-21,0r0,-22xm85,-65r21,0r0,22r-21,0r0,-22xm170,-65r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm170,23r21,0r0,22r-21,0r0,-22xm85,23r21,0r0,22r-21,0r0,-22xm0,23r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22"},"\u2592":{"d":"21,-328r21,0r0,22r-21,0r0,-22xm64,-328r21,0r0,22r-21,0r0,-22xm106,-328r21,0r0,22r-21,0r0,-22xm148,-328r22,0r0,22r-22,0r0,-22xm191,-328r21,0r0,22r-21,0r0,-22xm233,-328r21,0r0,22r-21,0r0,-22xm0,-284r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm85,-284r21,0r0,22r-21,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm170,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm21,-240r21,0r0,22r-21,0r0,-22xm64,-240r21,0r0,22r-21,0r0,-22xm106,-240r21,0r0,22r-21,0r0,-22xm148,-240r22,0r0,22r-22,0r0,-22xm191,-240r21,0r0,22r-21,0r0,-22xm233,-240r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm85,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm170,-196r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm0,-196r21,0r0,22r-21,0r0,-22xm21,-152r21,0r0,22r-21,0r0,-22xm64,-152r21,0r0,22r-21,0r0,-22xm106,-152r21,0r0,22r-21,0r0,-22xm148,-152r22,0r0,22r-22,0r0,-22xm191,-152r21,0r0,22r-21,0r0,-22xm233,-152r21,0r0,22r-21,0r0,-22xm0,-109r21,0r0,22r-21,0r0,-22xm85,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm170,-109r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm233,-65r21,0r0,22r-21,0r0,-22xm191,-65r21,0r0,22r-21,0r0,-22xm148,-65r22,0r0,22r-22,0r0,-22xm106,-65r21,0r0,22r-21,0r0,-22xm64,-65r21,0r0,22r-21,0r0,-22xm21,-65r21,0r0,22r-21,0r0,-22xm0,-21r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm85,-21r21,0r0,22r-21,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm170,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm233,23r21,0r0,22r-21,0r0,-22xm191,23r21,0r0,22r-21,0r0,-22xm148,23r22,0r0,22r-22,0r0,-22xm106,23r21,0r0,22r-21,0r0,-22xm64,23r21,0r0,22r-21,0r0,-22xm21,23r21,0r0,22r-21,0r0,-22xm0,67r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm85,67r21,0r0,22r-21,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm170,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22"},"\u2593":{"d":"254,-262r0,66r-21,0r0,22r21,0r0,65r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,21r-254,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-66r21,0r0,-22r21,0r0,22r22,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r22,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,44r-21,0r0,22r21,0xm21,-284r0,22r21,0r0,-22r-21,0xm64,-284r0,22r21,0r0,-22r-21,0xm106,-284r0,22r21,0r0,-22r-21,0xm148,-284r0,22r22,0r0,-22r-22,0xm191,-284r0,22r21,0r0,-22r-21,0xm233,-240r-21,0r0,22r21,0r0,-22xm191,-240r-21,0r0,22r21,0r0,-22xm148,-240r-21,0r0,22r21,0r0,-22xm106,-240r-21,0r0,22r21,0r0,-22xm64,-240r-22,0r0,22r22,0r0,-22xm21,-196r0,22r21,0r0,-22r-21,0xm64,-196r0,22r21,0r0,-22r-21,0xm106,-196r0,22r21,0r0,-22r-21,0xm148,-196r0,22r22,0r0,-22r-22,0xm191,-196r0,22r21,0r0,-22r-21,0xm64,-152r-22,0r0,22r22,0r0,-22xm85,-152r0,22r21,0r0,-22r-21,0xm127,-152r0,22r21,0r0,-22r-21,0xm170,-152r0,22r21,0r0,-22r-21,0xm212,-152r0,22r21,0r0,-22r-21,0xm21,-109r0,22r21,0r0,-22r-21,0xm106,-109r0,22r21,0r0,-22r-21,0xm85,-87r0,-22r-21,0r0,22r21,0xm148,-109r0,22r22,0r0,-22r-22,0xm191,-109r0,22r21,0r0,-22r-21,0xm233,-43r0,-22r-21,0r0,22r21,0xm191,-43r0,-22r-21,0r0,22r21,0xm148,-43r0,-22r-21,0r0,22r21,0xm106,-43r0,-22r-21,0r0,22r21,0xm64,-43r0,-22r-22,0r0,22r22,0xm21,-21r0,22r21,0r0,-22r-21,0xm64,-21r0,22r21,0r0,-22r-21,0xm106,-21r0,22r21,0r0,-22r-21,0xm148,-21r0,22r22,0r0,-22r-22,0xm191,-21r0,22r21,0r0,-22r-21,0xm233,45r0,-22r-21,0r0,22r21,0xm191,45r0,-22r-21,0r0,22r21,0xm148,45r0,-22r-21,0r0,22r21,0xm106,45r0,-22r-21,0r0,22r21,0xm64,45r0,-22r-22,0r0,22r22,0xm21,67r0,22r21,0r0,-22r-21,0xm64,67r0,22r21,0r0,-22r-21,0xm106,67r0,22r21,0r0,-22r-21,0xm148,67r0,22r22,0r0,-22r-22,0xm191,67r0,22r21,0r0,-22r-21,0"},"\u25a0":{"d":"26,-166r166,0r0,166r-166,0r0,-166","w":217},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"112,-167r0,96r-96,0r0,-96r96,0","w":127},"\u25ab":{"d":"112,-167r0,96r-96,0r0,-96r96,0xm98,-153r-68,0r0,68r68,0r0,-68","w":127},"\u25ac":{"d":"0,-124r360,0r0,68r-360,0r0,-68","w":360},"\u25b2":{"d":"53,0r125,-249r125,249r-250,0","w":356},"\u25ba":{"d":"51,-249r255,127r-255,127r0,-254","w":356},"\u25bc":{"d":"303,-244r-125,249r-125,-249r250,0","w":356},"\u25c4":{"d":"306,-249r0,254r-255,-127","w":356},"\u25cb":{"d":"31,-102v2,-43,34,-77,78,-77v44,0,76,33,77,77v1,41,-36,78,-77,78v-41,0,-80,-37,-78,-78xm173,-102v-1,-36,-28,-64,-64,-64v-36,0,-64,26,-64,64v0,35,29,65,64,65v35,0,64,-31,64,-65","w":217},"\u25cf":{"d":"109,-179v41,0,77,36,77,77v0,41,-36,78,-77,78v-41,0,-78,-37,-78,-78v0,-41,37,-77,78,-77","w":217},"\u25d8":{"d":"22,0r0,-172r173,0r0,172r-173,0xm144,-86v0,-19,-16,-36,-35,-36v-19,0,-37,16,-36,36v0,19,17,35,36,35v19,0,35,-16,35,-35","w":217},"\u25d9":{"d":"7,0r0,-203r203,0r0,203r-203,0xm186,-101v-1,-44,-33,-78,-77,-78v-45,0,-76,34,-78,78v-1,41,37,77,78,77v41,0,79,-35,77,-77xm45,-101v0,-38,28,-65,64,-65v36,0,63,28,64,65v0,35,-29,64,-64,64v-35,0,-64,-29,-64,-64","w":217},"\u25e6":{"d":"64,-169v26,0,50,24,50,50v0,27,-23,50,-50,50v-27,0,-50,-22,-50,-50v0,-27,23,-50,50,-50xm64,-82v20,0,37,-17,37,-37v0,-20,-17,-37,-37,-37v-20,0,-37,17,-37,37v0,20,17,37,37,37","w":127},"\u263a":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm276,-91v0,-56,-42,-96,-96,-96v-54,0,-96,40,-96,96v0,55,40,96,96,96v56,0,96,-41,96,-96xm123,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm209,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm232,-55v-15,42,-88,44,-104,0r11,-6v16,34,66,33,82,0","w":360},"\u263b":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm151,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm237,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm128,-55v15,42,88,44,104,0r-11,-6v-16,34,-66,33,-82,0","w":360},"\u263c":{"d":"97,-201v21,-13,34,-22,62,-25r0,-59r13,0r0,59v28,2,42,11,61,25r51,-50r9,9r-50,51v15,18,23,36,25,62r59,0r0,12r-59,0v-2,23,-10,43,-25,62r50,51r-10,9r-49,-50v-21,15,-32,22,-62,25r0,59r-13,0r0,-59v-28,-4,-43,-10,-61,-24r-52,49r-9,-9r50,-51v-14,-18,-22,-35,-25,-62r-59,0r0,-12r59,0v2,-28,10,-43,25,-61r-50,-51r9,-10xm255,-123v0,-52,-39,-90,-90,-90v-51,0,-90,38,-90,90v0,52,38,90,90,90v52,0,90,-38,90,-90","w":329},"\u2640":{"d":"227,-173v2,48,-40,92,-87,92r0,71r81,0r0,10r-81,0r0,77r-10,0r0,-77r-81,0r0,-10r81,0r0,-71v-47,-3,-87,-42,-87,-92v0,-53,39,-92,92,-92v53,0,91,39,92,92xm217,-173v-1,-47,-35,-82,-82,-82v-47,0,-82,35,-83,82v-1,44,38,83,83,83v45,0,83,-38,82,-83","w":270},"\u2642":{"d":"20,-46v-1,-59,58,-109,121,-87r63,-136r-94,47r-4,-10r108,-53r6,3r29,117r-10,3r-25,-102r-63,135v30,15,53,44,53,83v0,52,-40,92,-93,92v-52,0,-90,-39,-91,-92xm194,-46v-2,-47,-35,-82,-83,-82v-48,1,-80,35,-82,82v-1,45,38,83,82,83v44,1,84,-38,83,-83","w":270},"\u2660":{"d":"117,-82v-10,43,-87,45,-84,-5v3,-61,81,-67,85,-129v6,56,81,73,86,128v2,20,-18,40,-39,40v-23,-1,-35,-15,-45,-34v0,50,20,72,67,75r1,7r-139,0r1,-7v46,1,68,-28,67,-75","w":236},"\u2663":{"d":"178,-48v-32,-3,-44,-17,-58,-42v2,56,20,74,72,84r1,6r-149,0r1,-6v52,-7,68,-32,71,-84v-13,52,-106,57,-106,-7v0,-38,36,-63,71,-40v-27,-30,-5,-79,37,-79v41,0,64,47,37,79v31,-22,71,0,71,39v0,27,-20,52,-48,50","w":236},"\u2665":{"d":"118,-172v6,-54,96,-58,96,0v0,72,-83,110,-96,176v-11,-65,-87,-105,-96,-174v-3,-25,21,-47,45,-46v27,1,44,19,51,44","w":236},"\u2666":{"d":"118,4v-26,-44,-41,-62,-81,-110v21,-23,63,-78,81,-111v17,33,60,87,81,111v-17,18,-66,81,-81,110","w":236},"\u266a":{"d":"7,-33v-1,-37,44,-54,78,-35r0,-172v69,-5,91,20,88,87r-17,0v3,-35,-20,-48,-53,-47r0,147v12,65,-94,84,-96,20","w":180},"\u266b":{"d":"15,-17v-1,-38,45,-54,79,-35r0,-171r140,-44r0,195v12,66,-94,79,-97,19v-1,-37,46,-54,79,-36r0,-127r-105,32r0,147v3,41,-20,57,-55,59v-26,1,-41,-15,-41,-39","w":270},"\uf001":{"d":"40,-179v5,-55,34,-78,91,-69r-3,40v-24,-7,-33,3,-38,29r33,0r-7,40r-33,0r-23,139r-51,0r24,-139r-22,0r6,-40r23,0xm201,-244r-8,52r-54,0r8,-52r54,0xm160,0r-53,0r30,-179r54,0","w":196},"\uf002":{"d":"40,-179v3,-52,35,-79,92,-69r-3,40v-26,-5,-35,2,-39,29r32,0r-7,41r-32,0r-23,138r-50,0r23,-138r-23,0r7,-41r23,0xm160,0r-54,0r40,-240r54,0","w":196},"\uf003":{"d":"142,-156r-4,27r-23,0r-6,33r-35,0r6,-33r-66,0r4,-27r73,-86r43,0r-14,86r22,0xm86,-153r10,-61r-52,61r42,0","w":139},"\uf004":{"d":"147,-240r-40,71r-19,0r19,-71r40,0","w":180},"\uf005":{"d":"94,19r-41,68r-19,0r19,-68r41,0","w":180},"\uf00a":{"d":"-50,0r-32,0r173,-241r33,0","w":38},"\uf007":{"d":"101,-147v0,-24,-34,-28,-45,-9r-31,-9r19,-77r101,0r-8,30r-68,0r-7,28v29,-24,78,-1,78,36v0,62,-115,70,-125,11r36,-6v4,26,50,25,50,-4","w":139},"\uf008":{"d":"142,-240r-3,24v-29,23,-61,72,-63,120r-43,0v6,-45,29,-82,69,-114r-77,0r6,-30r111,0","w":139},"\uf009":{"d":"14,-132v0,-18,16,-34,34,-36v-41,-26,-3,-79,43,-74v51,-5,73,53,22,68v16,7,25,19,25,33v3,54,-124,64,-124,9xm112,-202v2,-23,-47,-26,-49,-4v0,9,11,16,32,22v11,-4,17,-10,17,-18xm46,-137v-1,24,55,26,57,3v-3,-16,-19,-17,-35,-24v-12,1,-21,11,-22,21","w":139},"\u00a4":{"d":"19,-48r36,-36v-22,-30,-23,-70,0,-100r-37,-36r22,-23r37,37v31,-21,69,-24,101,-1r36,-36r22,23r-36,36v22,33,23,67,1,100r36,36r-22,22r-36,-36v-32,22,-69,23,-102,0r-36,36xm128,-84v26,0,50,-24,50,-50v0,-26,-24,-50,-50,-50v-26,0,-50,24,-50,50v0,26,24,50,50,50","w":239}}});
