<?php
add_action( 'after_setup_theme', 'register_my_menu' );
function register_my_menu() {
register_nav_menu( 'primary', __( 'Primary Menu', 'chara' ) );
register_nav_menu('second-menu', __('Second Menu'));
}
register_nav_menus( array(
'primary' => __( 'Primary Navigation', 'chara' ),
) );

function shape_scripts() {
wp_enqueue_style( 'style', get_stylesheet_uri() );

}
add_action( 'wp_enqueue_scripts', 'shape_scripts' );
add_filter( 'wp_title', 'wpdocs_hack_wp_title_for_home' );
 
/**
 * Customize the title for the home page, if one is not set.
 *
 * @param string $title The original title.
 * @return string The title to use.
 */
function wpdocs_hack_wp_title_for_home( $title )
{
  if ( empty( $title ) && ( is_home() || is_front_page() ) ) {
    $title = __( 'Home', 'textdomain' ) . ' | ' . get_bloginfo( 'description' );
  }
  return $title;
}
//Create extra fields called Altnative Text and Custom Classess
function my_extra_gallery_fields( $args, $attachment_id, $field ){
    $args['alt'] = array('type' => 'text', 'label' => 'Altnative Text', 'name' => 'alt', 'value' => get_field($field . '_alt', $attachment_id) ); // Creates Altnative Text field
    $args['class'] = array('type' => 'text', 'label' => 'Custom Classess', 'name' => 'class', 'value' => get_field($field . '_class', $attachment_id) ); // Creates Custom Classess field
    return $args;
}
add_filter( 'acf_photo_gallery_image_fields', 'my_extra_gallery_fields', 10, 3 );
add_filter( 'acf_photo_gallery_caption_from_attachment', '__return_true' );
function thumbnail_quality( $quality ) {
    return 100;
}
add_filter( 'jpeg_quality', 'thumbnail_quality' );
add_filter( 'wp_editor_set_quality', 'thumbnail_quality' );