<?php

require_once'./php/klasy/drzewko.php';

class Ochrona extends drzewko
{

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);

		$white = imagecolorallocate($dimg, 245, 245, 245);
		imagefill($dimg, 0, 0, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}

	public function addForm($tab=array(),$akcja='dodaj')
	{
		$new = new generatorFormularzy('Ochrona','./index.php?p=53&a=1','POST','enctype="multipart/form-data"', true);
		$new->poczatekForm();
		$new->inupt('Nazwa PL','nazwa_pl', 'text',$tab['nazwa_pl'],'','textlong');
                $new->inupt('Nazwa EN','tresc_en', 'text',$tab['nazwa_en'],'','textlong');
                $new->select('Kategoria', $this->displayTreeSelect(), $tab['kategoria']);
                $new->text('<br />');
		$new->textarea('Treść PL', 20, 80,'',stripslashes($tab['tresc_pl']),'textlong','tresc_pl');
		$new->text('<br />');
		$new->textarea('Treść EN', 20, 80,'',stripslashes($tab['tresc_en']),'textlong','tresc_en');

		$new->text('<br />');
		$new->inupt('r','r', 'hidden',time(),'','',false);
		$new->inupt('akcja','akcja', 'hidden',$akcja,'','',false);
		if(isset($_GET['nr'])) $new->inupt('id','id', 'hidden',$_GET['nr'],'','',false);
		$new->inupt('ok','ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}

	public function addAction()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');
			Zend_Loader::loadClass('Zend_Filter_StripTags');
			$filtr = new Zend_Filter_StripTags();
                        $db = Zend_Registry::get('db');

			if($_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
			$_SESSION['form'] = $_POST['r'];

			$data = array();

			$data['nazwa_pl'] = $filtr->filter($_POST['nazwa_pl']);
                        $data['nazwa_en'] = $filtr->filter($_POST['nazwa_en']);
                        $data['tresc_pl'] = $filtr->filter($_POST['tresc_pl']);
                        $data['tresc_en'] = $filtr->filter($_POST['tresc_en']);
			$data['kategoria'] = $_POST['kategoria'];

			if($_POST['akcja']=='dodaj')
			{
				$db->insert(Index::dbPrefiks.'bramka', $data);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Strona dodana prawidłowo.'));
				$this->menu();
			}
			else
			{
				$db->update(Index::dbPrefiks.'bramka',$data, 'id='.$_POST['id']);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Treść strony zmieniona prawidłowo.'));
				$this->menu();
			}
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function listaAdmin()
	{
		$smarty = Zend_Registry::get('smarty');
		try
		{
			$sql="SELECT * FROM ".Index::dbPrefiks."bramka a ORDER BY a.id ASC";
			$configBaza = Zend_Registry::get('configBaza');

			$db = Zend_Registry::get('db');

			$result = $db->fetchAll($sql);
			$resultCount = count($result);

			$lista = array();

			for($count=0;$count<$resultCount;$count++)
			{
				$lista[$count] = $result[$count];
				$lista[$count]['path'] = $this->pathToNode($result[$count]['ac'], 2);
			}

			$smarty->assign('lista', $lista);

		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p=53&a=2';
		$submenu[0]['tekst'] = 'Dodaj nowy tekst ochronny';

		$smarty->assign('submenu', $submenu);
		$this->listaAdmin();
	}

	public function usunAction()
	{
		if(!empty($_GET['nr']))
		{
			$id = (int)$_GET['nr'];
			try
			{
				$smarty = Zend_Registry::get('smarty');
				$configBaza = Zend_Registry::get('configBaza');
				$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
				Zend_Db_Table::setDefaultAdapter($db);
				$db->delete(''.Index::dbPrefiks.'bramka', 'id='.$id);

				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Czynność została wykonana poprawnie.'));
				$this->listaAdmin();
			}

			catch (Zend_Db_Adapter_Exception $e)
			{
				przechwyc_blad($e);
			}

			catch (Zend_Exception $e)
			{
				przechwyc_blad($e);
			}
		}
	}

	public function edycjaForm()
	{
		try
		{
			$sql="SELECT * FROM ".Index::dbPrefiks."bramka WHERE id=".(int)$_GET['nr'];

			$db = Zend_Registry::get('db');

			$result = $db->fetchRow($sql);

			$this->addForm($result, 'zapisz');
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			przechwyc_blad($e);
		}
	}
	function widAction(){
		$smarty = Zend_Registry::get('smarty');
		$sql="SELECT * FROM ".Index::dbPrefiks."bramka WHERE id=".(int)$_GET['nr'];
		$db = Zend_Registry::get('db');
		$result = $db->fetchRow($sql);

		switch($result['widoczny']){
			case 1:
				$wid = 0;
				break;
			case 0:
				$wid = 1;
				break;
		}
		$db->update(Index::dbPrefiks."bramka",array('widoczny'=>$wid),'id='.(int)$_GET['nr']);
		$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Akcja wykonana prawidłowo.'));
		$this->menu();
	}

}

?>